/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameterObject;

import com.intellij.DynamicBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.introduceParameterObject.IntroduceParameterObjectClassDescriptor;
import com.intellij.refactoring.introduceParameterObject.IntroduceParameterObjectDelegate;
import com.intellij.refactoring.introduceParameterObject.IntroduceParameterObjectProcessor;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.AbstractParameterTablePanel;
import com.intellij.refactoring.util.AbstractVariableData;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractIntroduceParameterObjectDialog<M extends PsiNamedElement, P extends ParameterInfo, C extends IntroduceParameterObjectClassDescriptor<M, P>, V extends AbstractVariableData>
extends RefactoringDialog {
    protected M mySourceMethod;
    private JPanel myWholePanel;
    private JTextField mySourceMethodTextField;
    protected JCheckBox myDelegateCheckBox;
    private JPanel myParamsPanel;
    private JPanel myParameterClassPanel;
    protected AbstractParameterTablePanel<V> myParameterTablePanel;

    protected abstract String getSourceMethodPresentation();

    protected abstract JPanel createParameterClassPanel();

    protected abstract AbstractParameterTablePanel<V> createParametersPanel();

    protected abstract C createClassDescriptor();

    protected boolean isDelegateCheckboxVisible() {
        return true;
    }

    public AbstractIntroduceParameterObjectDialog(M method2) {
        super(method2.getProject(), true);
        this.mySourceMethod = method2;
        this.$$$setupUI$$$();
        this.setTitle(RefactoringBundle.message((String)"refactoring.introduce.parameter.object.title"));
    }

    @Override
    protected void doAction() {
        IntroduceParameterObjectDelegate delegate = IntroduceParameterObjectDelegate.findDelegate(this.mySourceMethod);
        List allMethodParameters = delegate.getAllMethodParameters(this.mySourceMethod);
        this.invokeRefactoring(new IntroduceParameterObjectProcessor(this.mySourceMethod, this.createClassDescriptor(), allMethodParameters, this.keepMethodAsDelegate()));
    }

    @Override
    protected void canRun() throws ConfigurationException {
        if (!this.hasParametersToExtract()) {
            throw new ConfigurationException("Nothing found to extract");
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.mySourceMethodTextField.setText(this.getSourceMethodPresentation());
        this.mySourceMethodTextField.setEditable(false);
        this.myDelegateCheckBox.setVisible(this.isDelegateCheckboxVisible());
        this.myParameterTablePanel = this.createParametersPanel();
        this.myParamsPanel.add(this.myParameterTablePanel, "Center");
        this.myParameterClassPanel.add((Component)this.createParameterClassPanel(), "Center");
        return this.myWholePanel;
    }

    protected boolean keepMethodAsDelegate() {
        return this.myDelegateCheckBox.isSelected();
    }

    public boolean hasParametersToExtract() {
        for (AbstractVariableData info : this.myParameterTablePanel.getVariableData()) {
            if (!info.passAsParameter) continue;
            return true;
        }
        return false;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JTextField jTextField;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myWholePanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "");
        this.myParameterClassPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/RefactoringBundle", AbstractIntroduceParameterObjectDialog.class).getString("border.title.introduce.parameter.class"), (int)0, (int)0, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/RefactoringBundle", AbstractIntroduceParameterObjectDialog.class).getString("refactoring.introduce.parameter.object.method.to.extract.parameters.from.label"), (int)0, (int)0, null, null));
        this.mySourceMethodTextField = jTextField = new JTextField();
        jPanel4.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(400, -1), null));
        this.myDelegateCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/RefactoringBundle", AbstractIntroduceParameterObjectDialog.class).getString("checkbox.introduce.parameter.object.keep.method.as.delegate"));
        jPanel4.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myParamsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 6, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/RefactoringBundle", AbstractIntroduceParameterObjectDialog.class).getString("border.title.introduce.parameters.to.extract"), (int)0, (int)0, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

