/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.refactoring.ui.CodeFragmentTableCellEditorBase;
import com.intellij.refactoring.ui.CodeFragmentTableCellRenderer;
import com.intellij.refactoring.ui.StringTableCellEditor;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.RowEditableTableModel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nullable;

public abstract class ParameterTableModelBase<P extends ParameterInfo, TableItem extends ParameterTableModelItemBase<P>>
extends ListTableModel<TableItem>
implements RowEditableTableModel {
    protected final PsiElement myTypeContext;
    protected final PsiElement myDefaultValueContext;

    public ParameterTableModelBase(PsiElement typeContext, PsiElement defaultValueContext, ColumnInfo ... columnInfos) {
        super(columnInfos);
        this.myTypeContext = typeContext;
        this.myDefaultValueContext = defaultValueContext;
    }

    protected abstract TableItem createRowItem(@Nullable P var1);

    public void addRow() {
        this.addRow(this.createRowItem(null));
    }

    public void setParameterInfos(List<? extends P> parameterInfos) {
        ArrayList<TableItem> items = new ArrayList<TableItem>(parameterInfos.size());
        for (ParameterInfo parameterInfo : parameterInfos) {
            items.add(this.createRowItem(parameterInfo));
        }
        this.setItems(items);
    }

    public void setValueAtWithoutUpdate(Object aValue, int rowIndex, int columnIndex) {
        this.setValueAt(aValue, rowIndex, columnIndex, false);
    }

    protected static class AnyVarColumn<P extends ParameterInfo, TableItem extends ParameterTableModelItemBase<P>>
    extends ColumnInfoBase<P, TableItem, Boolean> {
        public AnyVarColumn() {
            super(RefactoringBundle.message((String)"column.name.any.var"));
        }

        public boolean isCellEditable(TableItem item) {
            return !((ParameterTableModelItemBase)item).isEllipsisType() && ((ParameterInfo)((ParameterTableModelItemBase)item).parameter).isNew();
        }

        public Boolean valueOf(TableItem item) {
            return ((ParameterInfo)((ParameterTableModelItemBase)item).parameter).isUseAnySingleVariable();
        }

        public void setValue(TableItem item, Boolean value2) {
            ((ParameterInfo)((ParameterTableModelItemBase)item).parameter).setUseAnySingleVariable(value2.booleanValue());
        }

        @Override
        public TableCellRenderer doCreateRenderer(TableItem item) {
            return new BooleanTableCellRenderer();
        }

        @Override
        public TableCellEditor doCreateEditor(TableItem item) {
            return new BooleanTableCellEditor(false);
        }

        public int getWidth(JTable table) {
            int headerWidth = table.getFontMetrics(table.getFont()).stringWidth(this.getName()) + 8;
            return Math.max(new JCheckBox().getPreferredSize().width, headerWidth);
        }
    }

    protected static class DefaultValueColumn<P extends ParameterInfo, TableItem extends ParameterTableModelItemBase<P>>
    extends ColumnInfoBase<P, TableItem, PsiCodeFragment> {
        private final Project myProject;
        private final FileType myFileType;

        public DefaultValueColumn(Project project, FileType fileType) {
            this(project, fileType, RefactoringBundle.message((String)"column.name.default.value"));
        }

        public DefaultValueColumn(Project project, FileType fileType, String title) {
            super(title);
            this.myProject = project;
            this.myFileType = fileType;
        }

        public boolean isCellEditable(TableItem item) {
            return !((ParameterTableModelItemBase)item).isEllipsisType() && ((ParameterInfo)((ParameterTableModelItemBase)item).parameter).isNew();
        }

        public PsiCodeFragment valueOf(TableItem item) {
            return ((ParameterTableModelItemBase)item).defaultValueCodeFragment;
        }

        @Override
        public TableCellRenderer doCreateRenderer(TableItem item) {
            return new CodeFragmentTableCellRenderer(this.myProject, this.myFileType);
        }

        @Override
        public TableCellEditor doCreateEditor(TableItem item) {
            return new CodeFragmentTableCellEditorBase(this.myProject, this.myFileType);
        }
    }

    protected static class NameColumn<P extends ParameterInfo, TableItem extends ParameterTableModelItemBase<P>>
    extends ColumnInfoBase<P, TableItem, String> {
        private final Project myProject;

        public NameColumn(Project project) {
            this(project, RefactoringBundle.message((String)"column.name.name"));
        }

        public NameColumn(Project project, String title) {
            super(title);
            this.myProject = project;
        }

        public String valueOf(TableItem item) {
            return ((ParameterInfo)((ParameterTableModelItemBase)item).parameter).getName();
        }

        public void setValue(TableItem item, String value2) {
            ((ParameterInfo)((ParameterTableModelItemBase)item).parameter).setName(value2);
        }

        public boolean isCellEditable(TableItem pParameterTableModelItemBase) {
            return true;
        }

        @Override
        public TableCellRenderer doCreateRenderer(TableItem item) {
            return new ColoredTableCellRenderer(){

                public void customizeCellRenderer(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                    if (value2 == null) {
                        return;
                    }
                    this.append((String)value2, new SimpleTextAttributes(0, null));
                }
            };
        }

        @Override
        public TableCellEditor doCreateEditor(TableItem o) {
            return new StringTableCellEditor(this.myProject);
        }
    }

    protected static class TypeColumn<P extends ParameterInfo, TableItem extends ParameterTableModelItemBase<P>>
    extends ColumnInfoBase<P, TableItem, PsiCodeFragment> {
        protected final Project myProject;
        private final FileType myFileType;

        public TypeColumn(Project project, FileType fileType) {
            this(project, fileType, RefactoringBundle.message((String)"column.name.type"));
        }

        public TypeColumn(Project project, FileType fileType, String title) {
            super(title);
            this.myProject = project;
            this.myFileType = fileType;
        }

        public PsiCodeFragment valueOf(TableItem item) {
            return ((ParameterTableModelItemBase)item).typeCodeFragment;
        }

        public boolean isCellEditable(TableItem pParameterTableModelItemBase) {
            return true;
        }

        @Override
        public TableCellRenderer doCreateRenderer(TableItem pParameterTableModelItemBase) {
            return new CodeFragmentTableCellRenderer(this.myProject, this.myFileType);
        }

        @Override
        public TableCellEditor doCreateEditor(TableItem o) {
            return new CodeFragmentTableCellEditorBase(this.myProject, this.myFileType);
        }
    }

    protected static abstract class ColumnInfoBase<P extends ParameterInfo, TableItem extends ParameterTableModelItemBase<P>, Aspect>
    extends ColumnInfo<TableItem, Aspect> {
        private TableCellRenderer myRenderer;
        private TableCellEditor myEditor;

        public ColumnInfoBase(String name) {
            super(name);
        }

        public final TableCellEditor getEditor(TableItem o) {
            if (this.myEditor == null) {
                this.myEditor = this.doCreateEditor(o);
            }
            return this.myEditor;
        }

        public final TableCellRenderer getRenderer(TableItem item) {
            if (this.myRenderer == null) {
                final TableCellRenderer original = this.doCreateRenderer(item);
                this.myRenderer = new TableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                        Component component2 = original.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
                        if (!table.isCellEditable(row, table.convertColumnIndexToModel(column))) {
                            Color bg = table.getBackground().darker();
                            component2.setBackground(ColorUtil.toAlpha((Color)bg, (int)230));
                        }
                        if (component2 instanceof SimpleColoredComponent) {
                            ((SimpleColoredComponent)component2).setIpad(new Insets(0, 0, 0, 0));
                        }
                        return component2;
                    }
                };
            }
            return this.myRenderer;
        }

        protected abstract TableCellRenderer doCreateRenderer(TableItem var1);

        protected abstract TableCellEditor doCreateEditor(TableItem var1);
    }
}

