/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.SmartStripTrailingSpacesFilter;
import com.intellij.openapi.editor.StripTrailingSpacesFilter;
import com.intellij.openapi.editor.StripTrailingSpacesFilterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeepTrailingSpacesOnEmptyLinesFilterFactory
extends StripTrailingSpacesFilterFactory {
    @NotNull
    public StripTrailingSpacesFilter createFilter(@Nullable Project project, @NotNull Document document) {
        if (document == null) {
            KeepTrailingSpacesOnEmptyLinesFilterFactory.$$$reportNull$$$0(0);
        }
        if (project != null && KeepTrailingSpacesOnEmptyLinesFilterFactory.shouldKeepTrailingSpacesOnEmptyLines(project, document)) {
            return new KeepTrailingSpacesOnEmptyLinesFilter(document);
        }
        StripTrailingSpacesFilter stripTrailingSpacesFilter = StripTrailingSpacesFilter.ALL_LINES;
        if (stripTrailingSpacesFilter == null) {
            KeepTrailingSpacesOnEmptyLinesFilterFactory.$$$reportNull$$$0(1);
        }
        return stripTrailingSpacesFilter;
    }

    private static boolean shouldKeepTrailingSpacesOnEmptyLines(@NotNull Project project, @NotNull Document document) {
        PsiFile file2;
        if (project == null) {
            KeepTrailingSpacesOnEmptyLinesFilterFactory.$$$reportNull$$$0(2);
        }
        if (document == null) {
            KeepTrailingSpacesOnEmptyLinesFilterFactory.$$$reportNull$$$0(3);
        }
        if ((file2 = PsiDocumentManager.getInstance((Project)project).getCachedPsiFile(document)) != null) {
            CommonCodeStyleSettings settings = CodeStyle.getLanguageSettings((PsiFile)file2);
            CommonCodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptions();
            return indentOptions != null && indentOptions.KEEP_INDENTS_ON_EMPTY_LINES;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/KeepTrailingSpacesOnEmptyLinesFilterFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/KeepTrailingSpacesOnEmptyLinesFilterFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFilter";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "shouldKeepTrailingSpacesOnEmptyLines";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class KeepTrailingSpacesOnEmptyLinesFilter
    extends SmartStripTrailingSpacesFilter {
        @NotNull
        private final Document myDocument;

        KeepTrailingSpacesOnEmptyLinesFilter(@NotNull Document document) {
            if (document == null) {
                KeepTrailingSpacesOnEmptyLinesFilter.$$$reportNull$$$0(0);
            }
            this.myDocument = document;
        }

        public int getTrailingSpacesToLeave(int line) {
            int startOffset = this.myDocument.getLineStartOffset(line);
            int endOffset = this.myDocument.getLineEndOffset(line);
            return KeepTrailingSpacesOnEmptyLinesFilter.containsWhitespacesOnly(this.myDocument.getCharsSequence(), startOffset, endOffset) ? this.getMaxIndentChars(line) : 0;
        }

        private static boolean containsWhitespacesOnly(@NotNull CharSequence chars, int start2, int end) {
            if (chars == null) {
                KeepTrailingSpacesOnEmptyLinesFilter.$$$reportNull$$$0(1);
            }
            for (int i = start2; i < end; ++i) {
                char c = chars.charAt(i);
                if (c == ' ' || c == '\t' || c == '\n' || c == '\r') continue;
                return false;
            }
            return true;
        }

        private int getMaxIndentChars(int line) {
            int lineAfter;
            int lineBefore = this.getNonEmptyLineBefore(line);
            int indentCharCount = -1;
            if (lineBefore >= 0) {
                indentCharCount = this.countIndentCharsAt(lineBefore);
            }
            if ((lineAfter = this.getNonEmptyLineAfter(line)) >= 0) {
                indentCharCount = Math.max(indentCharCount, this.countIndentCharsAt(lineAfter));
            }
            return indentCharCount;
        }

        private int getNonEmptyLineBefore(int line) {
            CharSequence docChars = this.myDocument.getCharsSequence();
            for (int lineBefore = line - 1; lineBefore >= 0; --lineBefore) {
                if (KeepTrailingSpacesOnEmptyLinesFilter.containsWhitespacesOnly(docChars, this.myDocument.getLineStartOffset(lineBefore), this.myDocument.getLineEndOffset(lineBefore))) continue;
                return lineBefore;
            }
            return -1;
        }

        private int getNonEmptyLineAfter(int line) {
            CharSequence docChars = this.myDocument.getCharsSequence();
            for (int lineAfter = line + 1; lineAfter < this.myDocument.getLineCount(); ++lineAfter) {
                if (KeepTrailingSpacesOnEmptyLinesFilter.containsWhitespacesOnly(docChars, this.myDocument.getLineStartOffset(lineAfter), this.myDocument.getLineEndOffset(lineAfter))) continue;
                return lineAfter;
            }
            return -1;
        }

        private int countIndentCharsAt(int line) {
            char c;
            int count = 0;
            CharSequence docChars = this.myDocument.getCharsSequence();
            for (int offset = this.myDocument.getLineStartOffset(line); offset < this.myDocument.getTextLength() && ((c = docChars.charAt(offset)) == ' ' || c == '\t'); ++offset) {
                ++count;
            }
            return count;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chars";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/codeStyle/KeepTrailingSpacesOnEmptyLinesFilterFactory$KeepTrailingSpacesOnEmptyLinesFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "containsWhitespacesOnly";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

