/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.pluginsAdvertisement;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.PlainTextLikeFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeature;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeaturesCollector;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginAdvertiserEditorNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(PluginsAdvertiser.class);
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"file.type.associations.detected");
    private final Set<String> myEnabledExtensions = new HashSet<String>();

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            PluginAdvertiserEditorNotificationProvider.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (file2 == null) {
            PluginAdvertiserEditorNotificationProvider.$$$reportNull$$$0(1);
        }
        if (fileEditor == null) {
            PluginAdvertiserEditorNotificationProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            PluginAdvertiserEditorNotificationProvider.$$$reportNull$$$0(3);
        }
        boolean alreadySupported = !(file2.getFileType() instanceof PlainTextLikeFileType);
        String extension = (String)ObjectUtils.doIfNotNull((Object)file2.getExtension(), fileExt -> "*." + fileExt);
        String fileName = file2.getName();
        if (extension != null && this.isIgnored(extension, project)) {
            LOG.debug(String.format("Extension '%s' is ignored in project '%s'", extension, project.getName()));
            return null;
        }
        if (this.isIgnored(fileName, project)) {
            LOG.debug(String.format("File '%s' is ignored in project '%s'", fileName, project.getName()));
            return null;
        }
        PluginsAdvertiser.KnownExtensions knownExtensions = PluginsAdvertiser.loadExtensions();
        if (knownExtensions != null) {
            EditorNotificationPanel panel2;
            if (alreadySupported) {
                Set<PluginsAdvertiser.Plugin> availablePlugins = knownExtensions.find(fileName);
                if (availablePlugins != null) {
                    Set plugins2 = ContainerUtil.map2Set(availablePlugins, plugin -> plugin.myPluginId);
                    for (IdeaPluginDescriptor ideaPluginDescriptor : PluginManagerCore.getLoadedPlugins()) {
                        if (!ideaPluginDescriptor.isEnabled() || !plugins2.contains(ideaPluginDescriptor.getPluginId().getIdString())) continue;
                        LOG.debug(String.format("File '%s' (type: '%s') is already supported by fileName via '%s'(id: '%s') plugin", fileName, file2.getFileType(), ideaPluginDescriptor.getName(), ideaPluginDescriptor.getPluginId().getIdString()));
                        return null;
                    }
                }
                LOG.debug(String.format("File '%s' (type: '%s') is already supported therefore looking only for plugins exactly matching fileName", fileName, file2.getFileType()));
                return this.createPanel(fileName, knownExtensions, project);
            }
            EditorNotificationPanel editorNotificationPanel = panel2 = extension != null ? this.createPanel(extension, knownExtensions, project) : null;
            if (panel2 != null) {
                return panel2;
            }
            return this.createPanel(fileName, knownExtensions, project);
        }
        LOG.debug("No known extensions loaded");
        return null;
    }

    private boolean isIgnored(String extension, @NotNull Project project) {
        if (project == null) {
            PluginAdvertiserEditorNotificationProvider.$$$reportNull$$$0(4);
        }
        return this.myEnabledExtensions.contains(extension) || UnknownFeaturesCollector.getInstance(project).isIgnored(PluginAdvertiserEditorNotificationProvider.createExtensionFeature(extension));
    }

    @Nullable
    private EditorNotificationPanel createPanel(@NotNull String extension, @NotNull PluginsAdvertiser.KnownExtensions knownExtensions, @NotNull Project project) {
        Set<PluginsAdvertiser.Plugin> plugins2;
        if (extension == null) {
            PluginAdvertiserEditorNotificationProvider.$$$reportNull$$$0(5);
        }
        if (knownExtensions == null) {
            PluginAdvertiserEditorNotificationProvider.$$$reportNull$$$0(6);
        }
        if (project == null) {
            PluginAdvertiserEditorNotificationProvider.$$$reportNull$$$0(7);
        }
        if ((plugins2 = knownExtensions.find(extension)) != null && !plugins2.isEmpty()) {
            List pluginIds = ContainerUtil.map(plugins2, plugin -> plugin.myPluginId);
            LOG.debug(String.format("Found following plugins for '%s': [%s]", extension, StringUtil.join((Collection)pluginIds, (String)",")));
            return this.createPanel(extension, plugins2, project);
        }
        LOG.debug("No plugins for extension " + extension);
        return null;
    }

    @Nullable
    private EditorNotificationPanel createPanel(@NotNull String extension, @NotNull Set<? extends PluginsAdvertiser.Plugin> plugins2, @NotNull Project project) {
        if (extension == null) {
            PluginAdvertiserEditorNotificationProvider.$$$reportNull$$$0(8);
        }
        if (plugins2 == null) {
            PluginAdvertiserEditorNotificationProvider.$$$reportNull$$$0(9);
        }
        if (project == null) {
            PluginAdvertiserEditorNotificationProvider.$$$reportNull$$$0(10);
        }
        EditorNotificationPanel panel2 = new EditorNotificationPanel();
        panel2.setText(IdeBundle.message((String)"plugins.advertiser.plugins.found", (Object[])new Object[]{extension}));
        IdeaPluginDescriptor disabledPlugin = PluginsAdvertiser.getDisabledPlugin(plugins2);
        if (disabledPlugin != null) {
            panel2.createActionLabel(IdeBundle.message((String)"plugins.advertiser.action.enable.plugin", (Object[])new Object[]{disabledPlugin.getName()}), () -> {
                this.myEnabledExtensions.add(extension);
                EditorNotifications.getInstance((Project)project).updateAllNotifications();
                FeatureUsageData data2 = new FeatureUsageData().addData("source", "editor").addData("plugins", Collections.singletonList(disabledPlugin.getPluginId().getIdString()));
                FUCounterUsageLogger.getInstance().logEvent("plugins.advertiser", "enable.plugins", data2);
                PluginsAdvertiser.enablePlugins(project, Collections.singletonList(disabledPlugin));
            });
        } else if (PluginAdvertiserEditorNotificationProvider.hasNonBundledPlugin(plugins2)) {
            panel2.createActionLabel(IdeBundle.message((String)"plugins.advertiser.action.install.plugins", (Object[])new Object[0]), () -> {
                HashSet<PluginId> pluginIds = new HashSet<PluginId>();
                for (PluginsAdvertiser.Plugin plugin : plugins2) {
                    pluginIds.add(PluginId.getId((String)plugin.myPluginId));
                }
                FeatureUsageData data2 = new FeatureUsageData().addData("source", "editor").addData("plugins", ContainerUtil.map(pluginIds, pluginId -> pluginId.getIdString()));
                FUCounterUsageLogger.getInstance().logEvent("plugins.advertiser", "install.plugins", data2);
                PluginsAdvertiser.installAndEnable(pluginIds, () -> {
                    this.myEnabledExtensions.add(extension);
                    EditorNotifications.getInstance((Project)project).updateAllNotifications();
                });
            });
        } else if (PluginsAdvertiser.hasBundledPluginToInstall(plugins2) != null) {
            if (PropertiesComponent.getInstance().isTrueValue("ignoreUltimateEdition")) {
                return null;
            }
            panel2.setText(IdeBundle.message((String)"plugins.advertiser.extensions.supported.in.ultimate", (Object[])new Object[]{extension}));
            panel2.createActionLabel(IdeBundle.message((String)"plugins.advertiser.action.try.ultimate", (Object[])new Object[0]), () -> {
                this.myEnabledExtensions.add(extension);
                FeatureUsageData data2 = new FeatureUsageData().addData("source", "editor");
                FUCounterUsageLogger.getInstance().logEvent("plugins.advertiser", "open.download.page", data2);
                PluginsAdvertiser.openDownloadPage();
            });
            panel2.createActionLabel(IdeBundle.message((String)"plugins.advertiser.action.ignore.ultimate", (Object[])new Object[0]), () -> {
                FeatureUsageData data2 = new FeatureUsageData().addData("source", "editor");
                FUCounterUsageLogger.getInstance().logEvent("plugins.advertiser", "ignore.ultimate", data2);
                PropertiesComponent.getInstance().setValue("ignoreUltimateEdition", "true");
                EditorNotifications.getInstance((Project)project).updateAllNotifications();
            });
        } else {
            return null;
        }
        panel2.createActionLabel(IdeBundle.message((String)"plugins.advertiser.action.ignore.extension", (Object[])new Object[0]), () -> {
            FeatureUsageData data2 = new FeatureUsageData().addData("source", "editor");
            FUCounterUsageLogger.getInstance().logEvent("plugins.advertiser", "ignore.extensions", data2);
            UnknownFeaturesCollector.getInstance(project).ignoreFeature(PluginAdvertiserEditorNotificationProvider.createExtensionFeature(extension));
            EditorNotifications.getInstance((Project)project).updateAllNotifications();
        });
        return panel2;
    }

    private static boolean hasNonBundledPlugin(Set<? extends PluginsAdvertiser.Plugin> plugins2) {
        for (PluginsAdvertiser.Plugin plugin : plugins2) {
            if (plugin.myBundled) continue;
            return true;
        }
        return false;
    }

    private static UnknownFeature createExtensionFeature(String extension) {
        return new UnknownFeature(FileTypeFactory.FILE_TYPE_FACTORY_EP.getName(), "File Type", extension, extension);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserEditorNotificationProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "knownExtensions";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserEditorNotificationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

