/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.HTMLEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.updateSettings.UpdateStrategyCustomization;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.ExternalUpdateManager;
import com.intellij.openapi.updateSettings.impl.IdeUpdateUsageTriggerCollector;
import com.intellij.openapi.updateSettings.impl.Product;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateInstaller;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.updateSettings.impl.UpdatesInfo;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.LineSeparator;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

final class UpdateCheckerComponent {
    static final String SELF_UPDATE_STARTED_FOR_BUILD_PROPERTY = "ide.self.update.started.for.build";
    static final String UPDATE_WHATS_NEW_MESSAGE = "ide.update.whats.new.message";
    private static final Logger LOG = Logger.getInstance(UpdateCheckerComponent.class);
    private static final long CHECK_INTERVAL = 86400000L;
    private static final String ERROR_LOG_FILE_NAME = "idea_updater_error.log";
    private volatile ScheduledFuture<?> myScheduledCheck;

    UpdateCheckerComponent() {
    }

    public static UpdateCheckerComponent getInstance() {
        return (UpdateCheckerComponent)ApplicationManager.getApplication().getService(UpdateCheckerComponent.class);
    }

    public void queueNextCheck() {
        this.queueNextCheck(86400000L);
    }

    public void cancelChecks() {
        ScheduledFuture<?> future2 = this.myScheduledCheck;
        if (future2 != null) {
            future2.cancel(false);
        }
    }

    private static void showWhatsNewNotification(final @NotNull Project project) {
        PropertiesComponent properties;
        String updateHtmlMessage;
        if (project == null) {
            UpdateCheckerComponent.$$$reportNull$$$0(0);
        }
        if ((updateHtmlMessage = (properties = PropertiesComponent.getInstance()).getValue(UPDATE_WHATS_NEW_MESSAGE)) == null) {
            LOG.warn("Cannot show what's new notification: no content found.");
            return;
        }
        String title = IdeBundle.message((String)"update.whats.new.notification.title", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
        UpdateChecker.getNotificationGroup().createNotification(title, null, null, NotificationType.INFORMATION).addAction((AnAction)new NotificationAction(IdeBundle.message((String)"update.whats.new.notification.action", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    1.$$$reportNull$$$0(1);
                }
                LightVirtualFile file2 = new LightVirtualFile(IdeBundle.message((String)"update.whats.new.file.name", (Object[])new Object[]{ApplicationInfo.getInstance().getFullVersion()}), (CharSequence)updateHtmlMessage);
                file2.putUserData(HTMLEditorProvider.Companion.getHTML_CONTENT_TYPE(), (Object)true);
                FileEditorManager.getInstance((Project)project).openFile((VirtualFile)file2, true);
                IdeUpdateUsageTriggerCollector.trigger("update.whats.new");
                notification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/updateSettings/impl/UpdateCheckerComponent$1";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).notify(project);
        properties.setValue(UPDATE_WHATS_NEW_MESSAGE, null);
    }

    private static boolean checkIfPreviousUpdateFailed() {
        PropertiesComponent properties = PropertiesComponent.getInstance();
        if (ApplicationInfo.getInstance().getBuild().asString().equals(properties.getValue(SELF_UPDATE_STARTED_FOR_BUILD_PROPERTY)) && new File(PathManager.getLogPath(), ERROR_LOG_FILE_NAME).length() > 0L) {
            IdeUpdateUsageTriggerCollector.trigger("update.failed");
            LOG.info("The previous IDE update failed");
            return false;
        }
        properties.setValue(SELF_UPDATE_STARTED_FOR_BUILD_PROPERTY, null);
        return true;
    }

    private static void updateDefaultChannel(@NotNull UpdateSettings settings) {
        if (settings == null) {
            UpdateCheckerComponent.$$$reportNull$$$0(1);
        }
        ChannelStatus current2 = settings.getSelectedChannelStatus();
        LOG.info("channel: " + current2.getCode());
        boolean eap = ApplicationInfoEx.getInstanceEx().isMajorEAP();
        if (eap && current2 != ChannelStatus.EAP && UpdateStrategyCustomization.getInstance().forceEapUpdateChannelForEapBuilds()) {
            settings.setSelectedChannelStatus(ChannelStatus.EAP);
            LOG.info("channel forced to 'eap'");
            if (!ConfigImportHelper.isFirstSession()) {
                String title = IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]);
                String message = IdeBundle.message((String)"update.channel.enforced", (Object[])new Object[]{ChannelStatus.EAP});
                UpdateChecker.getNotificationGroup().createNotification(title, message, NotificationType.INFORMATION, null).notify(null);
            }
        }
        if (!eap && current2 == ChannelStatus.EAP && ConfigImportHelper.isConfigImported()) {
            settings.setSelectedChannelStatus(ChannelStatus.RELEASE);
            LOG.info("channel set to 'release'");
        }
    }

    private static void scheduleFirstCheck(@NotNull UpdateSettings settings) {
        if (settings == null) {
            UpdateCheckerComponent.$$$reportNull$$$0(2);
        }
        BuildNumber currentBuild = ApplicationInfo.getInstance().getBuild();
        BuildNumber lastBuildChecked = BuildNumber.fromString((String)settings.getLastBuildChecked());
        long timeSinceLastCheck = Math.max(System.currentTimeMillis() - settings.getLastTimeChecked(), 0L);
        if (lastBuildChecked == null || currentBuild.compareTo(lastBuildChecked) > 0 || timeSinceLastCheck >= 86400000L) {
            UpdateCheckerComponent.checkUpdates();
        } else {
            UpdateCheckerComponent.getInstance().queueNextCheck(86400000L - timeSinceLastCheck);
        }
    }

    private void queueNextCheck(long delay) {
        this.myScheduledCheck = AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> UpdateCheckerComponent.checkUpdates(), delay, TimeUnit.MILLISECONDS);
    }

    private static void checkUpdates() {
        UpdateChecker.updateAndShowResult().doWhenProcessed(() -> UpdateCheckerComponent.getInstance().queueNextCheck(86400000L));
    }

    private static void snapPackageNotification(@NotNull UpdateSettings settings) {
        Product product;
        if (settings == null) {
            UpdateCheckerComponent.$$$reportNull$$$0(3);
        }
        if (ExternalUpdateManager.ACTUAL != ExternalUpdateManager.SNAP) {
            return;
        }
        BuildNumber currentBuild = ApplicationInfo.getInstance().getBuild();
        BuildNumber lastBuildChecked = BuildNumber.fromString((String)settings.getLastBuildChecked());
        if (lastBuildChecked == null) {
            UpdateSettings.getInstance().saveLastCheckedInfo();
            return;
        }
        if (currentBuild.equals((Object)lastBuildChecked)) {
            return;
        }
        UpdatesInfo updatesInfo = null;
        try {
            updatesInfo = UpdateChecker.getUpdatesInfo();
        }
        catch (IOException | JDOMException e) {
            LOG.warn(e);
        }
        String blogPost = null;
        if (updatesInfo != null && (product = updatesInfo.get(currentBuild.getProductCode())) != null) {
            block2: for (UpdateChannel channel : product.getChannels()) {
                for (BuildInfo build2 : channel.getBuilds()) {
                    if (!currentBuild.equals((Object)build2.getNumber())) continue;
                    blogPost = build2.getBlogPost();
                    break block2;
                }
            }
        }
        String title = IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]);
        String message = blogPost == null ? IdeBundle.message((String)"update.snap.message", (Object[])new Object[0]) : IdeBundle.message((String)"update.snap.message.with.blog.post", (Object[])new Object[]{StringUtil.escapeXmlEntities(blogPost)});
        UpdateChecker.getNotificationGroup().createNotification(title, message, NotificationType.INFORMATION, NotificationListener.URL_OPENING_LISTENER).notify(null);
        UpdateSettings.getInstance().saveLastCheckedInfo();
    }

    private static void showUpdatedPluginsNotification(@NotNull Project project) {
        if (project == null) {
            UpdateCheckerComponent.$$$reportNull$$$0(4);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            @Override
            public void appWillBeClosed(boolean isRestart) {
                Collection<PluginId> plugins2 = InstalledPluginsState.getInstance().getUpdatedPlugins();
                if (plugins2.isEmpty()) {
                    return;
                }
                Set list2 = UpdateCheckerComponent.getUpdatedPlugins();
                for (PluginId plugin : plugins2) {
                    list2.add(plugin.getIdString());
                }
                try {
                    FileUtil.writeToFile((File)UpdateCheckerComponent.getUpdatedPluginsFile(), (String)StringUtil.join((Collection)list2, (String)LineSeparator.getSystemLineSeparator().getSeparatorString()));
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            }
        });
        Set<String> list2 = UpdateCheckerComponent.getUpdatedPlugins();
        if (list2.isEmpty()) {
            return;
        }
        ArrayList<IdeaPluginDescriptor> descriptors = new ArrayList<IdeaPluginDescriptor>();
        for (String id2 : list2) {
            IdeaPluginDescriptor descriptor3;
            PluginId pluginId = PluginId.findId((String[])new String[]{id2});
            if (pluginId == null || (descriptor3 = PluginManagerCore.getPlugin(pluginId)) == null) continue;
            descriptors.add(descriptor3);
        }
        if (descriptors.isEmpty()) {
            return;
        }
        String title = IdeBundle.message((String)"update.installed.notification.title", (Object[])new Object[0]);
        String message = "<html>" + StringUtil.join(descriptors, descriptor2 -> "<a href='" + descriptor2.getPluginId().getIdString() + "'>" + descriptor2.getName() + "</a>", (String)", ") + "</html>";
        UpdateChecker.getNotificationGroup().createNotification(title, message, NotificationType.INFORMATION, (notification, event) -> {
            String id2 = event.getDescription();
            if (id2 == null) {
                return;
            }
            PluginId pluginId = PluginId.findId((String[])new String[]{id2});
            if (pluginId == null) {
                return;
            }
            IdeaPluginDescriptor descriptor2 = PluginManagerCore.getPlugin(pluginId);
            if (descriptor2 == null) {
                return;
            }
            InputEvent inputEvent = event.getInputEvent();
            Component component2 = inputEvent == null ? null : inputEvent.getComponent();
            DataProvider provider = component2 == null ? null : DataManager.getDataProvider((JComponent)((JComponent)component2));
            PluginManagerConfigurable.showPluginConfigurable(provider == null ? null : (Project)CommonDataKeys.PROJECT.getData(provider), descriptor2);
        }).notify(project);
    }

    @NotNull
    private static Set<String> getUpdatedPlugins() {
        try {
            File file2 = UpdateCheckerComponent.getUpdatedPluginsFile();
            if (file2.isFile()) {
                List list2 = FileUtil.loadLines((File)file2);
                FileUtil.delete((File)file2);
                return new HashSet<String>(list2);
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        return new HashSet<String>();
    }

    @NotNull
    private static File getUpdatedPluginsFile() {
        return new File(PathManager.getConfigPath(), ".updated_plugins_list");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/updateSettings/impl/UpdateCheckerComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showWhatsNewNotification";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateDefaultChannel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleFirstCheck";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "snapPackageNotification";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showUpdatedPluginsNotification";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class MyActivity
    implements StartupActivity.DumbAware {
        @NotNull
        private final NotNullLazyValue<Boolean> updateFailed = AtomicNotNullLazyValue.createValue(() -> UpdateCheckerComponent.access$500());

        MyActivity() {
            if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                throw ExtensionNotApplicableException.INSTANCE;
            }
        }

        public void runActivity(@NotNull Project project) {
            if (project == null) {
                MyActivity.$$$reportNull$$$0(0);
            }
            if (Experiments.getInstance().isFeatureEnabled("whats.new.notification") && !((Boolean)this.updateFailed.getValue()).booleanValue()) {
                UpdateCheckerComponent.showWhatsNewNotification(project);
            }
            UpdateCheckerComponent.showUpdatedPluginsNotification(project);
            ProcessIOExecutorService.INSTANCE.execute(() -> UpdateInstaller.cleanupPatch());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/updateSettings/impl/UpdateCheckerComponent$MyActivity", "runActivity"));
        }
    }

    static final class MyApplicationInitializedListener
    implements ApplicationInitializedListener {
        MyApplicationInitializedListener() {
            Application app = ApplicationManager.getApplication();
            if (app.isCommandLine() || app.isHeadlessEnvironment()) {
                throw ExtensionNotApplicableException.INSTANCE;
            }
        }

        public void componentsInitialized() {
            UpdateSettings settings = UpdateSettings.getInstance();
            UpdateCheckerComponent.updateDefaultChannel(settings);
            if (settings.isCheckNeeded()) {
                UpdateCheckerComponent.scheduleFirstCheck(settings);
                UpdateCheckerComponent.snapPackageNotification(settings);
            }
        }
    }
}

