/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.playback.PlaybackCommand;
import com.intellij.openapi.ui.playback.PlaybackContext;
import java.io.File;
import javax.swing.SwingUtilities;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class AbstractCommand
implements PlaybackCommand {
    private static final Logger LOG = Logger.getInstance(AbstractCommand.class);
    public static final String CMD_PREFIX = "%";
    private final String myText;
    private final int myLine;
    private final boolean myExecuteInAwt;
    private File myScriptDir;

    public AbstractCommand(String text2, int line) {
        this(text2, line, false);
    }

    public AbstractCommand(String text2, int line, boolean executeInAwt) {
        this.myExecuteInAwt = executeInAwt;
        this.myText = text2;
        this.myLine = line;
    }

    public String getText() {
        return this.myText;
    }

    public int getLine() {
        return this.myLine;
    }

    @Override
    public boolean canGoFurther() {
        return true;
    }

    @Override
    public final Promise<Object> execute(PlaybackContext context) {
        try {
            if (this.isToDumpCommand()) {
                this.dumpCommand(context);
            }
            AsyncPromise result2 = new AsyncPromise();
            Runnable runnable2 = () -> {
                try {
                    this._execute(context).processed((Promise)result2);
                }
                catch (Throwable e) {
                    LOG.error(e);
                    context.error(e.getMessage(), this.getLine());
                    result2.setError(e);
                }
            };
            if (this.isAwtThread()) {
                SwingUtilities.invokeLater(runnable2);
            } else {
                ApplicationManager.getApplication().executeOnPooledThread(runnable2);
            }
            return result2;
        }
        catch (Throwable e) {
            context.error(e.getMessage(), this.getLine());
            return Promises.rejectedPromise((Throwable)e);
        }
    }

    protected boolean isToDumpCommand() {
        return true;
    }

    protected boolean isAwtThread() {
        return this.myExecuteInAwt;
    }

    protected abstract Promise<Object> _execute(PlaybackContext var1);

    public void dumpCommand(PlaybackContext context) {
        context.code(this.getText(), this.getLine());
    }

    public void dumpError(PlaybackContext context, String text2) {
        context.error(text2, this.getLine());
    }

    @Override
    public File getScriptDir() {
        return this.myScriptDir;
    }

    public PlaybackCommand setScriptDir(File scriptDir) {
        this.myScriptDir = scriptDir;
        return this;
    }
}

