/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.ProjectTopics;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.InternalFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.CacheUpdateRunner;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.ui.GuiUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexProjectHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PushedFilePropertiesUpdaterImpl
extends PushedFilePropertiesUpdater {
    private static final Logger LOG = Logger.getInstance(PushedFilePropertiesUpdater.class);
    private final Project myProject;
    private final Queue<Runnable> myTasks;

    public PushedFilePropertiesUpdaterImpl(final @NotNull Project project) {
        if (project == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(0);
        }
        this.myTasks = new ConcurrentLinkedQueue<Runnable>();
        this.myProject = project;
        project.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace(new Throwable("Processing roots changed event (caused by file type change: " + event.isCausedByFileTypesChange() + ")"));
                }
                for (FilePropertyPusher pusher : FilePropertyPusher.EP_NAME.getExtensionList()) {
                    pusher.afterRootsChanged(project);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/roots/impl/PushedFilePropertiesUpdaterImpl$1", "rootsChanged"));
            }
        });
        FilePropertyPusher.EP_NAME.addExtensionPointListener(new ExtensionPointListener<FilePropertyPusher<?>>(){

            public void extensionAdded(@NotNull FilePropertyPusher<?> pusher, @NotNull PluginDescriptor pluginDescriptor) {
                if (pusher == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                PushedFilePropertiesUpdaterImpl.this.queueFullUpdate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pusher";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/roots/impl/PushedFilePropertiesUpdaterImpl$2";
                objectArray[2] = "extensionAdded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)project);
    }

    private void queueFullUpdate() {
        this.myTasks.clear();
        this.queueTasks(Arrays.asList(this::initializeProperties, () -> this.doPushAll(FilePropertyPusher.EP_NAME.getExtensionList())));
    }

    @ApiStatus.Internal
    public void processAfterVfsChanges(@NotNull List<? extends VFileEvent> events) {
        boolean pushingSomethingSynchronously;
        if (events == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(1);
        }
        ArrayList syncTasks = new ArrayList();
        ArrayList delayedTasks = new ArrayList();
        List filePushers = PushedFilePropertiesUpdaterImpl.getFilePushers();
        for (VFileEvent vFileEvent : events) {
            VirtualFile file2;
            if (vFileEvent instanceof VFileCreateEvent) {
                List pushers;
                boolean isDirectory = ((VFileCreateEvent)vFileEvent).isDirectory();
                List list2 = pushers = isDirectory ? FilePropertyPusher.EP_NAME.getExtensionList() : filePushers;
                if (!vFileEvent.isFromRefresh()) {
                    ContainerUtil.addIfNotNull(syncTasks, (Object)this.createRecursivePushTask(vFileEvent, pushers));
                    continue;
                }
                FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFileName(((VFileCreateEvent)vFileEvent).getChildName());
                boolean isProjectOrWorkspaceFile = fileType instanceof InternalFileType || VfsUtilCore.findContainingDirectory((VirtualFile)((VFileCreateEvent)vFileEvent).getParent(), (CharSequence)".idea") != null;
                if (isProjectOrWorkspaceFile) continue;
                ContainerUtil.addIfNotNull(delayedTasks, (Object)this.createRecursivePushTask(vFileEvent, pushers));
                continue;
            }
            if (!(vFileEvent instanceof VFileMoveEvent) && !(vFileEvent instanceof VFileCopyEvent) || (file2 = PushedFilePropertiesUpdaterImpl.getFile(vFileEvent)) == null) continue;
            boolean isDirectory = file2.isDirectory();
            List pushers = isDirectory ? FilePropertyPusher.EP_NAME.getExtensionList() : filePushers;
            for (FilePropertyPusher pusher : pushers) {
                file2.putUserData(pusher.getFileDataKey(), null);
            }
            ContainerUtil.addIfNotNull(syncTasks, (Object)this.createRecursivePushTask(vFileEvent, pushers));
        }
        boolean bl = pushingSomethingSynchronously = !syncTasks.isEmpty() && syncTasks.size() < FileBasedIndexProjectHandler.ourMinFilesToStartDumMode;
        if (pushingSomethingSynchronously) {
            syncTasks.forEach(Runnable::run);
        } else {
            delayedTasks.addAll(syncTasks);
        }
        if (!delayedTasks.isEmpty()) {
            this.queueTasks(delayedTasks);
        }
        if (pushingSomethingSynchronously) {
            GuiUtils.invokeLaterIfNeeded(() -> this.scheduleDumbModeReindexingIfNeeded(), (ModalityState)ModalityState.defaultModalityState());
        }
    }

    private static VirtualFile getFile(@NotNull VFileEvent event) {
        if (event == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(2);
        }
        VirtualFile file2 = event.getFile();
        if (event instanceof VFileCopyEvent) {
            file2 = ((VFileCopyEvent)event).getNewParent().findChild(((VFileCopyEvent)event).getNewChildName());
        }
        return file2;
    }

    public void runConcurrentlyIfPossible(List<Runnable> tasks) {
        PushedFilePropertiesUpdaterImpl.invokeConcurrentlyIfPossible(tasks);
    }

    public void initializeProperties() {
        FilePropertyPusher.EP_NAME.forEachExtensionSafe(pusher -> pusher.initExtra(this.myProject, this.myProject.getMessageBus()));
    }

    public void pushAllPropertiesNow() {
        this.performPushTasks();
        this.doPushAll(FilePropertyPusher.EP_NAME.getExtensionList());
    }

    @Nullable
    private Runnable createRecursivePushTask(@NotNull VFileEvent event, @NotNull List<? extends FilePropertyPusher<?>> pushers) {
        if (event == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(3);
        }
        if (pushers == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(4);
        }
        if (pushers.isEmpty()) {
            return null;
        }
        return () -> {
            VirtualFile dir = PushedFilePropertiesUpdaterImpl.getFile(event);
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
            if (dir != null && ((Boolean)ReadAction.compute(() -> fileIndex.isInContent(dir))).booleanValue() && !ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)dir)) {
                this.doPushRecursively(dir, pushers, fileIndex);
            }
        };
    }

    private void doPushRecursively(VirtualFile dir, @NotNull List<? extends FilePropertyPusher<?>> pushers, ProjectFileIndex fileIndex) {
        if (pushers == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(5);
        }
        fileIndex.iterateContentUnderDirectory(dir, fileOrDir -> {
            this.applyPushersToFile(fileOrDir, pushers, null);
            return true;
        });
    }

    private void queueTasks(@NotNull List<? extends Runnable> actions) {
        if (actions == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(6);
        }
        actions.forEach(this.myTasks::offer);
        final DumbModeTask task2 = new DumbModeTask((Object)this){

            public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                PushedFilePropertiesUpdaterImpl.this.performPushTasks();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/roots/impl/PushedFilePropertiesUpdaterImpl$3", "performInDumbMode"));
            }
        };
        this.myProject.getMessageBus().connect((Disposable)task2).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                DumbService.getInstance((Project)PushedFilePropertiesUpdaterImpl.this.myProject).cancelTask(task2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/roots/impl/PushedFilePropertiesUpdaterImpl$4", "rootsChanged"));
            }
        });
        FilePropertyPusher.EP_NAME.addExtensionPointListener(() -> {
            DumbService.getInstance((Project)this.myProject).cancelTask(task2);
            this.queueFullUpdate();
        }, (Disposable)task2);
        DumbService.getInstance((Project)this.myProject).queueTask(task2);
    }

    private void performPushTasks() {
        Runnable task2;
        boolean hadTasks = false;
        while ((task2 = this.myTasks.poll()) != null) {
            try {
                task2.run();
                hadTasks = true;
            }
            catch (ProcessCanceledException e) {
                this.queueTasks(Collections.singletonList(task2));
                throw e;
            }
        }
        if (hadTasks) {
            this.scheduleDumbModeReindexingIfNeeded();
        }
    }

    private void scheduleDumbModeReindexingIfNeeded() {
        if (this.myProject.isDisposed()) {
            return;
        }
        DumbModeTask task2 = FileBasedIndexProjectHandler.createChangedFilesIndexingTask(this.myProject);
        if (task2 != null) {
            DumbService.getInstance((Project)this.myProject).queueTask(task2);
        }
    }

    public void filePropertiesChanged(@NotNull VirtualFile fileOrDir, @NotNull Condition<? super VirtualFile> acceptFileCondition) {
        if (fileOrDir == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(7);
        }
        if (acceptFileCondition == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(8);
        }
        if (fileOrDir.isDirectory()) {
            for (VirtualFile child2 : fileOrDir.getChildren()) {
                if (child2.isDirectory() || !acceptFileCondition.value((Object)child2)) continue;
                this.filePropertiesChanged(child2);
            }
        } else if (acceptFileCondition.value((Object)fileOrDir)) {
            this.filePropertiesChanged(fileOrDir);
        }
    }

    private static <T> T findPusherValuesUpwards(Project project, VirtualFile dir, FilePropertyPusher<? extends T> pusher, T moduleValue) {
        Object value2 = pusher.getImmediateValue(project, dir);
        if (value2 != null) {
            return (T)value2;
        }
        if (moduleValue != null) {
            return moduleValue;
        }
        return PushedFilePropertiesUpdaterImpl.findPusherValuesFromParent(project, dir, pusher);
    }

    private static <T> T findPusherValuesUpwards(Project project, VirtualFile dir, FilePropertyPusher<? extends T> pusher) {
        Object userValue = dir.getUserData(pusher.getFileDataKey());
        if (userValue != null) {
            return (T)userValue;
        }
        Object value2 = pusher.getImmediateValue(project, dir);
        if (value2 != null) {
            return (T)value2;
        }
        return PushedFilePropertiesUpdaterImpl.findPusherValuesFromParent(project, dir, pusher);
    }

    private static <T> T findPusherValuesFromParent(Project project, VirtualFile dir, FilePropertyPusher<? extends T> pusher) {
        VirtualFile parent = dir.getParent();
        if (parent != null && ProjectFileIndex.getInstance((Project)project).isInContent(parent)) {
            return PushedFilePropertiesUpdaterImpl.findPusherValuesUpwards(project, parent, pusher);
        }
        Object projectValue = pusher.getImmediateValue(project, null);
        return (T)(projectValue != null ? projectValue : pusher.getDefaultValue());
    }

    public void pushAll(FilePropertyPusher<?> ... pushers) {
        if (pushers == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(9);
        }
        this.queueTasks(Collections.singletonList(() -> this.doPushAll(Arrays.asList(pushers))));
    }

    private void doPushAll(@NotNull List<? extends FilePropertyPusher<?>> pushers) {
        if (pushers == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(10);
        }
        Module[] modules = (Module[])ReadAction.compute(() -> ModuleManager.getInstance((Project)this.myProject).getModules());
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        for (Module module : modules) {
            Runnable iteration = (Runnable)ReadAction.compute(() -> {
                if (module.isDisposed()) {
                    return EmptyRunnable.INSTANCE;
                }
                ProgressManager.checkCanceled();
                Object[] moduleValues = new Object[pushers.size()];
                for (int i = 0; i < moduleValues.length; ++i) {
                    moduleValues[i] = ((FilePropertyPusher)pushers.get(i)).getImmediateValue(module);
                }
                ModuleFileIndex fileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
                return () -> fileIndex.iterateContent(fileOrDir -> {
                    this.applyPushersToFile(fileOrDir, pushers, moduleValues);
                    return true;
                });
            });
            tasks.add(iteration);
        }
        PushedFilePropertiesUpdaterImpl.invokeConcurrentlyIfPossible(tasks);
    }

    public static void invokeConcurrentlyIfPossible(List<? extends Runnable> tasks) {
        Runnable runnable2;
        if (tasks.size() == 1 || ApplicationManager.getApplication().isWriteAccessAllowed()) {
            for (Runnable runnable3 : tasks) {
                runnable3.run();
            }
            return;
        }
        ProgressIndicator progress2 = ProgressManager.getInstance().getProgressIndicator();
        ConcurrentLinkedQueue<? extends Runnable> concurrentLinkedQueue = new ConcurrentLinkedQueue<Runnable>(tasks);
        ArrayList<Future> results = new ArrayList<Future>();
        if (tasks.size() > 1) {
            int numThreads = Math.max(Math.min(CacheUpdateRunner.indexingThreadCount() - 1, tasks.size() - 1), 1);
            for (int i = 0; i < numThreads; ++i) {
                results.add(ApplicationManager.getApplication().executeOnPooledThread(() -> ProgressManager.getInstance().runProcess(() -> {
                    Runnable runnable2;
                    while ((runnable2 = (Runnable)tasksQueue.poll()) != null) {
                        runnable2.run();
                    }
                }, (ProgressIndicator)ProgressWrapper.wrap(progress2))));
            }
        }
        while ((runnable2 = concurrentLinkedQueue.poll()) != null) {
            runnable2.run();
        }
        for (Future result2 : results) {
            try {
                result2.get();
            }
            catch (InterruptedException ex) {
                throw new ProcessCanceledException((Throwable)ex);
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
        }
    }

    private void applyPushersToFile(VirtualFile fileOrDir, @NotNull List<? extends FilePropertyPusher<?>> pushers, Object[] moduleValues) {
        if (pushers == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(11);
        }
        if (fileOrDir.isDirectory()) {
            fileOrDir.getChildren();
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            ProgressManager.checkCanceled();
            if (!fileOrDir.isValid()) {
                return;
            }
            this.doApplyPushersToFile(fileOrDir, pushers, moduleValues);
        });
    }

    private void doApplyPushersToFile(@NotNull VirtualFile fileOrDir, @NotNull List<? extends FilePropertyPusher<?>> pushers, Object[] moduleValues) {
        if (fileOrDir == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(12);
        }
        if (pushers == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(13);
        }
        FilePropertyPusher<?> pusher = null;
        try {
            boolean isDir = fileOrDir.isDirectory();
            for (int i = 0; i < pushers.size(); ++i) {
                pusher = pushers.get(i);
                if (!isDir ? pusher.pushDirectoriesOnly() || !pusher.acceptsFile(fileOrDir, this.myProject) : !pusher.acceptsDirectory(fileOrDir, this.myProject)) continue;
                Object value2 = moduleValues != null ? moduleValues[i] : null;
                this.findAndUpdateValue(fileOrDir, pusher, value2);
            }
        }
        catch (AbstractMethodError ame) {
            if (pusher != null) {
                throw PluginException.createByClass((String)("Failed to apply pusher " + pusher.getClass()), (Throwable)ame, pusher.getClass());
            }
            throw ame;
        }
    }

    public <T> void findAndUpdateValue(VirtualFile fileOrDir, FilePropertyPusher<T> pusher, T moduleValue) {
        T value2 = PushedFilePropertiesUpdaterImpl.findPusherValuesUpwards(this.myProject, fileOrDir, pusher, moduleValue);
        PushedFilePropertiesUpdaterImpl.updateValue(this.myProject, fileOrDir, value2, pusher);
    }

    public static <T> void updateValue(Project project, VirtualFile fileOrDir, T value2, FilePropertyPusher<T> pusher) {
        Object oldValue = fileOrDir.getUserData(pusher.getFileDataKey());
        if (value2 != oldValue) {
            fileOrDir.putUserData(pusher.getFileDataKey(), value2);
            try {
                pusher.persistAttribute(project, fileOrDir, value2);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void filePropertiesChanged(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(14);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        FileBasedIndex.getInstance().requestReindex(file2);
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            PushedFilePropertiesUpdaterImpl.reloadPsi(file2, project);
        }
    }

    private static void reloadPsi(VirtualFile file2, Project project) {
        FileManagerImpl fileManager = (FileManagerImpl)PsiManagerEx.getInstanceEx(project).getFileManager();
        if (fileManager.findCachedViewProvider(file2) != null) {
            GuiUtils.invokeLaterIfNeeded(() -> WriteAction.run(() -> fileManager.forceReload(file2)), (ModalityState)ModalityState.defaultModalityState(), (Condition)project.getDisposed());
        }
    }

    private static List<FilePropertyPusher<?>> getFilePushers() {
        return ContainerUtil.findAll((Collection)FilePropertyPusher.EP_NAME.getExtensionList(), pusher -> !pusher.pushDirectoriesOnly());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushers";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acceptFileCondition";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/impl/PushedFilePropertiesUpdaterImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processAfterVfsChanges";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createRecursivePushTask";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doPushRecursively";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "queueTasks";
                break;
            }
            case 7: 
            case 8: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "filePropertiesChanged";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "pushAll";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "doPushAll";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "applyPushersToFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "doApplyPushersToFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

