/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ProjectLocatorImpl
extends ProjectLocator {
    ProjectLocatorImpl() {
    }

    @Nullable
    public Project guessProjectForFile(@Nullable VirtualFile file2) {
        Project project = ProjectCoreUtil.theOnlyOpenProject();
        if (project != null && !project.isDisposed()) {
            return project;
        }
        if (file2 != null && (project = ProjectLocatorImpl.getPreferredProject((VirtualFile)file2)) != null) {
            return project;
        }
        ProjectManager projectManager = ProjectManager.getInstanceIfCreated();
        if (projectManager == null) {
            return null;
        }
        Project[] openProjects = projectManager.getOpenProjects();
        if (openProjects.length == 1) {
            return openProjects[0];
        }
        if (file2 == null) {
            return null;
        }
        return (Project)ReadAction.compute(() -> {
            for (Project openProject : projectManager.getOpenProjects()) {
                if (!ProjectLocatorImpl.isUnder(openProject, file2)) continue;
                return openProject;
            }
            return null;
        });
    }

    private static boolean isUnder(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            ProjectLocatorImpl.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            ProjectLocatorImpl.$$$reportNull$$$0(1);
        }
        if (!project.isInitialized() || project.isDisposed()) {
            return false;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return fileIndex.isInContent(file2) || fileIndex.isExcluded(file2);
    }

    @NotNull
    public Collection<Project> getProjectsForFile(@NotNull VirtualFile file2) {
        ProjectManager projectManager;
        if (file2 == null) {
            ProjectLocatorImpl.$$$reportNull$$$0(2);
        }
        if ((projectManager = ProjectManager.getInstanceIfCreated()) == null) {
            List<Project> list2 = Collections.emptyList();
            if (list2 == null) {
                ProjectLocatorImpl.$$$reportNull$$$0(3);
            }
            return list2;
        }
        Project[] openProjects = projectManager.getOpenProjects();
        if (openProjects.length == 0) {
            List<Project> list3 = Collections.emptyList();
            if (list3 == null) {
                ProjectLocatorImpl.$$$reportNull$$$0(4);
            }
            return list3;
        }
        SmartList result2 = new SmartList();
        for (Project project : openProjects) {
            if (!ProjectLocatorImpl.isUnder(project, file2)) continue;
            result2.add(project);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            ProjectLocatorImpl.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/project/ProjectLocatorImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/project/ProjectLocatorImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectsForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isUnder";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getProjectsForFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

