/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.ide.ui.search.ConfigurableHit;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.newEditor.OptionsEditorContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.LightColors;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.speedSearch.ElementFilter;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Set;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public abstract class SettingsFilter
extends ElementFilter.Active.Impl<SimpleNode> {
    final OptionsEditorContext myContext = new OptionsEditorContext();
    private final Project myProject;
    private final SearchTextField mySearch;
    private final List<? extends ConfigurableGroup> myGroups;
    private final SearchableOptionsRegistrar myRegistrar = SearchableOptionsRegistrar.getInstance();
    private Set<Configurable> myFiltered;
    private ConfigurableHit myHits;
    private boolean myUpdateRejected;
    private Configurable myLastSelected;

    SettingsFilter(Project project, List<? extends ConfigurableGroup> groups, SearchTextField search2) {
        this.myProject = project;
        this.myGroups = groups;
        this.mySearch = search2;
        this.mySearch.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                SettingsFilter.this.update(event.getType(), true, false);
                IdeFocusManager manager = IdeFocusManager.findInstanceByComponent((Component)SettingsFilter.this.mySearch);
                if (manager.getFocusedDescendantFor((Component)SettingsFilter.this.mySearch) == null) {
                    manager.requestFocus((Component)SettingsFilter.this.mySearch, true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/options/newEditor/SettingsFilter$1", "textChanged"));
            }
        });
        this.mySearch.getTextEditor().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                if (!SettingsFilter.this.mySearch.getText().isEmpty()) {
                    if (!SettingsFilter.this.myContext.isHoldingFilter()) {
                        SettingsFilter.this.setHoldingFilter(true);
                    }
                    if (!SettingsFilter.this.mySearch.getTextEditor().isFocusOwner()) {
                        SettingsFilter.this.mySearch.selectText();
                    }
                }
            }
        });
    }

    abstract Configurable getConfigurable(SimpleNode var1);

    abstract SimpleNode findNode(Configurable var1);

    abstract void updateSpotlight(boolean var1);

    public boolean shouldBeShowing(SimpleNode node) {
        Configurable configurable2;
        if (this.myFiltered != null && (configurable2 = this.getConfigurable(node)) != null && !this.myFiltered.contains(configurable2)) {
            if (this.myHits != null) {
                Set configurables = this.myHits.getNameFullHits();
                while (node != null) {
                    if (configurable2 != null && configurables.contains(configurable2)) {
                        return true;
                    }
                    node = node.getParent();
                    configurable2 = this.getConfigurable(node);
                }
            }
            return false;
        }
        return true;
    }

    String getFilterText() {
        String text2 = this.mySearch.getText();
        if (text2 != null && 1 < (text2 = text2.trim()).length()) {
            return text2;
        }
        return "";
    }

    private void setHoldingFilter(boolean holding) {
        this.myContext.setHoldingFilter(holding);
        this.updateSpotlight(false);
    }

    boolean contains(@NotNull Configurable configurable2) {
        if (configurable2 == null) {
            SettingsFilter.$$$reportNull$$$0(0);
        }
        return this.myHits != null && this.myHits.getNameHits().contains(configurable2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(String text2, boolean adjustSelection, boolean now) {
        try {
            this.myUpdateRejected = true;
            this.mySearch.setText(text2);
        }
        finally {
            this.myUpdateRejected = false;
        }
        this.update(DocumentEvent.EventType.CHANGE, adjustSelection, now);
    }

    private void update(@NotNull DocumentEvent.EventType type, boolean adjustSelection, boolean now) {
        Configurable candidate;
        boolean shouldMoveSelection;
        if (type == null) {
            SettingsFilter.$$$reportNull$$$0(1);
        }
        if (this.myUpdateRejected) {
            return;
        }
        String text2 = this.getFilterText();
        if (text2.isEmpty()) {
            this.myContext.setHoldingFilter(false);
            this.myFiltered = null;
        } else {
            this.myContext.setHoldingFilter(true);
            this.myHits = this.myRegistrar.getConfigurables(this.myGroups, type, this.myFiltered, text2, this.myProject);
            this.myFiltered = this.myHits.getAll();
        }
        this.mySearch.getTextEditor().setBackground(this.myFiltered != null && this.myFiltered.isEmpty() ? LightColors.RED : UIUtil.getTextFieldBackground());
        Configurable current2 = this.myContext.getCurrentConfigurable();
        boolean bl = shouldMoveSelection = this.myHits == null || !this.myHits.getNameFullHits().contains(current2) && !this.myHits.getContentHits().contains(current2);
        if (shouldMoveSelection && type != DocumentEvent.EventType.INSERT && (this.myFiltered == null || this.myFiltered.contains(current2))) {
            shouldMoveSelection = false;
        }
        Object object = candidate = adjustSelection ? current2 : null;
        if (shouldMoveSelection && this.myHits != null) {
            if (!this.myHits.getNameHits().isEmpty()) {
                candidate = SettingsFilter.findConfigurable(this.myHits.getNameHits(), this.myHits.getNameFullHits());
            } else if (!this.myHits.getContentHits().isEmpty()) {
                candidate = SettingsFilter.findConfigurable(this.myHits.getContentHits(), null);
            }
        }
        this.updateSpotlight(false);
        if (!(this.myFiltered != null && this.myFiltered.isEmpty() || candidate != null || this.myLastSelected == null)) {
            candidate = this.myLastSelected;
            this.myLastSelected = null;
        }
        if (candidate == null && current2 != null) {
            this.myLastSelected = current2;
        }
        SimpleNode node = !adjustSelection ? null : this.findNode(candidate);
        this.fireUpdate(node, adjustSelection, now);
    }

    private static Configurable findConfigurable(Set<? extends Configurable> configurables, Set<? extends Configurable> hits) {
        Configurable candidate = null;
        for (Configurable configurable2 : configurables) {
            if (hits != null && hits.contains(configurable2)) {
                return configurable2;
            }
            if (candidate != null || SettingsFilter.isEmptyParent(configurable2)) continue;
            candidate = configurable2;
        }
        return candidate;
    }

    private static boolean isEmptyParent(Configurable configurable2) {
        SearchableConfigurable.Parent parent = ConfigurableWrapper.cast(SearchableConfigurable.Parent.class, (UnnamedConfigurable)configurable2);
        return parent != null && !parent.hasOwnContent();
    }

    void reload() {
        this.myLastSelected = null;
        this.myFiltered = null;
        this.myHits = null;
        this.mySearch.setText("");
        this.myContext.reload();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/options/newEditor/SettingsFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

