/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.StartupAbortedException;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.PlainTextLikeFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.UserBinaryFileType;
import com.intellij.openapi.fileTypes.UserFileType;
import com.intellij.openapi.fileTypes.ex.ExternalizableFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.fileTypes.impl.FileTypeBean;
import com.intellij.openapi.fileTypes.impl.FileTypeOverrider;
import com.intellij.openapi.fileTypes.impl.IgnoredFileCache;
import com.intellij.openapi.fileTypes.impl.IgnoredPatternSet;
import com.intellij.openapi.fileTypes.impl.RemovedMappingTracker;
import com.intellij.openapi.options.NonLazySchemeProcessor;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.FileSystemInterface;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.StubVirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.BitUtil;
import com.intellij.util.DeprecatedMethodException;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.containers.ConcurrentPackedBitsArray;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSetQueue;
import com.intellij.util.io.URLUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.StreamSupport;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;

@State(name="FileTypeManager", storages={@Storage(value="filetypes.xml")}, additionalExportFile="filetypes")
public class FileTypeManagerImpl
extends FileTypeManagerEx
implements PersistentStateComponent<Element>,
Disposable {
    private static final ExtensionPointName<FileTypeBean> EP_NAME = ExtensionPointName.create((String)"com.intellij.fileType");
    private static final Logger LOG = Logger.getInstance(FileTypeManagerImpl.class);
    private static final int VERSION = 17;
    private static final ThreadLocal<Pair<VirtualFile, FileType>> FILE_TYPE_FIXED_TEMPORARILY = new ThreadLocal();
    static final Key<FileType> DETECTED_FROM_CONTENT_FILE_TYPE_KEY = Key.create((String)"DETECTED_FROM_CONTENT_FILE_TYPE_KEY");
    static final String DEFAULT_IGNORED = "*.hprof;*.pyc;*.pyo;*.rbc;*.yarb;*~;.DS_Store;.git;.hg;.svn;CVS;__pycache__;_svn;vssver.scc;vssver2.scc;";
    private static boolean RE_DETECT_ASYNC = !ApplicationManager.getApplication().isUnitTestMode();
    private final Set<FileType> myDefaultTypes = new THashSet();
    private FileTypeIdentifiableByVirtualFile[] mySpecialFileTypes = FileTypeIdentifiableByVirtualFile.EMPTY_ARRAY;
    private FileTypeAssocTable<FileType> myPatternsTable = new FileTypeAssocTable();
    private final IgnoredPatternSet myIgnoredPatterns = new IgnoredPatternSet();
    private final IgnoredFileCache myIgnoredFileCache = new IgnoredFileCache(this.myIgnoredPatterns);
    private final FileTypeAssocTable<FileType> myInitialAssociations = new FileTypeAssocTable();
    private final Map<FileNameMatcher, String> myUnresolvedMappings = new THashMap();
    private final RemovedMappingTracker myRemovedMappingTracker = new RemovedMappingTracker();
    private final Map<String, FileTypeBean> myPendingFileTypes = new HashMap<String, FileTypeBean>();
    private final FileTypeAssocTable<FileTypeBean> myPendingAssociations = new FileTypeAssocTable();
    @NonNls
    private static final String ELEMENT_FILETYPE = "filetype";
    @NonNls
    private static final String ELEMENT_IGNORE_FILES = "ignoreFiles";
    @NonNls
    private static final String ATTRIBUTE_LIST = "list";
    @NonNls
    private static final String ATTRIBUTE_VERSION = "version";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String ATTRIBUTE_DESCRIPTION = "description";
    private final MessageBus myMessageBus;
    private final Map<String, StandardFileType> myStandardFileTypes = new LinkedHashMap<String, StandardFileType>();
    @NonNls
    private static final String[] FILE_TYPES_WITH_PREDEFINED_EXTENSIONS = new String[]{"JSP", "JSPX", "DTD", "HTML", "Properties", "XHTML"};
    private final SchemeManager<FileType> mySchemeManager;
    @NonNls
    static final String FILE_SPEC = "filetypes";
    private static final byte AUTO_DETECTED_AS_TEXT_MASK = 1;
    private static final byte AUTO_DETECTED_AS_BINARY_MASK = 2;
    private static final byte AUTO_DETECT_WAS_RUN_MASK = 4;
    private static final byte ATTRIBUTES_WERE_LOADED_MASK = 8;
    private final ConcurrentPackedBitsArray packedFlags = new ConcurrentPackedBitsArray(4);
    private final AtomicInteger counterAutoDetect = new AtomicInteger();
    private final AtomicLong elapsedAutoDetect = new AtomicLong();
    private final Object PENDING_INIT_LOCK = new Object();
    boolean toLog;
    private final Executor reDetectExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"FileTypeManager Redetect Pool", (Executor)PooledThreadExecutor.INSTANCE, (int)1, (Disposable)this);
    private final HashSetQueue<VirtualFile> filesToRedetect = new HashSetQueue();
    private static final int CHUNK_SIZE = 10;
    private volatile FileAttribute autoDetectedAttribute;
    private final AtomicInteger fileTypeChangedCount;
    private final Map<FileTypeListener, MessageBusConnection> myAdapters = new HashMap<FileTypeListener, MessageBusConnection>();

    public FileTypeManagerImpl() {
        int fileTypeChangedCounter = PropertiesComponent.getInstance().getInt("fileTypeChangedCounter", 0);
        this.fileTypeChangedCount = new AtomicInteger(fileTypeChangedCounter);
        this.autoDetectedAttribute = new FileAttribute("AUTO_DETECTION_CACHE_ATTRIBUTE", fileTypeChangedCounter, true);
        this.myMessageBus = ApplicationManager.getApplication().getMessageBus();
        this.mySchemeManager = SchemeManagerFactory.getInstance().create(FILE_SPEC, new NonLazySchemeProcessor<FileType, AbstractFileType>(){

            @Override
            @NotNull
            public AbstractFileType readScheme(@NotNull Element element2, boolean duringLoad) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!duringLoad) {
                    FileTypeManagerImpl.this.fireBeforeFileTypesChanged();
                }
                AbstractFileType type = (AbstractFileType)FileTypeManagerImpl.this.loadFileType(element2, false);
                if (!duringLoad) {
                    FileTypeManagerImpl.this.fireFileTypesChanged(type, null);
                }
                AbstractFileType abstractFileType = type;
                if (abstractFileType == null) {
                    1.$$$reportNull$$$0(1);
                }
                return abstractFileType;
            }

            @Override
            @NotNull
            public SchemeState getState(@NotNull FileType fileType) {
                if (fileType == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!(fileType instanceof AbstractFileType) || !FileTypeManagerImpl.shouldSave(fileType)) {
                    SchemeState schemeState = SchemeState.NON_PERSISTENT;
                    if (schemeState == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return schemeState;
                }
                if (!FileTypeManagerImpl.this.myDefaultTypes.contains(fileType)) {
                    SchemeState schemeState = SchemeState.POSSIBLY_CHANGED;
                    if (schemeState == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return schemeState;
                }
                SchemeState schemeState = ((AbstractFileType)fileType).isModified() ? SchemeState.POSSIBLY_CHANGED : SchemeState.NON_PERSISTENT;
                if (schemeState == null) {
                    1.$$$reportNull$$$0(5);
                }
                return schemeState;
            }

            @NotNull
            public Element writeScheme(@NotNull AbstractFileType fileType) {
                if (fileType == null) {
                    1.$$$reportNull$$$0(6);
                }
                Element root = new Element(FileTypeManagerImpl.ELEMENT_FILETYPE);
                root.setAttribute("binary", String.valueOf(fileType.isBinary()));
                if (!StringUtil.isEmpty((String)fileType.getDefaultExtension())) {
                    root.setAttribute("default_extension", fileType.getDefaultExtension());
                }
                root.setAttribute(FileTypeManagerImpl.ATTRIBUTE_DESCRIPTION, fileType.getDescription());
                root.setAttribute(FileTypeManagerImpl.ATTRIBUTE_NAME, fileType.getName());
                fileType.writeExternal(root);
                Element map2 = new Element("extensionMap");
                FileTypeManagerImpl.this.writeExtensionsMap(map2, fileType, false);
                if (!map2.getChildren().isEmpty()) {
                    root.addContent(map2);
                }
                Element element2 = root;
                if (element2 == null) {
                    1.$$$reportNull$$$0(7);
                }
                return element2;
            }

            @Override
            public void onSchemeDeleted(@NotNull AbstractFileType scheme) {
                if (scheme == null) {
                    1.$$$reportNull$$$0(8);
                }
                GuiUtils.invokeLaterIfNeeded(() -> {
                    Application app = ApplicationManager.getApplication();
                    app.runWriteAction(() -> FileTypeManagerImpl.this.fireBeforeFileTypesChanged());
                    FileTypeManagerImpl.this.myPatternsTable.removeAllAssociations((Object)scheme);
                    app.runWriteAction(() -> FileTypeManagerImpl.this.fireFileTypesChanged(null, scheme));
                }, (ModalityState)ModalityState.NON_MODAL);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1";
                        break;
                    }
                    case 2: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileType";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scheme";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "readScheme";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getState";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "writeScheme";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "readScheme";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getState";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "writeScheme";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "onSchemeDeleted";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        this.initStandardFileTypes();
        this.myMessageBus.connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                Set files2 = ContainerUtil.map2Set(events, event -> {
                    VirtualFile filtered2;
                    VirtualFile file2 = event instanceof VFileCreateEvent ? null : event.getFile();
                    VirtualFile virtualFile = filtered2 = file2 != null && FileTypeManagerImpl.this.wasAutoDetectedBefore(file2) && FileTypeManagerImpl.isDetectable(file2) ? file2 : null;
                    if (FileTypeManagerImpl.this.toLog()) {
                        FileTypeManagerImpl.log("F: after() VFS event " + event + "; filtered file: " + filtered2 + " (file: " + file2 + "; wasAutoDetectedBefore(file): " + (file2 == null ? null : Boolean.valueOf(FileTypeManagerImpl.this.wasAutoDetectedBefore(file2))) + "; isDetectable(file): " + (file2 == null ? null : Boolean.valueOf(FileTypeManagerImpl.isDetectable(file2))) + "; file.getLength(): " + (file2 == null ? null : Long.valueOf(file2.getLength())) + "; file.isValid(): " + (file2 == null ? null : Boolean.valueOf(file2.isValid())) + "; file.is(VFileProperty.SPECIAL): " + (file2 == null ? null : Boolean.valueOf(file2.is(VFileProperty.SPECIAL))) + "; packedFlags.get(id): " + (file2 instanceof VirtualFileWithId ? FileTypeManagerImpl.readableFlags(FileTypeManagerImpl.this.packedFlags.get(((VirtualFileWithId)file2).getId())) : null) + "; file.getFileSystem():" + (file2 == null ? null : file2.getFileSystem()) + ")");
                    }
                    return filtered2;
                });
                files2.remove(null);
                if (FileTypeManagerImpl.this.toLog()) {
                    FileTypeManagerImpl.log("F: after() VFS events: " + events + "; files: " + files2);
                }
                if (!files2.isEmpty() && RE_DETECT_ASYNC) {
                    if (FileTypeManagerImpl.this.toLog()) {
                        FileTypeManagerImpl.log("F: after() queued to redetect: " + files2);
                    }
                    HashSetQueue hashSetQueue = FileTypeManagerImpl.this.filesToRedetect;
                    synchronized (hashSetQueue) {
                        if (FileTypeManagerImpl.this.filesToRedetect.addAll((Collection)files2)) {
                            FileTypeManagerImpl.this.awakeReDetectExecutor();
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$2", "after"));
            }
        });
        this.myIgnoredPatterns.setIgnoreMasks(DEFAULT_IGNORED);
        EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<FileTypeBean>(){

            public void extensionAdded(@NotNull FileTypeBean extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(1);
                }
                FileTypeManagerImpl.this.fireBeforeFileTypesChanged();
                FileTypeManagerImpl.initializeMatchers(extension);
                FileType fileType = FileTypeManagerImpl.this.mergeOrInstantiateFileTypeBean(extension);
                FileTypeManagerImpl.this.fileTypeChanged(fileType, ApplicationManager.getApplication().isUnitTestMode());
            }

            public void extensionRemoved(@NotNull FileTypeBean extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(3);
                }
                if (extension.implementationClass != null) {
                    FileType fileType = FileTypeManagerImpl.this.findFileTypeByName(extension.name);
                    if (fileType == null) {
                        return;
                    }
                    FileTypeManagerImpl.this.unregisterFileType(fileType);
                } else {
                    StandardFileType stdFileType = (StandardFileType)FileTypeManagerImpl.this.myStandardFileTypes.get(extension.name);
                    if (stdFileType != null) {
                        FileTypeManagerImpl.this.unregisterMatchers(stdFileType, extension);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
    }

    private void unregisterMatchers(@NotNull StandardFileType stdFileType, @NotNull FileTypeBean extension) {
        if (stdFileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(0);
        }
        if (extension == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            stdFileType.matchers.removeAll(extension.getMatchers());
            this.fileTypeChanged(stdFileType.fileType, ApplicationManager.getApplication().isUnitTestMode());
        });
    }

    private void fileTypeChanged(@NotNull FileType stdFileType, boolean later2) {
        if (stdFileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(2);
        }
        if (later2) {
            ApplicationManager.getApplication().invokeLater(() -> WriteAction.run(() -> this.fireFileTypesChanged(stdFileType, null)));
        } else {
            this.fireFileTypesChanged(stdFileType, null);
        }
    }

    @VisibleForTesting
    void initStandardFileTypes() {
        block7: {
            this.loadFileTypeBeans();
            FileTypeConsumer consumer = new FileTypeConsumer(){

                public void consume(@NotNull FileType fileType) {
                    if (fileType == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    this.register(fileType, FileTypeManagerImpl.parse(fileType.getDefaultExtension()));
                }

                public void consume(@NotNull FileType fileType, String extensions2) {
                    if (fileType == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    this.register(fileType, FileTypeManagerImpl.parse(extensions2));
                }

                public void consume(@NotNull FileType fileType, FileNameMatcher ... matchers) {
                    if (fileType == null) {
                        4.$$$reportNull$$$0(2);
                    }
                    if (matchers == null) {
                        4.$$$reportNull$$$0(3);
                    }
                    this.register(fileType, new ArrayList<FileNameMatcher>(Arrays.asList(matchers)));
                }

                public FileType getStandardFileTypeByName(@NotNull String name) {
                    StandardFileType type;
                    if (name == null) {
                        4.$$$reportNull$$$0(4);
                    }
                    return (type = (StandardFileType)FileTypeManagerImpl.this.myStandardFileTypes.get(name)) != null ? type.fileType : null;
                }

                private void register(@NotNull FileType fileType, @NotNull List<FileNameMatcher> fileNameMatchers) {
                    if (fileType == null) {
                        4.$$$reportNull$$$0(5);
                    }
                    if (fileNameMatchers == null) {
                        4.$$$reportNull$$$0(6);
                    }
                    FileTypeManagerImpl.this.instantiatePendingFileTypeByName(fileType.getName());
                    for (FileNameMatcher matcher : fileNameMatchers) {
                        PluginId id2;
                        FileTypeBean pendingTypeByMatcher = (FileTypeBean)FileTypeManagerImpl.this.myPendingAssociations.findAssociatedFileType(matcher);
                        if (pendingTypeByMatcher == null || (id2 = pendingTypeByMatcher.getPluginId()) != null && PluginManagerCore.CORE_ID != id2) continue;
                        FileTypeManagerImpl.this.instantiateFileTypeBean(pendingTypeByMatcher);
                    }
                    StandardFileType type = (StandardFileType)FileTypeManagerImpl.this.myStandardFileTypes.get(fileType.getName());
                    if (type != null) {
                        type.matchers.addAll(fileNameMatchers);
                    } else {
                        FileTypeManagerImpl.this.myStandardFileTypes.put(fileType.getName(), new StandardFileType(fileType, fileNameMatchers));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "fileType";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "matchers";
                            break;
                        }
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = FileTypeManagerImpl.ATTRIBUTE_NAME;
                            break;
                        }
                        case 6: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "fileNameMatchers";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$4";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "consume";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getStandardFileTypeByName";
                            break;
                        }
                        case 5: 
                        case 6: {
                            objectArray = objectArray2;
                            objectArray2[2] = "register";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            FileTypeFactory.FILE_TYPE_FACTORY_EP.processWithPluginDescriptor((factory, pluginDescriptor) -> {
                try {
                    factory.createFileTypes(consumer);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (StartupAbortedException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new StartupAbortedException("Cannot create file types", (Throwable)new PluginException(e, pluginDescriptor.getPluginId()));
                }
            });
            for (StandardFileType pair : this.myStandardFileTypes.values()) {
                this.registerFileTypeWithoutNotification(pair.fileType, pair.matchers, true);
            }
            try {
                URL defaultFileTypesUrl = FileTypeManagerImpl.class.getResource("/defaultFileTypes.xml");
                if (defaultFileTypesUrl == null) break block7;
                Element defaultFileTypesElement = JDOMUtil.load((InputStream)URLUtil.openStream((URL)defaultFileTypesUrl));
                for (Element e : defaultFileTypesElement.getChildren()) {
                    if (FILE_SPEC.equals(e.getName())) {
                        for (Element element2 : e.getChildren(ELEMENT_FILETYPE)) {
                            String fileTypeName = element2.getAttributeValue(ATTRIBUTE_NAME);
                            if (this.myPendingFileTypes.get(fileTypeName) != null) continue;
                            this.loadFileType(element2, true);
                        }
                        continue;
                    }
                    if (!"extensionMap".equals(e.getName())) continue;
                    this.readGlobalMappings(e, true);
                }
                if (PlatformUtils.isIdeaCommunity()) {
                    Element extensionMap = new Element("extensionMap");
                    extensionMap.addContent(new Element("mapping").setAttribute("ext", "jspx").setAttribute("type", "XML"));
                    extensionMap.addContent(new Element("mapping").setAttribute("ext", "tagx").setAttribute("type", "XML"));
                    this.readGlobalMappings(extensionMap, true);
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private void loadFileTypeBeans() {
        List fileTypeBeans = EP_NAME.getExtensionList();
        for (FileTypeBean bean : fileTypeBeans) {
            FileTypeManagerImpl.initializeMatchers(bean);
        }
        for (FileTypeBean bean : fileTypeBeans) {
            if (bean.implementationClass == null) continue;
            if (this.myPendingFileTypes.containsKey(bean.name)) {
                LOG.error((Throwable)new PluginException("Trying to override already registered file type " + bean.name, bean.getPluginId()));
                continue;
            }
            this.myPendingFileTypes.put(bean.name, bean);
            for (FileNameMatcher matcher : bean.getMatchers()) {
                this.myPendingAssociations.addAssociation(matcher, (Object)bean);
            }
        }
        for (FileTypeBean bean : fileTypeBeans) {
            if (bean.implementationClass != null) continue;
            FileTypeBean oldBean = this.myPendingFileTypes.get(bean.name);
            if (oldBean == null) {
                LOG.error((Throwable)new PluginException("Trying to add extensions to non-registered file type " + bean.name, bean.getPluginId()));
                continue;
            }
            oldBean.addMatchers(bean.getMatchers());
            for (FileNameMatcher matcher : bean.getMatchers()) {
                this.myPendingAssociations.addAssociation(matcher, (Object)oldBean);
            }
        }
    }

    private static void initializeMatchers(FileTypeBean bean) {
        bean.addMatchers(ContainerUtil.concat((List[])new List[]{FileTypeManagerImpl.parse(bean.extensions), FileTypeManagerImpl.parse(bean.fileNames, (Function<? super String, ? extends FileNameMatcher>)((Function)token -> new ExactFileNameMatcher(token))), FileTypeManagerImpl.parse(bean.fileNamesCaseInsensitive, (Function<? super String, ? extends FileNameMatcher>)((Function)token -> new ExactFileNameMatcher(token, true))), FileTypeManagerImpl.parse(bean.patterns, (Function<? super String, ? extends FileNameMatcher>)((Function)token -> FileNameMatcherFactory.getInstance().createMatcher(token)))}));
    }

    private void instantiatePendingFileTypes() {
        ArrayList<FileTypeBean> fileTypes = new ArrayList<FileTypeBean>(this.myPendingFileTypes.values());
        for (FileTypeBean fileTypeBean : fileTypes) {
            this.mergeOrInstantiateFileTypeBean(fileTypeBean);
        }
    }

    @NotNull
    private FileType mergeOrInstantiateFileTypeBean(@NotNull FileTypeBean fileTypeBean) {
        StandardFileType type;
        if (fileTypeBean == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(3);
        }
        if ((type = this.myStandardFileTypes.get(fileTypeBean.name)) != null) {
            type.matchers.addAll(fileTypeBean.getMatchers());
            FileType fileType = type.fileType;
            if (fileType == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(4);
            }
            return fileType;
        }
        FileType fileType = this.instantiateFileTypeBean(fileTypeBean);
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(5);
        }
        return fileType;
    }

    private FileType instantiateFileTypeBean(@NotNull FileTypeBean fileTypeBean) {
        FileType fileType;
        if (fileTypeBean == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(6);
        }
        PluginId pluginId = fileTypeBean.getPluginDescriptor().getPluginId();
        try {
            Class<?> beanClass = Class.forName(fileTypeBean.implementationClass, true, fileTypeBean.getPluginDescriptor().getPluginClassLoader());
            if (fileTypeBean.fieldName != null) {
                Field field = beanClass.getDeclaredField(fileTypeBean.fieldName);
                field.setAccessible(true);
                fileType = (FileType)field.get(null);
            } else {
                fileType = (FileType)ReflectionUtil.newInstance(beanClass, (boolean)false);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            LOG.error((Throwable)new PluginException((Throwable)e, pluginId));
            return null;
        }
        if (!fileType.getName().equals(fileTypeBean.name)) {
            LOG.error((Throwable)new PluginException("Incorrect name specified in <fileType>, should be " + fileType.getName() + ", actual " + fileTypeBean.name, pluginId));
        }
        if (fileType instanceof LanguageFileType) {
            String expectedLanguage;
            LanguageFileType languageFileType = (LanguageFileType)fileType;
            String string = expectedLanguage = languageFileType.isSecondary() ? null : languageFileType.getLanguage().getID();
            if (!Comparing.equal((String)fileTypeBean.language, (String)expectedLanguage)) {
                LOG.error((Throwable)new PluginException("Incorrect language specified in <fileType> for " + fileType.getName() + ", should be " + expectedLanguage + ", actual " + fileTypeBean.language, pluginId));
            }
        }
        StandardFileType standardFileType = new StandardFileType(fileType, fileTypeBean.getMatchers());
        this.myStandardFileTypes.put(fileTypeBean.name, standardFileType);
        this.registerFileTypeWithoutNotification(standardFileType.fileType, standardFileType.matchers, true);
        this.myPendingAssociations.removeAllAssociations((Object)fileTypeBean);
        this.myPendingFileTypes.remove(fileTypeBean.name);
        return fileType;
    }

    private boolean toLog() {
        return this.toLog;
    }

    private static void log(String message) {
        LOG.debug(message + " - " + Thread.currentThread());
    }

    private void awakeReDetectExecutor() {
        this.reDetectExecutor.execute(() -> {
            ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>(10);
            HashSetQueue<VirtualFile> hashSetQueue = this.filesToRedetect;
            synchronized (hashSetQueue) {
                VirtualFile file2;
                for (int i = 0; i < 10 && (file2 = (VirtualFile)this.filesToRedetect.poll()) != null; ++i) {
                    files2.add(file2);
                }
            }
            if (files2.size() == 10) {
                this.awakeReDetectExecutor();
            }
            this.reDetect(files2);
        });
    }

    public void drainReDetectQueue() {
        try {
            ((BoundedTaskExecutor)this.reDetectExecutor).waitAllTasksExecuted(1L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    Collection<VirtualFile> dumpReDetectQueue() {
        HashSetQueue<VirtualFile> hashSetQueue = this.filesToRedetect;
        // MONITORENTER : hashSetQueue
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>((Collection<VirtualFile>)this.filesToRedetect);
        // MONITOREXIT : hashSetQueue
        if (arrayList != null) return arrayList;
        FileTypeManagerImpl.$$$reportNull$$$0(7);
        return arrayList;
    }

    static void reDetectAsync(boolean enable) {
        RE_DETECT_ASYNC = enable;
    }

    private void reDetect(@NotNull Collection<? extends VirtualFile> files2) {
        if (files2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(8);
        }
        ArrayList<VirtualFile> changed2 = new ArrayList<VirtualFile>();
        ArrayList<VirtualFile> crashed = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : files2) {
            FileType after2;
            FileType before;
            block10: {
                boolean shouldRedetect;
                boolean bl = shouldRedetect = this.wasAutoDetectedBefore(virtualFile) && FileTypeManagerImpl.isDetectable(virtualFile);
                if (this.toLog()) {
                    FileTypeManagerImpl.log("F: reDetect(" + virtualFile.getName() + ") " + virtualFile.getName() + "; shouldRedetect: " + shouldRedetect);
                }
                if (!shouldRedetect) continue;
                int id2 = ((VirtualFileWithId)virtualFile).getId();
                long flags = this.packedFlags.get(id2);
                before = (FileType)ObjectUtils.notNull((Object)FileTypeManagerImpl.textOrBinaryFromCachedFlags(flags), (Object)ObjectUtils.notNull((Object)virtualFile.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY), (Object)PlainTextFileType.INSTANCE));
                after2 = this.getByFile(virtualFile);
                if (this.toLog()) {
                    FileTypeManagerImpl.log("F: reDetect(" + virtualFile.getName() + ") prepare to redetect. flags: " + FileTypeManagerImpl.readableFlags(flags) + "; beforeType: " + before.getName() + "; afterByFileType: " + (after2 == null ? null : after2.getName()));
                }
                if (after2 == null || FileTypeManagerImpl.mightBeReplacedByDetectedFileType(after2)) {
                    try {
                        after2 = this.detectFromContentAndCache(virtualFile, null);
                        break block10;
                    }
                    catch (IOException e) {
                        crashed.add(virtualFile);
                        if (!this.toLog()) continue;
                        FileTypeManagerImpl.log("F: reDetect(" + virtualFile.getName() + ") before: " + before.getName() + "; after: crashed with " + e.getMessage() + "; now getFileType()=" + virtualFile.getFileType().getName() + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + virtualFile.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
                        continue;
                    }
                }
                virtualFile.putUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY, null);
                flags = 0L;
                this.packedFlags.set(id2, flags);
            }
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: reDetect(" + virtualFile.getName() + ") before: " + before.getName() + "; after: " + after2.getName() + "; now getFileType()=" + virtualFile.getFileType().getName() + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + virtualFile.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
            }
            if (before == after2) continue;
            changed2.add(virtualFile);
        }
        if (!changed2.isEmpty()) {
            FileTypeManagerImpl.reparseLater(changed2);
        }
        if (!crashed.isEmpty()) {
            AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> FileTypeManagerImpl.reparseLater(crashed), 10L, TimeUnit.SECONDS);
        }
    }

    private static void reparseLater(@NotNull List<? extends VirtualFile> changed2) {
        if (changed2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().invokeLater(() -> FileContentUtilCore.reparseFiles((Collection)changed2), ApplicationManager.getApplication().getDisposed());
    }

    private boolean wasAutoDetectedBefore(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(10);
        }
        if (file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY) != null) {
            return true;
        }
        if (file2 instanceof VirtualFileWithId) {
            int id2 = ((VirtualFileWithId)file2).getId();
            return (this.packedFlags.get(id2) & 6L) == 4L;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public FileType getStdFileType(@NotNull @NonNls String name) {
        StandardFileType stdFileType;
        if (name == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(11);
        }
        Object object = this.PENDING_INIT_LOCK;
        synchronized (object) {
            this.instantiatePendingFileTypeByName(name);
            stdFileType = this.myStandardFileTypes.get(name);
        }
        PlainTextFileType plainTextFileType = stdFileType != null ? stdFileType.fileType : PlainTextFileType.INSTANCE;
        if (plainTextFileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(12);
        }
        return plainTextFileType;
    }

    private void instantiatePendingFileTypeByName(@NonNls @NotNull String name) {
        FileTypeBean bean;
        if (name == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(13);
        }
        if ((bean = this.myPendingFileTypes.get(name)) != null) {
            this.instantiateFileTypeBean(bean);
        }
    }

    public void initializeComponent() {
        if (!this.myUnresolvedMappings.isEmpty()) {
            this.instantiatePendingFileTypes();
        }
        if (!this.myUnresolvedMappings.isEmpty()) {
            for (StandardFileType pair : this.myStandardFileTypes.values()) {
                this.registerReDetectedMappings(pair);
            }
        }
        if (!this.myUnresolvedMappings.isEmpty()) {
            for (StandardFileType pair : this.myStandardFileTypes.values()) {
                this.bindUnresolvedMappings(pair.fileType);
            }
        }
        boolean isAtLeastOneStandardFileTypeHasBeenRead = false;
        for (FileType fileType : this.mySchemeManager.loadSchemes()) {
            isAtLeastOneStandardFileTypeHasBeenRead |= this.myInitialAssociations.hasAssociationsFor((Object)fileType);
        }
        if (isAtLeastOneStandardFileTypeHasBeenRead) {
            this.restoreStandardFileExtensions();
        }
    }

    @NotNull
    public FileType getFileTypeByFileName(@NotNull String fileName) {
        if (fileName == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(14);
        }
        FileType fileType = this.getFileTypeByFileName((CharSequence)fileName);
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(15);
        }
        return fileType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public FileType getFileTypeByFileName(@NotNull CharSequence fileName) {
        if (fileName == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(16);
        }
        Object object = this.PENDING_INIT_LOCK;
        // MONITORENTER : object
        FileTypeBean pendingFileType = (FileTypeBean)this.myPendingAssociations.findAssociatedFileType(fileName);
        if (pendingFileType != null) {
            FileType fileType = (FileType)ObjectUtils.notNull((Object)this.instantiateFileTypeBean(pendingFileType), (Object)UnknownFileType.INSTANCE);
            // MONITOREXIT : object
            if (fileType != null) return fileType;
            FileTypeManagerImpl.$$$reportNull$$$0(17);
            return fileType;
        }
        FileType type = (FileType)this.myPatternsTable.findAssociatedFileType(fileName);
        FileType fileType = (FileType)ObjectUtils.notNull((Object)type, (Object)UnknownFileType.INSTANCE);
        // MONITOREXIT : object
        if (fileType != null) return fileType;
        FileTypeManagerImpl.$$$reportNull$$$0(18);
        return fileType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freezeFileTypeTemporarilyIn(@NotNull VirtualFile file2, @NotNull Runnable runnable2) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(19);
        }
        if (runnable2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(20);
        }
        FileType fileType = file2.getFileType();
        Pair<VirtualFile, FileType> old = FILE_TYPE_FIXED_TEMPORARILY.get();
        FILE_TYPE_FIXED_TEMPORARILY.set((Pair<VirtualFile, FileType>)Pair.create((Object)file2, (Object)fileType));
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: freezeFileTypeTemporarilyIn(" + file2.getName() + ") to " + fileType.getName() + " in " + Thread.currentThread());
        }
        try {
            runnable2.run();
        }
        finally {
            if (old == null) {
                FILE_TYPE_FIXED_TEMPORARILY.remove();
            } else {
                FILE_TYPE_FIXED_TEMPORARILY.set(old);
            }
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: unfreezeFileType(" + file2.getName() + ") in " + Thread.currentThread());
            }
        }
    }

    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(21);
        }
        FileType fileType = this.getFileTypeByFile(file2, null);
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(22);
        }
        return fileType;
    }

    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile file2, byte @Nullable [] content2) {
        FileType overriddenFileType;
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(23);
        }
        if ((overriddenFileType = (FileType)FileTypeOverrider.EP_NAME.computeSafeIfAny(overrider -> overrider.getOverriddenFileType(file2))) != null) {
            FileType fileType = overriddenFileType;
            if (fileType == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(24);
            }
            return fileType;
        }
        FileType fileType = this.getByFile(file2);
        if (!(file2 instanceof StubVirtualFile)) {
            FileType detectedFromContent;
            if (fileType == null) {
                return this.getOrDetectFromContent(file2, content2);
            }
            if (FileTypeManagerImpl.mightBeReplacedByDetectedFileType(fileType) && FileTypeManagerImpl.isDetectable(file2) && (detectedFromContent = this.getOrDetectFromContent(file2, content2)) != PlainTextFileType.INSTANCE) {
                FileType fileType2 = detectedFromContent;
                if (fileType2 == null) {
                    FileTypeManagerImpl.$$$reportNull$$$0(25);
                }
                return fileType2;
            }
        }
        FileType fileType3 = (FileType)ObjectUtils.notNull((Object)fileType, (Object)UnknownFileType.INSTANCE);
        if (fileType3 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(26);
        }
        return fileType3;
    }

    private static boolean mightBeReplacedByDetectedFileType(FileType fileType) {
        return fileType instanceof PlainTextLikeFileType && fileType.isReadOnly();
    }

    @Nullable
    public FileType getByFile(@NotNull VirtualFile file2) {
        FileType fileType;
        Pair<VirtualFile, FileType> fixedType;
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(27);
        }
        if ((fixedType = FILE_TYPE_FIXED_TEMPORARILY.get()) != null && ((VirtualFile)fixedType.getFirst()).equals(file2)) {
            FileType fileType2 = (FileType)fixedType.getSecond();
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: getByFile(" + file2.getName() + ") was frozen to " + fileType2.getName() + " in " + Thread.currentThread());
            }
            return fileType2;
        }
        if (file2 instanceof LightVirtualFile && (fileType = ((LightVirtualFile)file2).getAssignedFileType()) != null) {
            return fileType;
        }
        for (FileType type : this.mySpecialFileTypes) {
            if (!type.isMyFileType(file2)) continue;
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: getByFile(" + file2.getName() + "): Special file type: " + type.getName());
            }
            return type;
        }
        fileType = this.getFileTypeByFileName(file2.getNameSequence());
        if (fileType == UnknownFileType.INSTANCE) {
            fileType = null;
        }
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: getByFile(" + file2.getName() + ") By name file type: " + (fileType == null ? null : fileType.getName()));
        }
        return fileType;
    }

    @NotNull
    private FileType getOrDetectFromContent(@NotNull VirtualFile file2, byte @Nullable [] content2) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(28);
        }
        if (!FileTypeManagerImpl.isDetectable(file2)) {
            FileType fileType = UnknownFileType.INSTANCE;
            if (fileType == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(29);
            }
            return fileType;
        }
        if (file2 instanceof VirtualFileWithId) {
            boolean autoDetectWasRun;
            int id2 = ((VirtualFileWithId)file2).getId();
            long flags = this.packedFlags.get(id2);
            if (!BitUtil.isSet((long)flags, (long)8L)) {
                flags = this.readFlagsFromCache(file2);
                flags = BitUtil.set((long)flags, (long)8L, (boolean)true);
                this.packedFlags.set(id2, flags);
                if (this.toLog()) {
                    FileTypeManagerImpl.log("F: getOrDetectFromContent(" + file2.getName() + "): readFlagsFromCache() = " + FileTypeManagerImpl.readableFlags(flags));
                }
            }
            if (autoDetectWasRun = BitUtil.isSet((long)flags, (long)4L)) {
                FileType type = FileTypeManagerImpl.textOrBinaryFromCachedFlags(flags);
                if (this.toLog()) {
                    FileTypeManagerImpl.log("F: getOrDetectFromContent(" + file2.getName() + "): cached type = " + (type == null ? null : type.getName()) + "; packedFlags.get(id):" + FileTypeManagerImpl.readableFlags(flags) + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
                }
                if (type != null) {
                    FileType fileType = type;
                    if (fileType == null) {
                        FileTypeManagerImpl.$$$reportNull$$$0(30);
                    }
                    return fileType;
                }
            }
        }
        FileType fileType = (FileType)file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY);
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: getOrDetectFromContent(" + file2.getName() + "): getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY) = " + (fileType == null ? null : fileType.getName()));
        }
        if (fileType == null) {
            try {
                fileType = this.detectFromContentAndCache(file2, content2);
            }
            catch (IOException e) {
                fileType = UnknownFileType.INSTANCE;
            }
        }
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: getOrDetectFromContent(" + file2.getName() + "): getFileType after detect run = " + fileType.getName());
        }
        FileType fileType2 = fileType;
        if (fileType2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(31);
        }
        return fileType2;
    }

    @NotNull
    private static String readableFlags(long flags) {
        String result2 = "";
        if (BitUtil.isSet((long)flags, (long)8L)) {
            result2 = result2 + "ATTRIBUTES_WERE_LOADED_MASK";
        }
        if (BitUtil.isSet((long)flags, (long)4L)) {
            result2 = result2 + (result2.isEmpty() ? "" : " | ") + "AUTO_DETECT_WAS_RUN_MASK";
        }
        if (BitUtil.isSet((long)flags, (long)2L)) {
            result2 = result2 + (result2.isEmpty() ? "" : " | ") + "AUTO_DETECTED_AS_BINARY_MASK";
        }
        if (BitUtil.isSet((long)flags, (long)1L)) {
            result2 = result2 + (result2.isEmpty() ? "" : " | ") + "AUTO_DETECTED_AS_TEXT_MASK";
        }
        String string = result2;
        if (string == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(32);
        }
        return string;
    }

    protected byte readFlagsFromCache(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(33);
        }
        boolean wasAutoDetectRun = false;
        byte status = 0;
        try (DataInputStream stream = this.autoDetectedAttribute.readAttribute(file2);){
            status = stream == null ? (byte)0 : stream.readByte();
            wasAutoDetectRun = stream != null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        status = BitUtil.set((byte)status, (byte)4, (boolean)wasAutoDetectRun);
        return (byte)(status & 7);
    }

    protected void writeFlagsToCache(@NotNull VirtualFile file2, int flags) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(34);
        }
        try (DataOutputStream stream = this.autoDetectedAttribute.writeAttribute(file2);){
            stream.writeByte(flags & 3);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    void clearCaches() {
        this.packedFlags.clear();
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: clearCaches()");
        }
    }

    private void clearPersistentAttributes() {
        int count = this.fileTypeChangedCount.incrementAndGet();
        this.autoDetectedAttribute = this.autoDetectedAttribute.newVersion(count);
        PropertiesComponent.getInstance().setValue("fileTypeChangedCounter", Integer.toString(count));
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: clearPersistentAttributes()");
        }
    }

    @Nullable
    private static FileType textOrBinaryFromCachedFlags(long flags) {
        return BitUtil.isSet((long)flags, (long)1L) ? PlainTextFileType.INSTANCE : (BitUtil.isSet((long)flags, (long)2L) ? UnknownFileType.INSTANCE : null);
    }

    private void cacheAutoDetectedFileType(@NotNull VirtualFile file2, @NotNull FileType fileType) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(35);
        }
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(36);
        }
        boolean wasAutodetectedAsText = fileType == PlainTextFileType.INSTANCE;
        boolean wasAutodetectedAsBinary = fileType == UnknownFileType.INSTANCE;
        int flags = BitUtil.set((int)0, (int)1, (boolean)wasAutodetectedAsText);
        flags = BitUtil.set((int)flags, (int)2, (boolean)wasAutodetectedAsBinary);
        this.writeFlagsToCache(file2, flags);
        if (file2 instanceof VirtualFileWithId) {
            int id2 = ((VirtualFileWithId)file2).getId();
            flags = BitUtil.set((int)flags, (int)4, (boolean)true);
            flags = BitUtil.set((int)flags, (int)8, (boolean)true);
            this.packedFlags.set(id2, (long)flags);
            if (wasAutodetectedAsText || wasAutodetectedAsBinary) {
                file2.putUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY, null);
                if (this.toLog()) {
                    FileTypeManagerImpl.log("F: cacheAutoDetectedFileType(" + file2.getName() + ") cached to " + fileType.getName() + " flags = " + FileTypeManagerImpl.readableFlags(flags) + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
                }
                return;
            }
        }
        file2.putUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY, (Object)fileType);
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: cacheAutoDetectedFileType(" + file2.getName() + ") cached to " + fileType.getName() + " flags = " + FileTypeManagerImpl.readableFlags(flags) + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
        }
    }

    public FileType findFileTypeByName(@NotNull String fileTypeName) {
        FileType type;
        if (fileTypeName == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(37);
        }
        if ((type = this.getStdFileType(fileTypeName)) != PlainTextFileType.INSTANCE || fileTypeName.equals(type.getName())) {
            return type;
        }
        for (FileType fileType : this.mySchemeManager.getAllSchemes()) {
            if (!fileTypeName.equals(fileType.getName())) continue;
            return fileType;
        }
        return null;
    }

    private static boolean isDetectable(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(38);
        }
        if (file2.isDirectory() || !file2.isValid() || file2.is(VFileProperty.SPECIAL) || file2.getLength() == 0L) {
            return false;
        }
        return file2.getFileSystem() instanceof FileSystemInterface;
    }

    private int readSafely(@NotNull InputStream stream, byte @NotNull [] buffer, int offset, int length) throws IOException {
        int n;
        if (stream == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(39);
        }
        if (buffer == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(40);
        }
        if ((n = stream.read(buffer, offset, length)) <= 0) {
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: processFirstBytes(): inputStream.read() returned " + n + "; retrying with read action. stream=" + FileTypeManagerImpl.streamInfo(stream));
            }
            n = (Integer)ReadAction.compute(() -> stream.read(buffer, offset, length));
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: processFirstBytes(): under read action inputStream.read() returned " + n + "; stream=" + FileTypeManagerImpl.streamInfo(stream));
            }
        }
        return n;
    }

    @NotNull
    private FileType detectFromContentAndCache(@NotNull VirtualFile file2, byte @Nullable [] content2) throws IOException {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(41);
        }
        long start2 = System.currentTimeMillis();
        FileType fileType = this.detectFromContent(file2, content2, FileTypeRegistry.FileTypeDetector.EP_NAME.getExtensionList());
        this.cacheAutoDetectedFileType(file2, fileType);
        this.counterAutoDetect.incrementAndGet();
        long elapsed = System.currentTimeMillis() - start2;
        this.elapsedAutoDetect.addAndGet(elapsed);
        FileType fileType2 = fileType;
        if (fileType2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(42);
        }
        return fileType2;
    }

    @NotNull
    private FileType detectFromContent(@NotNull VirtualFile file2, byte @Nullable [] content2, @NotNull Iterable<? extends FileTypeRegistry.FileTypeDetector> detectors) throws IOException {
        FileType fileType;
        block31: {
            if (file2 == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(43);
            }
            if (detectors == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(44);
            }
            if (content2 != null) {
                fileType = this.detect(file2, content2, content2.length, detectors);
            } else {
                try (InputStream inputStream = ((FileSystemInterface)file2.getFileSystem()).getInputStream(file2);){
                    if (this.toLog()) {
                        FileTypeManagerImpl.log("F: detectFromContentAndCache(" + file2.getName() + "): inputStream=" + FileTypeManagerImpl.streamInfo(inputStream));
                    }
                    int fileLength = (int)file2.getLength();
                    int bufferLength = StreamSupport.stream(detectors.spliterator(), false).map(FileTypeRegistry.FileTypeDetector::getDesiredContentPrefixLength).max(Comparator.naturalOrder()).orElse(FileUtilRt.getUserContentLoadLimit());
                    byte[] buffer = fileLength <= 20480 ? FileUtilRt.getThreadLocalBuffer() : new byte[Math.min(fileLength, bufferLength)];
                    int n = this.readSafely(inputStream, buffer, 0, buffer.length);
                    fileType = this.detect(file2, buffer, n, detectors);
                    if (!this.toLog()) break block31;
                    try (InputStream newStream = ((FileSystemInterface)file2.getFileSystem()).getInputStream(file2);){
                        byte[] buffer2 = new byte[50];
                        int n2 = newStream.read(buffer2, 0, buffer2.length);
                        FileTypeManagerImpl.log("F: detectFromContentAndCache(" + file2.getName() + "): result: " + fileType.getName() + "; stream: " + FileTypeManagerImpl.streamInfo(inputStream) + "; newStream: " + FileTypeManagerImpl.streamInfo(newStream) + "; read: " + n2 + "; buffer: " + Arrays.toString(buffer2));
                    }
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(file2 + "; type=" + fileType.getDescription() + "; " + this.counterAutoDetect);
        }
        FileType fileType2 = fileType;
        if (fileType2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(45);
        }
        return fileType2;
    }

    @NotNull
    private FileType detect(@NotNull VirtualFile file2, byte @NotNull [] bytes, int length, @NotNull Iterable<? extends FileTypeRegistry.FileTypeDetector> detectors) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(46);
        }
        if (detectors == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(47);
        }
        if (bytes == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(48);
        }
        if (length <= 0) {
            FileType fileType = UnknownFileType.INSTANCE;
            if (fileType == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(49);
            }
            return fileType;
        }
        FileType fileType = LoadTextUtil.processTextFromBinaryPresentationOrNull(bytes, length, file2, true, true, (FileType)PlainTextFileType.INSTANCE, (NotNullFunction<? super CharSequence, ? extends FileType>)((NotNullFunction)text2 -> {
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: detectFromContentAndCache.processFirstBytes(" + file2.getName() + "): bytes length=" + length + "; isText=" + (text2 != null) + "; text='" + (text2 == null ? null : StringUtil.first((CharSequence)text2, (int)100, (boolean)true)) + "', detectors=" + detectors);
            }
            Object detected = null;
            ByteArraySequence firstBytes = new ByteArraySequence(bytes, 0, length);
            for (FileTypeRegistry.FileTypeDetector detector : detectors) {
                try {
                    detected = detector.detect(file2, (ByteSequence)firstBytes, text2);
                }
                catch (ProcessCanceledException e) {
                    LOG.error("Detector " + detector + " (" + detector.getClass() + ") threw PCE. Bad detector, bad!", (Throwable)new RuntimeException(e));
                }
                catch (Exception e) {
                    LOG.error("Detector " + detector + " (" + detector.getClass() + ") exception occurred:", (Throwable)e);
                }
                if (detected == null) continue;
                if (!this.toLog()) break;
                FileTypeManagerImpl.log("F: detectFromContentAndCache.processFirstBytes(" + file2.getName() + "): detector " + detector + " type as " + detected.getName());
                break;
            }
            if (detected == null) {
                Object object = detected = text2 == null ? UnknownFileType.INSTANCE : PlainTextFileType.INSTANCE;
                if (this.toLog()) {
                    FileTypeManagerImpl.log("F: detectFromContentAndCache.processFirstBytes(" + file2.getName() + "): no detector was able to detect. assigned " + detected.getName());
                }
            }
            return detected;
        }));
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(50);
        }
        return fileType;
    }

    private static Object streamInfo(@NotNull InputStream stream) throws IOException {
        if (stream == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(51);
        }
        if (stream instanceof BufferedInputStream) {
            InputStream in = (InputStream)ReflectionUtil.getField(stream.getClass(), (Object)stream, InputStream.class, (String)"in");
            byte[] buf = (byte[])ReflectionUtil.getField(stream.getClass(), (Object)stream, byte[].class, (String)"buf");
            int count = (Integer)ReflectionUtil.getField(stream.getClass(), (Object)stream, Integer.TYPE, (String)"count");
            int pos = (Integer)ReflectionUtil.getField(stream.getClass(), (Object)stream, Integer.TYPE, (String)"pos");
            return "BufferedInputStream(buf=" + (buf == null ? null : Arrays.toString(Arrays.copyOf(buf, count))) + ", count=" + count + ", pos=" + pos + ", in=" + FileTypeManagerImpl.streamInfo(in) + ")";
        }
        if (stream instanceof FileInputStream) {
            String path = (String)ReflectionUtil.getField(stream.getClass(), (Object)stream, String.class, (String)"path");
            FileChannel channel = (FileChannel)ReflectionUtil.getField(stream.getClass(), (Object)stream, FileChannel.class, (String)"channel");
            boolean closed = (Boolean)ReflectionUtil.getField(stream.getClass(), (Object)stream, Boolean.TYPE, (String)"closed");
            int available = stream.available();
            File file2 = new File(path);
            return "FileInputStream(path=" + path + ", available=" + available + ", closed=" + closed + ", channel=" + channel + ", channel.size=" + (channel == null ? null : Long.valueOf(channel.size())) + ", file.exists=" + file2.exists() + ", file.content='" + FileUtil.loadFile((File)file2) + "')";
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LanguageFileType findFileTypeByLanguage(@NotNull Language language) {
        if (language == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(52);
        }
        Object object = this.PENDING_INIT_LOCK;
        synchronized (object) {
            for (FileTypeBean bean : this.myPendingFileTypes.values()) {
                if (!language.getID().equals(bean.language)) continue;
                return (LanguageFileType)this.instantiateFileTypeBean(bean);
            }
        }
        return language.findMyFileType(this.mySchemeManager.getAllSchemes().toArray(FileType.EMPTY_ARRAY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public FileType getFileTypeByExtension(@NotNull String extension) {
        if (extension == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(53);
        }
        Object object = this.PENDING_INIT_LOCK;
        // MONITORENTER : object
        FileTypeBean pendingFileType = (FileTypeBean)this.myPendingAssociations.findByExtension((CharSequence)extension);
        if (pendingFileType != null) {
            FileType fileType = (FileType)ObjectUtils.notNull((Object)this.instantiateFileTypeBean(pendingFileType), (Object)UnknownFileType.INSTANCE);
            // MONITOREXIT : object
            if (fileType != null) return fileType;
            FileTypeManagerImpl.$$$reportNull$$$0(54);
            return fileType;
        }
        FileType type = (FileType)this.myPatternsTable.findByExtension((CharSequence)extension);
        FileType fileType = (FileType)ObjectUtils.notNull((Object)type, (Object)UnknownFileType.INSTANCE);
        // MONITOREXIT : object
        if (fileType != null) return fileType;
        FileTypeManagerImpl.$$$reportNull$$$0(55);
        return fileType;
    }

    @Override
    @Deprecated
    public void registerFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(56);
        }
        this.registerFileType(fileType, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    public void registerFileType(@NotNull FileType type, @NotNull List<? extends FileNameMatcher> defaultAssociations) {
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(57);
        }
        if (defaultAssociations == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(58);
        }
        DeprecatedMethodException.report((String)"Use fileType extension instead.");
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.fireBeforeFileTypesChanged();
            this.registerFileTypeWithoutNotification(type, defaultAssociations, true);
            this.fireFileTypesChanged(type, null);
        });
    }

    @Override
    public void unregisterFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(59);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.fireBeforeFileTypesChanged();
            this.unregisterFileTypeWithoutNotification(fileType);
            this.myStandardFileTypes.remove(fileType.getName());
            this.fireFileTypesChanged(null, fileType);
        });
    }

    private void unregisterFileTypeWithoutNotification(@NotNull FileType fileType) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(60);
        }
        this.myPatternsTable.removeAllAssociations((Object)fileType);
        this.myInitialAssociations.removeAllAssociations((Object)fileType);
        this.mySchemeManager.removeScheme(fileType);
        if (fileType instanceof FileTypeIdentifiableByVirtualFile) {
            FileTypeIdentifiableByVirtualFile fakeFileType = (FileTypeIdentifiableByVirtualFile)fileType;
            this.mySpecialFileTypes = (FileTypeIdentifiableByVirtualFile[])ArrayUtil.remove((Object[])this.mySpecialFileTypes, (Object)fakeFileType, (ArrayFactory)FileTypeIdentifiableByVirtualFile.ARRAY_FACTORY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileType @NotNull [] getRegisteredFileTypes() {
        Object object = this.PENDING_INIT_LOCK;
        synchronized (object) {
            this.instantiatePendingFileTypes();
        }
        List<FileType> fileTypes = this.mySchemeManager.getAllSchemes();
        FileType[] fileTypeArray = fileTypes.toArray(FileType.EMPTY_ARRAY);
        if (fileTypeArray == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(61);
        }
        return fileTypeArray;
    }

    @Override
    @NotNull
    public String getExtension(@NotNull String fileName) {
        if (fileName == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(62);
        }
        String string = FileUtilRt.getExtension((String)fileName);
        if (string == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(63);
        }
        return string;
    }

    @NotNull
    public String getIgnoredFilesList() {
        Set masks = this.myIgnoredPatterns.getIgnoreMasks();
        String string = masks.isEmpty() ? "" : StringUtil.join((Collection)masks, (String)";") + ";";
        if (string == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(64);
        }
        return string;
    }

    public void setIgnoredFilesList(@NotNull String list2) {
        if (list2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(65);
        }
        this.fireBeforeFileTypesChanged();
        this.myIgnoredFileCache.clearCache();
        this.myIgnoredPatterns.setIgnoreMasks(list2);
        this.fireFileTypesChanged();
    }

    @Override
    public boolean isIgnoredFilesListEqualToCurrent(@NotNull String list2) {
        if (list2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(66);
        }
        THashSet tempSet = new THashSet();
        StringTokenizer tokenizer = new StringTokenizer(list2, ";");
        while (tokenizer.hasMoreTokens()) {
            tempSet.add(tokenizer.nextToken());
        }
        return tempSet.equals(this.myIgnoredPatterns.getIgnoreMasks());
    }

    public boolean isFileIgnored(@NotNull String name) {
        if (name == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(67);
        }
        return this.myIgnoredPatterns.isIgnored((CharSequence)name);
    }

    public boolean isFileIgnored(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(68);
        }
        return this.myIgnoredFileCache.isFileIgnored(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public String @NotNull [] getAssociatedExtensions(@NotNull FileType type) {
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(69);
        }
        Object object = this.PENDING_INIT_LOCK;
        // MONITORENTER : object
        this.instantiatePendingFileTypeByName(type.getName());
        String[] stringArray = this.myPatternsTable.getAssociatedExtensions((Object)type);
        // MONITOREXIT : object
        if (stringArray != null) return stringArray;
        FileTypeManagerImpl.$$$reportNull$$$0(70);
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<FileNameMatcher> getAssociations(@NotNull FileType type) {
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(71);
        }
        Object object = this.PENDING_INIT_LOCK;
        // MONITORENTER : object
        this.instantiatePendingFileTypeByName(type.getName());
        List list2 = this.myPatternsTable.getAssociations((Object)type);
        // MONITOREXIT : object
        if (list2 != null) return list2;
        FileTypeManagerImpl.$$$reportNull$$$0(72);
        return list2;
    }

    public void associate(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(73);
        }
        if (matcher == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(74);
        }
        this.associate(type, matcher, true);
    }

    public void removeAssociation(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(75);
        }
        if (matcher == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(76);
        }
        this.removeAssociation(type, matcher, true);
    }

    @Override
    public void fireBeforeFileTypesChanged() {
        FileTypeEvent event = new FileTypeEvent((Object)this, null, null);
        ((FileTypeListener)this.myMessageBus.syncPublisher(TOPIC)).beforeFileTypesChanged(event);
    }

    @Override
    public void fireFileTypesChanged() {
        this.fireFileTypesChanged(null, null);
    }

    public void fireFileTypesChanged(@Nullable FileType addedFileType, @Nullable FileType removedFileType) {
        this.clearCaches();
        this.clearPersistentAttributes();
        ((FileTypeListener)this.myMessageBus.syncPublisher(TOPIC)).fileTypesChanged(new FileTypeEvent((Object)this, addedFileType, removedFileType));
    }

    public void addFileTypeListener(@NotNull FileTypeListener listener2) {
        if (listener2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(77);
        }
        MessageBusConnection connection = this.myMessageBus.connect();
        connection.subscribe(TOPIC, (Object)listener2);
        this.myAdapters.put(listener2, connection);
    }

    public void removeFileTypeListener(@NotNull FileTypeListener listener2) {
        MessageBusConnection connection;
        if (listener2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(78);
        }
        if ((connection = this.myAdapters.remove(listener2)) != null) {
            connection.disconnect();
        }
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(79);
        }
        int savedVersion = StringUtilRt.parseInt((String)state.getAttributeValue(ATTRIBUTE_VERSION), (int)0);
        for (Element element2 : state.getChildren()) {
            if (element2.getName().equals(ELEMENT_IGNORE_FILES)) {
                this.myIgnoredPatterns.setIgnoreMasks(element2.getAttributeValue(ATTRIBUTE_LIST));
                continue;
            }
            if (!"extensionMap".equals(element2.getName())) continue;
            this.readGlobalMappings(element2, false);
        }
        if (savedVersion < 4) {
            if (savedVersion == 0) {
                this.addIgnore(".svn");
            }
            if (savedVersion < 2) {
                this.restoreStandardFileExtensions();
            }
            this.addIgnore("*.pyc");
            this.addIgnore("*.pyo");
            this.addIgnore(".git");
        }
        if (savedVersion < 5) {
            this.addIgnore("*.hprof");
        }
        if (savedVersion < 6) {
            this.addIgnore("_svn");
        }
        if (savedVersion < 7) {
            this.addIgnore(".hg");
        }
        if (savedVersion < 8) {
            this.addIgnore("*~");
        }
        if (savedVersion < 9) {
            this.addIgnore("__pycache__");
        }
        if (savedVersion < 11) {
            this.addIgnore("*.rbc");
        }
        if (savedVersion < 13) {
            this.unignoreMask("*.lib");
        }
        if (savedVersion < 15) {
            this.unignoreMask(".bundle");
        }
        if (savedVersion < 16) {
            this.unignoreMask(".tox");
        }
        if (savedVersion < 17) {
            this.addIgnore("*.rbc");
        }
        this.myIgnoredFileCache.clearCache();
        String counter = JDOMExternalizer.readString((Element)state, (String)"fileTypeChangedCounter");
        if (counter != null) {
            this.fileTypeChangedCount.set(StringUtilRt.parseInt((String)counter, (int)0));
            this.autoDetectedAttribute = this.autoDetectedAttribute.newVersion(this.fileTypeChangedCount.get());
        }
    }

    private void unignoreMask(@NotNull String maskToRemove) {
        if (maskToRemove == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(80);
        }
        LinkedHashSet masks = new LinkedHashSet(this.myIgnoredPatterns.getIgnoreMasks());
        masks.remove(maskToRemove);
        this.myIgnoredPatterns.clearPatterns();
        for (String each : masks) {
            this.myIgnoredPatterns.addIgnoreMask(each);
        }
    }

    private void readGlobalMappings(@NotNull Element e, boolean isAddToInit) {
        if (e == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(81);
        }
        for (Pair<FileNameMatcher, String> association : AbstractFileType.readAssociations(e)) {
            FileType type = this.getFileTypeByName((String)association.getSecond());
            FileNameMatcher matcher = (FileNameMatcher)association.getFirst();
            FileTypeBean pendingFileTypeBean = (FileTypeBean)this.myPendingAssociations.findAssociatedFileType(matcher);
            if (pendingFileTypeBean != null) {
                this.instantiateFileTypeBean(pendingFileTypeBean);
            }
            if (type != null) {
                FileType newFileType;
                if (PlainTextFileType.INSTANCE == type && (newFileType = (FileType)this.myPatternsTable.findAssociatedFileType(matcher)) != null && newFileType != PlainTextFileType.INSTANCE && newFileType != UnknownFileType.INSTANCE) {
                    this.myRemovedMappingTracker.add(matcher, newFileType.getName(), false);
                }
                this.associate(type, matcher, false);
                if (!isAddToInit) continue;
                this.myInitialAssociations.addAssociation(matcher, (Object)type);
                continue;
            }
            this.myUnresolvedMappings.put(matcher, (String)association.getSecond());
        }
        this.myRemovedMappingTracker.load(e);
        for (RemovedMappingTracker.RemovedMapping mapping2 : this.myRemovedMappingTracker.getRemovedMappings()) {
            FileType fileType = this.getFileTypeByName(mapping2.getFileTypeName());
            if (fileType == null) continue;
            this.removeAssociation(fileType, mapping2.getFileNameMatcher(), false);
        }
    }

    private void addIgnore(@NonNls @NotNull String ignoreMask) {
        if (ignoreMask == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(82);
        }
        this.myIgnoredPatterns.addIgnoreMask(ignoreMask);
    }

    private void restoreStandardFileExtensions() {
        for (String name : FILE_TYPES_WITH_PREDEFINED_EXTENSIONS) {
            StandardFileType stdFileType = this.myStandardFileTypes.get(name);
            if (stdFileType == null) continue;
            FileType fileType = stdFileType.fileType;
            for (FileNameMatcher matcher : this.myPatternsTable.getAssociations((Object)fileType)) {
                FileType defaultFileType = (FileType)this.myInitialAssociations.findAssociatedFileType(matcher);
                if (defaultFileType == null || defaultFileType == fileType) continue;
                this.removeAssociation(fileType, matcher, false);
                this.associate(defaultFileType, matcher, false);
            }
            for (FileNameMatcher matcher : this.myInitialAssociations.getAssociations((Object)fileType)) {
                this.associate(fileType, matcher, false);
            }
        }
    }

    @NotNull
    public Element getState() {
        String ignoreFiles;
        Element state = new Element("state");
        Set masks = this.myIgnoredPatterns.getIgnoreMasks();
        if (masks.isEmpty()) {
            ignoreFiles = "";
        } else {
            Object[] strings = ArrayUtilRt.toStringArray((Collection)masks);
            Arrays.sort(strings);
            ignoreFiles = StringUtil.join((String[])strings, (String)";") + ";";
        }
        if (!ignoreFiles.equalsIgnoreCase(DEFAULT_IGNORED)) {
            state.addContent(new Element(ELEMENT_IGNORE_FILES).setAttribute(ATTRIBUTE_LIST, ignoreFiles));
        }
        Element map2 = new Element("extensionMap");
        ArrayList<FileType> notExternalizableFileTypes = new ArrayList<FileType>();
        for (FileType type : this.mySchemeManager.getAllSchemes()) {
            if (type instanceof AbstractFileType && !this.myDefaultTypes.contains(type)) continue;
            notExternalizableFileTypes.add(type);
        }
        if (!notExternalizableFileTypes.isEmpty()) {
            Collections.sort(notExternalizableFileTypes, Comparator.comparing(FileType::getName));
            for (FileType type : notExternalizableFileTypes) {
                this.writeExtensionsMap(map2, type, true);
            }
        }
        this.myRemovedMappingTracker.save(map2);
        if (!this.myUnresolvedMappings.isEmpty()) {
            FileNameMatcher[] unresolvedMappingKeys = this.myUnresolvedMappings.keySet().toArray(new FileNameMatcher[0]);
            Arrays.sort(unresolvedMappingKeys, Comparator.comparing(FileNameMatcher::getPresentableString));
            for (FileNameMatcher fileNameMatcher : unresolvedMappingKeys) {
                Element content2 = AbstractFileType.writeMapping(this.myUnresolvedMappings.get(fileNameMatcher), fileNameMatcher, true);
                if (content2 == null) continue;
                map2.addContent(content2);
            }
        }
        if (!map2.getChildren().isEmpty()) {
            state.addContent(map2);
        }
        if (!state.getChildren().isEmpty()) {
            state.setAttribute(ATTRIBUTE_VERSION, String.valueOf(17));
        }
        Element element2 = state;
        if (element2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(83);
        }
        return element2;
    }

    private void writeExtensionsMap(@NotNull Element map2, @NotNull FileType type, boolean specifyTypeName) {
        if (map2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(84);
        }
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(85);
        }
        List associations = this.myPatternsTable.getAssociations((Object)type);
        THashSet defaultAssociations = new THashSet((Collection)this.myInitialAssociations.getAssociations((Object)type));
        for (FileNameMatcher matcher : associations) {
            Element content2;
            boolean isDefaultAssociationContains = defaultAssociations.remove(matcher);
            if (isDefaultAssociationContains || !FileTypeManagerImpl.shouldSave(type) || (content2 = AbstractFileType.writeMapping(type.getName(), matcher, specifyTypeName)) == null) continue;
            map2.addContent(content2);
        }
        this.myRemovedMappingTracker.saveRemovedMappingsForFileType(map2, type.getName(), (Set<? extends FileNameMatcher>)defaultAssociations, specifyTypeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private FileType getFileTypeByName(@NotNull String name) {
        if (name == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(86);
        }
        Object object = this.PENDING_INIT_LOCK;
        synchronized (object) {
            this.instantiatePendingFileTypeByName(name);
            return this.mySchemeManager.findSchemeByName(name);
        }
    }

    @NotNull
    private static List<FileNameMatcher> parse(@Nullable String semicolonDelimited) {
        return FileTypeManagerImpl.parse(semicolonDelimited, (Function<? super String, ? extends FileNameMatcher>)((Function)token -> new ExtensionFileNameMatcher(token)));
    }

    @NotNull
    private static List<FileNameMatcher> parse(@Nullable String semicolonDelimited, Function<? super String, ? extends FileNameMatcher> matcherFactory) {
        if (semicolonDelimited == null) {
            List<FileNameMatcher> list2 = Collections.emptyList();
            if (list2 == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(87);
            }
            return list2;
        }
        StringTokenizer tokenizer = new StringTokenizer(semicolonDelimited, ";", false);
        ArrayList<FileNameMatcher> list3 = new ArrayList<FileNameMatcher>(semicolonDelimited.length() / "py;".length());
        while (tokenizer.hasMoreTokens()) {
            list3.add((FileNameMatcher)matcherFactory.fun((Object)tokenizer.nextToken().trim()));
        }
        ArrayList<FileNameMatcher> arrayList = list3;
        if (arrayList == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(88);
        }
        return arrayList;
    }

    private void registerFileTypeWithoutNotification(@NotNull FileType fileType, @NotNull List<? extends FileNameMatcher> matchers, boolean addScheme) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(89);
        }
        if (matchers == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(90);
        }
        if (addScheme) {
            this.mySchemeManager.addScheme(fileType);
        }
        for (FileNameMatcher fileNameMatcher : matchers) {
            this.myPatternsTable.addAssociation(fileNameMatcher, (Object)fileType);
            this.myInitialAssociations.addAssociation(fileNameMatcher, (Object)fileType);
        }
        if (fileType instanceof FileTypeIdentifiableByVirtualFile) {
            this.mySpecialFileTypes = (FileTypeIdentifiableByVirtualFile[])ArrayUtil.append((Object[])this.mySpecialFileTypes, (Object)((FileTypeIdentifiableByVirtualFile)fileType), (ArrayFactory)FileTypeIdentifiableByVirtualFile.ARRAY_FACTORY);
        }
    }

    private void bindUnresolvedMappings(@NotNull FileType fileType) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(91);
        }
        for (FileNameMatcher matcher : new THashSet(this.myUnresolvedMappings.keySet())) {
            String name = this.myUnresolvedMappings.get(matcher);
            if (!Comparing.equal((String)name, (String)fileType.getName())) continue;
            this.myPatternsTable.addAssociation(matcher, (Object)fileType);
            this.myUnresolvedMappings.remove(matcher);
        }
        for (FileNameMatcher matcher : this.myRemovedMappingTracker.getMappingsForFileType(fileType.getName())) {
            this.removeAssociation(fileType, matcher, false);
        }
    }

    @NotNull
    private FileType loadFileType(@NotNull Element typeElement, boolean isDefault) {
        FileType type;
        if (typeElement == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(92);
        }
        String fileTypeName = typeElement.getAttributeValue(ATTRIBUTE_NAME);
        String fileTypeDescr = typeElement.getAttributeValue(ATTRIBUTE_DESCRIPTION);
        String iconPath = typeElement.getAttributeValue("icon");
        String extensionsStr = StringUtil.nullize((String)typeElement.getAttributeValue("extensions"));
        if (isDefault && extensionsStr != null) {
            extensionsStr = this.filterAlreadyRegisteredExtensions(extensionsStr);
        }
        FileType fileType = type = isDefault ? this.getFileTypeByName(fileTypeName) : null;
        if (type != null) {
            FileType fileType2 = type;
            if (fileType2 == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(93);
            }
            return fileType2;
        }
        Element element2 = typeElement.getChild("highlighting");
        if (element2 == null) {
            type = new UserBinaryFileType();
        } else {
            SyntaxTable table = AbstractFileType.readSyntaxTable(element2);
            type = new AbstractFileType(table);
            ((AbstractFileType)type).initSupport();
        }
        FileTypeManagerImpl.setFileTypeAttributes((UserFileType)type, fileTypeName, fileTypeDescr, iconPath);
        this.registerFileTypeWithoutNotification(type, FileTypeManagerImpl.parse(extensionsStr), isDefault);
        if (isDefault) {
            this.myDefaultTypes.add(type);
            if (type instanceof ExternalizableFileType) {
                ((ExternalizableFileType)type).markDefaultSettings();
            }
        } else {
            Element extensions2 = typeElement.getChild("extensionMap");
            if (extensions2 != null) {
                for (Pair<FileNameMatcher, String> association : AbstractFileType.readAssociations(extensions2)) {
                    this.associate(type, (FileNameMatcher)association.getFirst(), false);
                }
                for (RemovedMappingTracker.RemovedMapping removedAssociation : RemovedMappingTracker.readRemovedMappings(extensions2)) {
                    this.removeAssociation(type, removedAssociation.getFileNameMatcher(), false);
                }
            }
        }
        FileType fileType3 = type;
        if (fileType3 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(94);
        }
        return fileType3;
    }

    @Nullable
    private String filterAlreadyRegisteredExtensions(@NotNull String semicolonDelimited) {
        if (semicolonDelimited == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(95);
        }
        StringTokenizer tokenizer = new StringTokenizer(semicolonDelimited, ";", false);
        StringBuilder builder2 = null;
        while (tokenizer.hasMoreTokens()) {
            String extension = tokenizer.nextToken().trim();
            if (this.myPendingAssociations.findByExtension((CharSequence)extension) != null || this.getFileTypeByExtension(extension) != UnknownFileType.INSTANCE) continue;
            if (builder2 == null) {
                builder2 = new StringBuilder();
            } else if (builder2.length() > 0) {
                builder2.append(";");
            }
            builder2.append(extension);
        }
        return builder2 == null ? null : builder2.toString();
    }

    private static void setFileTypeAttributes(@NotNull UserFileType fileType, @Nullable String name, @Nullable String description, @Nullable String iconPath) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(96);
        }
        if (!StringUtil.isEmptyOrSpaces((String)iconPath)) {
            fileType.setIconPath(iconPath);
        }
        if (description != null) {
            fileType.setDescription(description);
        }
        if (name != null) {
            fileType.setName(name);
        }
    }

    private static boolean shouldSave(@NotNull FileType fileType) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(97);
        }
        return fileType != UnknownFileType.INSTANCE && !fileType.isReadOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    FileTypeAssocTable<FileType> getExtensionMap() {
        Object object = this.PENDING_INIT_LOCK;
        synchronized (object) {
            this.instantiatePendingFileTypes();
        }
        FileTypeAssocTable<FileType> fileTypeAssocTable = this.myPatternsTable;
        if (fileTypeAssocTable == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(98);
        }
        return fileTypeAssocTable;
    }

    void setPatternsTable(@NotNull Set<? extends FileType> fileTypes, @NotNull FileTypeAssocTable<FileType> assocTable) {
        if (fileTypes == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(99);
        }
        if (assocTable == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(100);
        }
        Map removedMappings = this.getExtensionMap().getRemovedMappings(assocTable, fileTypes);
        this.fireBeforeFileTypesChanged();
        for (FileType existing : this.getRegisteredFileTypes()) {
            if (fileTypes.contains(existing)) continue;
            this.mySchemeManager.removeScheme(existing);
        }
        for (FileType fileType : fileTypes) {
            this.mySchemeManager.addScheme(fileType);
            if (!(fileType instanceof AbstractFileType)) continue;
            ((AbstractFileType)fileType).initSupport();
        }
        this.myPatternsTable = assocTable.copy();
        this.fireFileTypesChanged();
        this.myRemovedMappingTracker.removeMatching((matcher, fileTypeName) -> {
            FileType fileType = this.getFileTypeByName((String)fileTypeName);
            return fileType != null && assocTable.isAssociatedWith((Object)fileType, matcher);
        });
        for (Map.Entry entry : removedMappings.entrySet()) {
            this.myRemovedMappingTracker.add((FileNameMatcher)entry.getKey(), ((FileType)entry.getValue()).getName(), true);
        }
    }

    public void associate(@NotNull FileType fileType, @NotNull FileNameMatcher matcher, boolean fireChange) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(101);
        }
        if (matcher == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(102);
        }
        if (!this.myPatternsTable.isAssociatedWith((Object)fileType, matcher)) {
            if (fireChange) {
                this.fireBeforeFileTypesChanged();
            }
            this.myPatternsTable.addAssociation(matcher, (Object)fileType);
            if (fireChange) {
                this.fireFileTypesChanged();
            }
        }
    }

    public void removeAssociation(@NotNull FileType fileType, @NotNull FileNameMatcher matcher, boolean fireChange) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(103);
        }
        if (matcher == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(104);
        }
        if (this.myPatternsTable.isAssociatedWith((Object)fileType, matcher)) {
            if (fireChange) {
                this.fireBeforeFileTypesChanged();
            }
            this.myPatternsTable.removeAssociation(matcher, (Object)fileType);
            if (fireChange) {
                this.fireFileTypesChanged();
            }
        }
    }

    @Nullable
    public FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file2) {
        FileType type;
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(105);
        }
        if ((type = file2.getFileType()) == UnknownFileType.INSTANCE) {
            type = FileTypeChooser.associateFileType(file2.getName());
        }
        return type;
    }

    public FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(106);
        }
        if (project == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(107);
        }
        return FileTypeChooser.getKnownFileTypeOrAssociate(file2, project);
    }

    private void registerReDetectedMappings(@NotNull StandardFileType pair) {
        FileType fileType;
        if (pair == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(108);
        }
        if ((fileType = pair.fileType) == PlainTextFileType.INSTANCE) {
            return;
        }
        for (FileNameMatcher matcher : pair.matchers) {
            this.registerReDetectedMapping(fileType.getName(), matcher);
            if (!(matcher instanceof ExtensionFileNameMatcher)) continue;
            ExtensionFileNameMatcher extMatcher = (ExtensionFileNameMatcher)matcher;
            this.registerReDetectedMapping(fileType.getName(), (FileNameMatcher)new ExactFileNameMatcher("." + extMatcher.getExtension()));
        }
    }

    private void registerReDetectedMapping(@NotNull String fileTypeName, @NotNull FileNameMatcher matcher) {
        String typeName;
        if (fileTypeName == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(109);
        }
        if (matcher == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(110);
        }
        if ((typeName = this.myUnresolvedMappings.get(matcher)) != null && !typeName.equals(fileTypeName)) {
            if (!this.myRemovedMappingTracker.hasRemovedMapping(matcher)) {
                this.myRemovedMappingTracker.add(matcher, fileTypeName, false);
            }
            this.myUnresolvedMappings.remove(matcher);
        }
    }

    @NotNull
    RemovedMappingTracker getRemovedMappingTracker() {
        RemovedMappingTracker removedMappingTracker = this.myRemovedMappingTracker;
        if (removedMappingTracker == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(111);
        }
        return removedMappingTracker;
    }

    void clearForTests() {
        for (StandardFileType fileType : this.myStandardFileTypes.values()) {
            this.myPatternsTable.removeAllAssociations((Object)fileType.fileType);
        }
        for (FileType type : this.myDefaultTypes) {
            this.myPatternsTable.removeAllAssociations((Object)type);
        }
        this.myStandardFileTypes.clear();
        this.myDefaultTypes.clear();
        this.myUnresolvedMappings.clear();
        this.myRemovedMappingTracker.clear();
        for (FileTypeBean bean : this.myPendingFileTypes.values()) {
            this.myPendingAssociations.removeAllAssociations((Object)bean);
        }
        this.myPendingFileTypes.clear();
        this.mySchemeManager.setSchemes(Collections.emptyList());
    }

    public void dispose() {
        LOG.info(String.format("%s auto-detected files. Detection took %s ms", this.counterAutoDetect, this.elapsedAutoDetect));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 42: 
            case 45: 
            case 49: 
            case 50: 
            case 54: 
            case 55: 
            case 61: 
            case 63: 
            case 64: 
            case 70: 
            case 72: 
            case 83: 
            case 87: 
            case 88: 
            case 93: 
            case 94: 
            case 98: 
            case 111: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 42: 
            case 45: 
            case 49: 
            case 50: 
            case 54: 
            case 55: 
            case 61: 
            case 63: 
            case 64: 
            case 70: 
            case 72: 
            case 83: 
            case 87: 
            case 88: 
            case 93: 
            case 94: 
            case 98: 
            case 111: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stdFileType";
                break;
            }
            case 1: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeBean";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 42: 
            case 45: 
            case 49: 
            case 50: 
            case 54: 
            case 55: 
            case 61: 
            case 63: 
            case 64: 
            case 70: 
            case 72: 
            case 83: 
            case 87: 
            case 88: 
            case 93: 
            case 94: 
            case 98: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changed";
                break;
            }
            case 10: 
            case 19: 
            case 21: 
            case 23: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 41: 
            case 43: 
            case 46: 
            case 68: 
            case 105: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 13: 
            case 67: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_NAME;
                break;
            }
            case 14: 
            case 16: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 36: 
            case 56: 
            case 59: 
            case 60: 
            case 89: 
            case 91: 
            case 96: 
            case 97: 
            case 101: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 37: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeName";
                break;
            }
            case 39: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detectors";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 57: 
            case 69: 
            case 71: 
            case 73: 
            case 75: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultAssociations";
                break;
            }
            case 65: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_LIST;
                break;
            }
            case 74: 
            case 76: 
            case 102: 
            case 104: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 77: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maskToRemove";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoreMask";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchers";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semicolonDelimited";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypes";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assocTable";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeOrInstantiateFileTypeBean";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpReDetectQueue";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getStdFileType";
                break;
            }
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByFileName";
                break;
            }
            case 22: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByFile";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrDetectFromContent";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "readableFlags";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "detectFromContentAndCache";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "detectFromContent";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "detect";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByExtension";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisteredFileTypes";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredFilesList";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociatedExtensions";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociations";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFileType";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionMap";
                break;
            }
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemovedMappingTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "unregisterMatchers";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fileTypeChanged";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "mergeOrInstantiateFileTypeBean";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 42: 
            case 45: 
            case 49: 
            case 50: 
            case 54: 
            case 55: 
            case 61: 
            case 63: 
            case 64: 
            case 70: 
            case 72: 
            case 83: 
            case 87: 
            case 88: 
            case 93: 
            case 94: 
            case 98: 
            case 111: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "instantiateFileTypeBean";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "reDetect";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "reparseLater";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "wasAutoDetectedBefore";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getStdFileType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "instantiatePendingFileTypeByName";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByFileName";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "freezeFileTypeTemporarilyIn";
                break;
            }
            case 21: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByFile";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getByFile";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getOrDetectFromContent";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "readFlagsFromCache";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "writeFlagsToCache";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "cacheAutoDetectedFileType";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findFileTypeByName";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isDetectable";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "readSafely";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "detectFromContentAndCache";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "detectFromContent";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "streamInfo";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "findFileTypeByLanguage";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByExtension";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "registerFileType";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "unregisterFileType";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "unregisterFileTypeWithoutNotification";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "setIgnoredFilesList";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredFilesListEqualToCurrent";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "isFileIgnored";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedExtensions";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getAssociations";
                break;
            }
            case 73: 
            case 74: 
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "associate";
                break;
            }
            case 75: 
            case 76: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "removeAssociation";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "addFileTypeListener";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "removeFileTypeListener";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "unignoreMask";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "readGlobalMappings";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "addIgnore";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "writeExtensionsMap";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByName";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "registerFileTypeWithoutNotification";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "bindUnresolvedMappings";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "loadFileType";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "filterAlreadyRegisteredExtensions";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "setFileTypeAttributes";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "shouldSave";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "setPatternsTable";
                break;
            }
            case 105: 
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "getKnownFileTypeOrAssociate";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "registerReDetectedMappings";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "registerReDetectedMapping";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 42: 
            case 45: 
            case 49: 
            case 50: 
            case 54: 
            case 55: 
            case 61: 
            case 63: 
            case 64: 
            case 70: 
            case 72: 
            case 83: 
            case 87: 
            case 88: 
            case 93: 
            case 94: 
            case 98: 
            case 111: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class StandardFileType {
        @NotNull
        private final FileType fileType;
        @NotNull
        private final List<FileNameMatcher> matchers;

        private StandardFileType(@NotNull FileType fileType, @NotNull List<FileNameMatcher> matchers) {
            if (fileType == null) {
                StandardFileType.$$$reportNull$$$0(0);
            }
            if (matchers == null) {
                StandardFileType.$$$reportNull$$$0(1);
            }
            this.fileType = fileType;
            this.matchers = matchers;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "matchers";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$StandardFileType";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

