/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.actions.persistence;

import com.intellij.facet.ui.FacetDependentToolWindow;
import com.intellij.ide.actions.ToolWindowMoveAction;
import com.intellij.ide.actions.ToolWindowViewModeAction;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomWhiteListRule;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowWhitelistEP;
import com.intellij.openapi.wm.ext.LibraryDependentToolWindow;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToolWindowCollector {
    private static final ToolWindowInfo UNKNOWN = new ToolWindowInfo("unknown", PluginInfoDetectorKt.getUnknownPlugin());
    public static final Map<String, ToolWindowInfo> ourToolwindowWhitelist = new HashMap<String, ToolWindowInfo>();

    public static ToolWindowCollector getInstance() {
        return (ToolWindowCollector)ServiceManager.getService(ToolWindowCollector.class);
    }

    private ToolWindowCollector() {
        for (ToolWindowWhitelistEP extension : ToolWindowWhitelistEP.EP_NAME.getExtensionList()) {
            ToolWindowCollector.addToolwindowToWhitelist(extension);
        }
        ToolWindowWhitelistEP.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<ToolWindowWhitelistEP>(){

            public void extensionAdded(@NotNull ToolWindowWhitelistEP extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                ToolWindowCollector.addToolwindowToWhitelist(extension);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "extension";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ToolWindowCollector$1";
                objectArray[2] = "extensionAdded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)ApplicationManager.getApplication());
    }

    private static void addToolwindowToWhitelist(ToolWindowWhitelistEP extension) {
        PluginInfo info;
        PluginDescriptor pluginDescriptor = extension == null ? null : extension.getPluginDescriptor();
        PluginInfo pluginInfo = info = pluginDescriptor != null ? PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)pluginDescriptor) : null;
        if (info != null && info.isDevelopedByJetBrains()) {
            ourToolwindowWhitelist.put(extension.id, new ToolWindowInfo(extension.id, info));
        }
    }

    public static void recordActivation(String toolWindowId, @Nullable WindowInfoImpl info) {
        ToolWindowCollector.record(toolWindowId, ToolWindowActivationSource.ACTIVATED, info);
    }

    public static void recordClick(String toolWindowId, @Nullable WindowInfoImpl info) {
        ToolWindowCollector.record(toolWindowId, ToolWindowActivationSource.CLICKED, info);
    }

    private static void record(@Nullable String toolWindowId, @NotNull ToolWindowActivationSource source, @Nullable WindowInfoImpl windowInfo) {
        if (source == null) {
            ToolWindowCollector.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmpty((String)toolWindowId)) {
            return;
        }
        ToolWindowInfo info = ToolWindowCollector.getToolWindowInfo(toolWindowId);
        FeatureUsageData data2 = new FeatureUsageData().addData("id", info.myRecordedId).addPluginInfo(info.myPluginInfo);
        if (windowInfo != null) {
            data2.addData("ViewMode", ToolWindowViewModeAction.ViewMode.fromWindowInfo(windowInfo).toString());
            data2.addData("Location", ToolWindowMoveAction.Anchor.fromWindowInfo(windowInfo).toString());
        }
        FUCounterUsageLogger.getInstance().logEvent("toolwindow", StringUtil.toLowerCase((String)source.name()), data2);
    }

    @NotNull
    private static ToolWindowInfo getToolWindowInfo(@NotNull String toolWindowId) {
        if (toolWindowId == null) {
            ToolWindowCollector.$$$reportNull$$$0(1);
        }
        if (ourToolwindowWhitelist.containsKey(toolWindowId)) {
            ToolWindowInfo toolWindowInfo = ourToolwindowWhitelist.get(toolWindowId);
            if (toolWindowInfo == null) {
                ToolWindowCollector.$$$reportNull$$$0(2);
            }
            return toolWindowInfo;
        }
        ToolWindowInfo info = ToolWindowCollector.getToolWindowInfo(toolWindowId, (ToolWindowEP[])ToolWindowEP.EP_NAME.getExtensions());
        if (info == null) {
            info = ToolWindowCollector.getToolWindowInfo(toolWindowId, (ToolWindowEP[])LibraryDependentToolWindow.EXTENSION_POINT_NAME.getExtensions());
        }
        if (info == null) {
            info = ToolWindowCollector.getToolWindowInfo(toolWindowId, (ToolWindowEP[])FacetDependentToolWindow.EXTENSION_POINT_NAME.getExtensions());
        }
        ToolWindowInfo toolWindowInfo = info != null ? info : UNKNOWN;
        if (toolWindowInfo == null) {
            ToolWindowCollector.$$$reportNull$$$0(3);
        }
        return toolWindowInfo;
    }

    @Nullable
    public static ToolWindowInfo getToolWindowInfo(@NotNull String toolWindowId, ToolWindowEP @NotNull [] toolWindows) {
        if (toolWindowId == null) {
            ToolWindowCollector.$$$reportNull$$$0(4);
        }
        if (toolWindows == null) {
            ToolWindowCollector.$$$reportNull$$$0(5);
        }
        for (ToolWindowEP ep : toolWindows) {
            if (!StringUtil.equals((CharSequence)toolWindowId, (CharSequence)ep.id)) continue;
            PluginDescriptor pluginDescriptor = ep.getPluginDescriptor();
            return new ToolWindowInfo(ep.id, PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)pluginDescriptor));
        }
        return null;
    }

    static {
        ourToolwindowWhitelist.put("Commander", new ToolWindowInfo("Commander"));
        ourToolwindowWhitelist.put("Messages", new ToolWindowInfo("Messages"));
        ourToolwindowWhitelist.put("Project", new ToolWindowInfo("Project"));
        ourToolwindowWhitelist.put("Structure", new ToolWindowInfo("Structure"));
        ourToolwindowWhitelist.put("Favorites", new ToolWindowInfo("Favorites"));
        ourToolwindowWhitelist.put("Ant", new ToolWindowInfo("Ant"));
        ourToolwindowWhitelist.put("Debug", new ToolWindowInfo("Debug"));
        ourToolwindowWhitelist.put("Run", new ToolWindowInfo("Run"));
        ourToolwindowWhitelist.put("Build", new ToolWindowInfo("Build"));
        ourToolwindowWhitelist.put("Find", new ToolWindowInfo("Find"));
        ourToolwindowWhitelist.put("CVS", new ToolWindowInfo("CVS"));
        ourToolwindowWhitelist.put("Hierarchy", new ToolWindowInfo("Hierarchy"));
        ourToolwindowWhitelist.put("Inspection Results", new ToolWindowInfo("Inspection_Results"));
        ourToolwindowWhitelist.put("TODO", new ToolWindowInfo("TODO"));
        ourToolwindowWhitelist.put("Dependency Viewer", new ToolWindowInfo("Dependency_Viewer"));
        ourToolwindowWhitelist.put("Version Control", new ToolWindowInfo("Version_Control"));
        ourToolwindowWhitelist.put("Module Dependencies", new ToolWindowInfo("Module_Dependencies"));
        ourToolwindowWhitelist.put("Duplicates", new ToolWindowInfo("Duplicates"));
        ourToolwindowWhitelist.put("Extract Method", new ToolWindowInfo("Extract_Method"));
        ourToolwindowWhitelist.put("Documentation", new ToolWindowInfo("Documentation"));
        ourToolwindowWhitelist.put("Time Tracking", new ToolWindowInfo("Time_Tracking"));
        ourToolwindowWhitelist.put("Database", new ToolWindowInfo("Database"));
        ourToolwindowWhitelist.put("Preview", new ToolWindowInfo("Preview"));
        ourToolwindowWhitelist.put("Run Dashboard", new ToolWindowInfo("Run_Dashboard"));
        ourToolwindowWhitelist.put("Services", new ToolWindowInfo("Services"));
        ourToolwindowWhitelist.put("Statistics Event Log", new ToolWindowInfo("Statistics_Event_Log"));
        ourToolwindowWhitelist.put("Endpoints", new ToolWindowInfo("Endpoints"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowId";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ToolWindowCollector";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindows";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ToolWindowCollector";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "record";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindowInfo";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ToolWindowInfo {
        private final String myRecordedId;
        private final PluginInfo myPluginInfo;

        private ToolWindowInfo(@NotNull String recordedId) {
            if (recordedId == null) {
                ToolWindowInfo.$$$reportNull$$$0(0);
            }
            this(recordedId, PluginInfoDetectorKt.getPlatformPlugin());
        }

        private ToolWindowInfo(@NotNull String recordedId, @NotNull PluginInfo info) {
            if (recordedId == null) {
                ToolWindowInfo.$$$reportNull$$$0(1);
            }
            if (info == null) {
                ToolWindowInfo.$$$reportNull$$$0(2);
            }
            this.myRecordedId = recordedId;
            this.myPluginInfo = info;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "recordedId";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "info";
                    break;
                }
            }
            objectArray[1] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ToolWindowCollector$ToolWindowInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ToolWindowUtilValidator
    extends CustomWhiteListRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "toolwindow".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            if (data2 == null) {
                ToolWindowUtilValidator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                ToolWindowUtilValidator.$$$reportNull$$$0(1);
            }
            if ("unknown".equals(data2)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    ToolWindowUtilValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            ValidationResultType validationResultType = ToolWindowUtilValidator.acceptWhenReportedByJetBrainsPlugin((EventContext)context);
            if (validationResultType == null) {
                ToolWindowUtilValidator.$$$reportNull$$$0(3);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ToolWindowCollector$ToolWindowUtilValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ToolWindowCollector$ToolWindowUtilValidator";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static enum ToolWindowActivationSource {
        ACTIVATED,
        CLICKED;

    }
}

