/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.ide.util.scopeChooser.EditScopesDialog;
import com.intellij.ide.util.scopeChooser.ScopeEditorPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.scope.ProblemsScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.editors.JBComboBoxTableCellEditorComponent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class PackageSetChooserCombo
extends ComponentWithBrowseButton<JComponent> {
    private static final Logger LOG = Logger.getInstance(PackageSetChooserCombo.class);
    private final Project myProject;

    public PackageSetChooserCombo(Project project, String preselect) {
        this(project, preselect, true, true);
    }

    public PackageSetChooserCombo(Project project, @Nullable String preselect, boolean enableBrowseButton, boolean useCombo) {
        super(useCombo ? new JComboBox() : new JBComboBoxTableCellEditorComponent(), null);
        this.myProject = project;
        final JComponent component2 = this.getChildComponent();
        if (component2 instanceof JComboBox) {
            component2.setBorder(null);
        }
        if (enableBrowseButton) {
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NamedScope scope = component2 instanceof JComboBox ? (NamedScope)((JComboBox)component2).getSelectedItem() : (NamedScope)((JBComboBoxTableCellEditorComponent)component2).getEditorValue();
                    if (scope instanceof NamedScope.UnnamedScope) {
                        Map unnamedScopes = DependencyValidationManager.getInstance((Project)PackageSetChooserCombo.this.myProject).getUnnamedScopes();
                        EditUnnamedScopesDialog dlg = new EditUnnamedScopesDialog(scope);
                        if (dlg.showAndGet()) {
                            PackageSet packageSet = scope.getValue();
                            LOG.assertTrue(packageSet != null);
                            unnamedScopes.remove(packageSet.getText());
                            PackageSet editedScope = dlg.getScope();
                            if (editedScope != null) {
                                unnamedScopes.put(editedScope.getText(), editedScope);
                            }
                            PackageSetChooserCombo.this.rebuild();
                            if (editedScope != null) {
                                PackageSetChooserCombo.this.selectScope(editedScope.getText());
                            }
                        }
                    } else {
                        EditScopesDialog dlg = EditScopesDialog.showDialog(PackageSetChooserCombo.this.myProject, scope.getName(), true);
                        if (dlg.isOK()) {
                            PackageSetChooserCombo.this.rebuild();
                            NamedScope namedScope = dlg.getSelectedScope();
                            if (namedScope != null) {
                                PackageSetChooserCombo.this.selectScope(namedScope.getName());
                            }
                        }
                    }
                }
            });
        } else {
            this.getButton().setVisible(false);
        }
        if (component2 instanceof JComboBox) {
            ((JComboBox)component2).setRenderer(SimpleListCellRenderer.create((String)"", NamedScope::getName));
        } else {
            ((JBComboBoxTableCellEditorComponent)component2).setToString(o -> o == null ? "" : ((NamedScope)o).getName());
        }
        this.rebuild();
        this.selectScope(preselect);
    }

    private void selectScope(String preselect) {
        block4: {
            JComponent component2 = this.getChildComponent();
            if (preselect == null) break block4;
            if (component2 instanceof JComboBox) {
                DefaultComboBoxModel model = (DefaultComboBoxModel)((JComboBox)component2).getModel();
                for (int i = 0; i < model.getSize(); ++i) {
                    NamedScope descriptor2 = (NamedScope)model.getElementAt(i);
                    if (!preselect.equals(descriptor2.getName())) continue;
                    ((JComboBox)component2).setSelectedIndex(i);
                    break;
                }
            } else {
                Object[] options;
                for (Object option2 : options = ((JBComboBoxTableCellEditorComponent)component2).getOptions()) {
                    NamedScope descriptor3 = (NamedScope)option2;
                    if (!preselect.equals(descriptor3.getName())) continue;
                    ((JBComboBoxTableCellEditorComponent)component2).setDefaultValue((Object)descriptor3);
                    break;
                }
            }
        }
    }

    private void rebuild() {
        JComponent component2 = this.getChildComponent();
        NamedScope[] model = this.createModel();
        if (component2 instanceof JComboBox) {
            ((JComboBox)component2).setModel(new DefaultComboBoxModel<NamedScope>(model));
        } else {
            ((JBComboBoxTableCellEditorComponent)component2).setOptions((Object[])model);
        }
    }

    protected NamedScope[] createModel() {
        DependencyValidationManager manager = DependencyValidationManager.getInstance((Project)this.myProject);
        ArrayList<NamedScope> model = new ArrayList<NamedScope>(Arrays.asList(manager.getScopes()));
        for (PackageSet unnamedScope : manager.getUnnamedScopes().values()) {
            model.add((NamedScope)new NamedScope.UnnamedScope(unnamedScope));
        }
        model.remove(ProblemsScope.INSTANCE);
        return model.toArray(NamedScope.EMPTY_ARRAY);
    }

    @Nullable
    public NamedScope getSelectedScope() {
        JComponent component2 = this.getChildComponent();
        if (component2 instanceof JComboBox) {
            int idx = ((JComboBox)component2).getSelectedIndex();
            if (idx < 0) {
                return null;
            }
            return (NamedScope)((JComboBox)component2).getSelectedItem();
        }
        return (NamedScope)((JBComboBoxTableCellEditorComponent)component2).getEditorValue();
    }

    private class EditUnnamedScopesDialog
    extends DialogWrapper {
        private PackageSet myScope;
        private final ScopeEditorPanel myPanel;

        EditUnnamedScopesDialog(NamedScope scope) {
            super((Component)((Object)PackageSetChooserCombo.this), false);
            this.myScope = scope.getValue();
            this.myPanel = new ScopeEditorPanel(PackageSetChooserCombo.this.myProject, (NamedScopesHolder)DependencyValidationManager.getInstance((Project)PackageSetChooserCombo.this.myProject));
            this.init();
            this.myPanel.reset(this.myScope, null);
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myPanel.getPanel();
        }

        protected void doOKAction() {
            this.myScope = this.myPanel.getCurrentScope();
            super.doOKAction();
        }

        public PackageSet getScope() {
            return this.myScope;
        }
    }
}

