/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class ProjectViewUnloadedModuleNode
extends ProjectViewNode<UnloadedModuleDescription> {
    public ProjectViewUnloadedModuleNode(Project project, @NotNull UnloadedModuleDescription value2, ViewSettings viewSettings) {
        if (value2 == null) {
            ProjectViewUnloadedModuleNode.$$$reportNull$$$0(0);
        }
        super(project, (Object)value2, viewSettings);
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        UnloadedModuleDescription module = (UnloadedModuleDescription)this.getValue();
        if (module == null) {
            List<AbstractTreeNode<?>> list2 = Collections.emptyList();
            if (list2 == null) {
                ProjectViewUnloadedModuleNode.$$$reportNull$$$0(1);
            }
            return list2;
        }
        List<VirtualFile> contentRoots2 = ProjectViewDirectoryHelper.getInstance(this.myProject).getTopLevelUnloadedModuleRoots(module, this.getSettings());
        Collection<AbstractTreeNode<?>> collection = ProjectViewDirectoryHelper.getInstance(this.myProject).createFileAndDirectoryNodes(contentRoots2, this.getSettings());
        if (collection == null) {
            ProjectViewUnloadedModuleNode.$$$reportNull$$$0(2);
        }
        return collection;
    }

    public int getWeight() {
        return 10;
    }

    public int getTypeSortWeight(boolean sortByType) {
        return 2;
    }

    public void update(@NotNull PresentationData presentation) {
        UnloadedModuleDescription module;
        if (presentation == null) {
            ProjectViewUnloadedModuleNode.$$$reportNull$$$0(3);
        }
        if ((module = (UnloadedModuleDescription)this.getValue()) == null) {
            this.setValue(null);
            return;
        }
        presentation.setPresentableText(module.getName());
        presentation.addText(module.getName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        presentation.setIcon(AllIcons.Modules.UnloadedModule);
        presentation.setTooltip("Unloaded module");
    }

    @NotNull
    public Collection<VirtualFile> getRoots() {
        UnloadedModuleDescription module = (UnloadedModuleDescription)this.getValue();
        Collection<Object> collection = module != null ? (Collection)module.getContentRoots().stream().map(VirtualFilePointer::getFile).filter(Objects::nonNull).collect(Collectors.toList()) : Collections.emptyList();
        if (collection == null) {
            ProjectViewUnloadedModuleNode.$$$reportNull$$$0(4);
        }
        return collection;
    }

    public boolean contains(@NotNull VirtualFile file2) {
        UnloadedModuleDescription module;
        if (file2 == null) {
            ProjectViewUnloadedModuleNode.$$$reportNull$$$0(5);
        }
        return (module = (UnloadedModuleDescription)this.getValue()) != null && module.getContentRoots().stream().map(VirtualFilePointer::getFile).anyMatch(root -> root != null && VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file2, (boolean)false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/nodes/ProjectViewUnloadedModuleNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/nodes/ProjectViewUnloadedModuleNode";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

