/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.macro;

import com.intellij.execution.ExecutionBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.macro.ContentRootMacro;
import com.intellij.ide.macro.FilePromptMacro;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroFilter;
import com.intellij.ide.macro.MacroManager;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MacrosDialog
extends DialogWrapper {
    private final DefaultListModel<Item> myMacrosModel;
    private final JBList<Item> myMacrosList;
    private final JTextArea myPreviewTextarea;

    public MacrosDialog(Project project) {
        super(project, true);
        this.myMacrosModel = new DefaultListModel();
        this.myMacrosList = new JBList(this.myMacrosModel);
        this.myPreviewTextarea = new JTextArea();
        MacroManager.getInstance().cacheMacrosPreview(SimpleDataContext.getProjectContext(project));
        this.init();
    }

    public MacrosDialog(@NotNull Component parent, @NotNull Predicate<? super Macro> filter2, @Nullable Map<String, String> userMacros) {
        if (parent == null) {
            MacrosDialog.$$$reportNull$$$0(0);
        }
        if (filter2 == null) {
            MacrosDialog.$$$reportNull$$$0(1);
        }
        super(parent, true);
        this.myMacrosModel = new DefaultListModel();
        this.myMacrosList = new JBList(this.myMacrosModel);
        this.myPreviewTextarea = new JTextArea();
        MacroManager.getInstance().cacheMacrosPreview(DataManager.getInstance().getDataContext(parent));
        this.init(filter2, userMacros);
    }

    public static void addTextFieldExtension(@NotNull ExtendableTextField textField2) {
        if (textField2 == null) {
            MacrosDialog.$$$reportNull$$$0(2);
        }
        MacrosDialog.addTextFieldExtension(textField2, Filters.ALL, null);
    }

    public static void addTextFieldExtension(@NotNull ExtendableTextField textField2, @NotNull Predicate<? super Macro> macroFilter, @Nullable Map<String, String> userMacros) {
        if (textField2 == null) {
            MacrosDialog.$$$reportNull$$$0(3);
        }
        if (macroFilter == null) {
            MacrosDialog.$$$reportNull$$$0(4);
        }
        textField2.addExtension(ExtendableTextComponent.Extension.create((Icon)AllIcons.General.InlineAdd, (Icon)AllIcons.General.InlineAddHover, (String)ExecutionBundle.message((String)"insert.macros", (Object[])new Object[0]), () -> MacrosDialog.show((JTextComponent)textField2, macroFilter, userMacros)));
    }

    public static void show(@NotNull JTextComponent textComponent) {
        if (textComponent == null) {
            MacrosDialog.$$$reportNull$$$0(5);
        }
        MacrosDialog.show(textComponent, Filters.ALL, null);
    }

    public static void show(@NotNull JTextComponent textComponent, @NotNull Predicate<? super Macro> filter2, @Nullable Map<String, String> userMacros) {
        String macro;
        MacrosDialog dialog2;
        if (textComponent == null) {
            MacrosDialog.$$$reportNull$$$0(6);
        }
        if (filter2 == null) {
            MacrosDialog.$$$reportNull$$$0(7);
        }
        if ((dialog2 = new MacrosDialog(textComponent, filter2, userMacros)).showAndGet() && (macro = dialog2.getSelectedMacroName()) != null) {
            int position = textComponent.getCaretPosition();
            int selectionStart = textComponent.getSelectionStart();
            int selectionEnd = textComponent.getSelectionEnd();
            try {
                if (selectionStart < selectionEnd) {
                    textComponent.getDocument().remove(selectionStart, selectionEnd - selectionStart);
                    position = selectionStart;
                }
                String nameToInsert = macro.startsWith("$") || macro.startsWith("%") ? macro : "$" + macro + "$";
                textComponent.getDocument().insertString(position, nameToInsert, null);
                textComponent.setCaretPosition(position + nameToInsert.length());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        IdeFocusManager.findInstance().requestFocus((Component)textComponent, true);
    }

    protected void init() {
        throw new UnsupportedOperationException("Call init(...) overload accepting parameters");
    }

    private void init(@NotNull Predicate<? super Macro> filter2, @Nullable Map<String, String> userMacros) {
        if (filter2 == null) {
            MacrosDialog.$$$reportNull$$$0(8);
        }
        super.init();
        this.setTitle(IdeBundle.message((String)"title.macros", (Object[])new Object[0]));
        this.setOKButtonText(IdeBundle.message((String)"button.insert", (Object[])new Object[0]));
        List macros = ContainerUtil.filter(MacroManager.getInstance().getMacros(), macro -> MacroFilter.GLOBAL.accept((Macro)macro) && filter2.test((Macro)macro));
        Collections.sort(macros, new Comparator<Macro>(){
            private final String ZERO = new String(new char[]{'\u0000'});

            @Override
            public int compare(Macro macro1, Macro macro2) {
                String name1 = macro1.getName();
                String name2 = macro2.getName();
                if (!StringUtil.startsWithChar((CharSequence)name1, (char)'/')) {
                    name1 = this.ZERO + name1;
                }
                if (!StringUtil.startsWithChar((CharSequence)name2, (char)'/')) {
                    name2 = this.ZERO + name2;
                }
                return name1.compareToIgnoreCase(name2);
            }
        });
        if (userMacros != null && !userMacros.isEmpty()) {
            for (Map.Entry<String, String> entry : userMacros.entrySet()) {
                this.myMacrosModel.addElement(new EntryWrapper(entry));
            }
        }
        MacroWrapper firstMacro = null;
        for (Macro macro3 : macros) {
            MacroWrapper element2 = new MacroWrapper(macro3);
            if (firstMacro == null) {
                firstMacro = element2;
            }
            this.myMacrosModel.addElement(element2);
        }
        final MacroWrapper macroWrapper = firstMacro;
        this.myMacrosList.setCellRenderer(new GroupedItemsListRenderer(new ListItemDescriptorAdapter<Item>(){

            public String getTextFor(Item value2) {
                return value2.toString();
            }

            public boolean hasSeparatorAboveOf(Item value2) {
                return value2 == macroWrapper;
            }
        }));
        this.addListeners();
        if (this.myMacrosModel.size() > 0) {
            this.myMacrosList.setSelectedIndex(0);
        } else {
            this.setOKActionEnabled(false);
        }
    }

    protected String getHelpId() {
        return "reference.settings.ide.settings.external.tools.macros";
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.ide.macro.MacrosDialog";
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridy = 0;
        constr.anchor = 17;
        constr.fill = 2;
        panel2.add((Component)SeparatorFactory.createSeparator((String)IdeBundle.message((String)"label.macros", (Object[])new Object[0]), null), constr);
        constr = new GridBagConstraints();
        constr.gridy = 1;
        constr.weightx = 1.0;
        constr.weighty = 1.0;
        constr.fill = 1;
        constr.anchor = 17;
        panel2.add((Component)ScrollPaneFactory.createScrollPane(this.myMacrosList), constr);
        this.myMacrosList.setSelectionMode(0);
        this.myMacrosList.setPreferredSize(null);
        constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 2;
        constr.anchor = 17;
        constr.fill = 2;
        panel2.add((Component)SeparatorFactory.createSeparator((String)IdeBundle.message((String)"label.macro.preview", (Object[])new Object[0]), null), constr);
        constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 3;
        constr.weightx = 1.0;
        constr.weighty = 1.0;
        constr.fill = 1;
        constr.anchor = 17;
        panel2.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myPreviewTextarea), constr);
        this.myPreviewTextarea.setEditable(false);
        this.myPreviewTextarea.setLineWrap(true);
        this.myPreviewTextarea.setPreferredSize(null);
        panel2.setPreferredSize((Dimension)JBUI.size((int)400, (int)500));
        return panel2;
    }

    private void addListeners() {
        this.myMacrosList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Item item = (Item)MacrosDialog.this.myMacrosList.getSelectedValue();
                if (item == null) {
                    MacrosDialog.this.myPreviewTextarea.setText("");
                    MacrosDialog.this.setOKActionEnabled(false);
                } else {
                    MacrosDialog.this.myPreviewTextarea.setText(item.getPreview());
                    MacrosDialog.this.setOKActionEnabled(true);
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                if (MacrosDialog.this.getSelectedMacroName() != null) {
                    MacrosDialog.this.close(0);
                    return true;
                }
                return false;
            }
        }.installOn(this.myMacrosList);
    }

    @Deprecated
    public Macro getSelectedMacro() {
        Item item = (Item)this.myMacrosList.getSelectedValue();
        if (item instanceof MacroWrapper) {
            return ((MacroWrapper)item).myMacro;
        }
        return null;
    }

    @Nullable
    public String getSelectedMacroName() {
        Item item = (Item)this.myMacrosList.getSelectedValue();
        if (item == null) {
            return null;
        }
        return item.getName();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myMacrosList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macroFilter";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textComponent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/macro/MacrosDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addTextFieldExtension";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "show";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Filters {
        private static final Pattern CAMEL_HUMP_START_PATTERN = Pattern.compile("(?<=[\\p{Lower}\\p{Digit}])(?![\\p{Lower}\\p{Digit}])");
        @NotNull
        public static final Predicate<? super Macro> ALL = m -> true;
        @NotNull
        public static final Predicate<? super Macro> NONE = m -> false;
        @NotNull
        public static final Predicate<? super Macro> ANY_PATH = m -> Filters.nameContains(m, "File") || Filters.nameContains(m, "Dir") || m instanceof ContentRootMacro || m instanceof FilePromptMacro;
        @NotNull
        public static final Predicate<? super Macro> DIRECTORY_PATH = m -> Filters.nameContains(m, "Dir") || m instanceof ContentRootMacro || m instanceof FilePromptMacro;
        @NotNull
        public static final Predicate<? super Macro> FILE_PATH = m -> Filters.nameContains(m, "File") && !Filters.nameContains(m, "Dir") || m instanceof FilePromptMacro;

        private Filters() {
        }

        private static boolean nameContains(@NotNull Macro m, @NotNull String part) {
            if (m == null) {
                Filters.$$$reportNull$$$0(0);
            }
            if (part == null) {
                Filters.$$$reportNull$$$0(1);
            }
            String[] nameParts = CAMEL_HUMP_START_PATTERN.split(m.getName());
            return ArrayUtil.contains((String)part, (String[])nameParts);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "m";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "part";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/macro/MacrosDialog$Filters";
            objectArray[2] = "nameContains";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class EntryWrapper
    implements Item {
        private final Map.Entry<String, String> myEntry;

        EntryWrapper(Map.Entry<String, String> entry) {
            this.myEntry = entry;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myEntry.getKey();
            if (string == null) {
                EntryWrapper.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getPreview() {
            String string = StringUtil.notNullize((String)this.myEntry.getValue(), (String)("$" + this.getName() + "$"));
            if (string == null) {
                EntryWrapper.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String toString() {
            String string = this.myEntry.getKey();
            if (string == null) {
                EntryWrapper.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/ide/macro/MacrosDialog$EntryWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreview";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static final class MacroWrapper
    implements Item {
        private final Macro myMacro;

        MacroWrapper(Macro macro) {
            this.myMacro = macro;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myMacro.getName();
            if (string == null) {
                MacroWrapper.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getPreview() {
            String string = StringUtil.notNullize((String)this.myMacro.preview());
            if (string == null) {
                MacroWrapper.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String toString() {
            String string = this.myMacro.getName() + " - " + this.myMacro.getDescription();
            if (string == null) {
                MacroWrapper.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/ide/macro/MacrosDialog$MacroWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreview";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static interface Item {
        @NotNull
        public String getName();

        @NotNull
        public String getPreview();

        @NotNull
        public String toString();
    }
}

