/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.impl;

import com.intellij.execution.ui.layout.CellTransform;
import com.intellij.execution.ui.layout.Grid;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.Tab;
import com.intellij.execution.ui.layout.View;
import com.intellij.execution.ui.layout.ViewContext;
import com.intellij.execution.ui.layout.impl.GridCellImpl;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.execution.ui.layout.impl.TabImpl;
import com.intellij.execution.ui.layout.impl.ViewContextEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.ui.NullableComponent;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.content.Content;
import com.intellij.ui.tabs.JBTabsPresentation;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.LayoutFocusTraversalPolicy;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridImpl
extends Wrapper
implements Grid,
Disposable,
DataProvider {
    private final ThreeComponentsSplitter myTopSplit = new ThreeComponentsSplitter(false, true, (Disposable)this);
    private final Splitter mySplitter = new Splitter(true);
    private final Map<PlaceInGrid, GridCellImpl> myPlaceInGrid2Cell = new EnumMap<PlaceInGrid, GridCellImpl>(PlaceInGrid.class);
    private final List<Content> myContents = new ArrayList<Content>();
    private final Map<Content, GridCellImpl> myContent2Cell = new HashMap<Content, GridCellImpl>();
    private final Comparator<Content> myContentComparator = Comparator.comparing(o -> this.getCellFor((Content)o).getPlaceInGrid());
    private final ViewContextEx myViewContext;

    public GridImpl(ViewContextEx viewContext, String sessionName) {
        this.myViewContext = viewContext;
        Disposer.register((Disposable)this.myViewContext, (Disposable)this);
        Placeholder left = new Placeholder();
        this.myPlaceInGrid2Cell.put(PlaceInGrid.left, new GridCellImpl(this.myViewContext, this, left, PlaceInGrid.left));
        Placeholder center = new Placeholder();
        this.myPlaceInGrid2Cell.put(PlaceInGrid.center, new GridCellImpl(this.myViewContext, this, center, PlaceInGrid.center));
        Placeholder right = new Placeholder();
        this.myPlaceInGrid2Cell.put(PlaceInGrid.right, new GridCellImpl(this.myViewContext, this, right, PlaceInGrid.right));
        Placeholder bottom = new Placeholder();
        this.myPlaceInGrid2Cell.put(PlaceInGrid.bottom, new GridCellImpl(this.myViewContext, this, bottom, PlaceInGrid.bottom));
        this.setContent((JComponent)this.mySplitter);
        this.setOpaque(false);
        this.setFocusCycleRoot(!ScreenReader.isActive());
        this.myTopSplit.setFirstComponent((JComponent)((Object)left));
        this.myTopSplit.setInnerComponent((JComponent)((Object)center));
        this.myTopSplit.setLastComponent((JComponent)((Object)right));
        this.myTopSplit.setMinSize(48);
        this.mySplitter.setFirstComponent((JComponent)this.myTopSplit);
        this.mySplitter.setSecondComponent((JComponent)((Object)bottom));
    }

    public void addNotify() {
        super.addNotify();
        this.processAddToUi(true);
    }

    public void removeNotify() {
        super.removeNotify();
        this.processRemoveFromUi();
    }

    public void processAddToUi(boolean restoreProportions) {
        if (restoreProportions) {
            for (GridCellImpl cell : this.myPlaceInGrid2Cell.values()) {
                cell.restoreProportions();
            }
        }
        this.updateSelection(true);
    }

    public void processRemoveFromUi() {
        if (Disposer.isDisposed((Disposable)this)) {
            return;
        }
        this.updateSelection(false);
    }

    private void updateSelection(boolean isShowing) {
        for (GridCellImpl each : this.myPlaceInGrid2Cell.values()) {
            each.updateSelection(isShowing);
        }
    }

    void add(Content content2) {
        GridCellImpl cell = this.getCellFor(content2);
        cell.add(content2);
        this.myContents.add(content2);
        this.myContent2Cell.put(content2, cell);
        Collections.sort(this.myContents, this.myContentComparator);
    }

    void remove(Content content2) {
        this.getCellFor(content2).remove(content2);
        this.myContents.remove(content2);
        this.myContent2Cell.remove(content2);
    }

    public void setToolbarHorizontal(boolean horizontal) {
        for (GridCellImpl cell : this.myPlaceInGrid2Cell.values()) {
            cell.setToolbarHorizontal(horizontal);
        }
    }

    public void setToolbarBefore(boolean before) {
        for (GridCellImpl cell : this.myPlaceInGrid2Cell.values()) {
            cell.setToolbarBefore(before);
        }
    }

    public GridCellImpl getCellFor(Content content2) {
        GridCellImpl current2 = this.myContent2Cell.get(content2);
        if (current2 != null) {
            return current2;
        }
        View view = this.getStateFor(content2);
        GridCellImpl cell = this.myPlaceInGrid2Cell.get(view.getPlaceInGrid());
        assert (cell != null) : "Unknown place in grid: " + view.getPlaceInGrid().name();
        return cell;
    }

    View getStateFor(Content content2) {
        return this.myViewContext.getStateFor(content2);
    }

    public boolean updateGridUI() {
        for (GridCellImpl cell : this.myPlaceInGrid2Cell.values()) {
            cell.setHideTabs(this.myContents.size() == 1);
        }
        Content onlyContent = this.myContents.get(0);
        return onlyContent.getSearchComponent() != null;
    }

    public boolean isEmpty() {
        return this.myContent2Cell.isEmpty();
    }

    public ActionCallback restoreLastUiState() {
        ActionCallback result2 = new ActionCallback(this.myPlaceInGrid2Cell.values().size());
        for (GridCellImpl cell : this.myPlaceInGrid2Cell.values()) {
            cell.restoreLastUiState().notifyWhenDone(result2);
        }
        return result2;
    }

    public void saveUiState() {
        for (GridCellImpl cell : this.myPlaceInGrid2Cell.values()) {
            cell.saveUiState();
        }
    }

    @Nullable
    public Tab getTabIndex() {
        return this.getTab();
    }

    public ActionCallback select(Content content2, boolean requestFocus) {
        return this.getCellFor(content2).select(content2, requestFocus);
    }

    public void processAlert(Content content2, boolean activate2) {
        GridCellImpl cell = this.getCellFor(content2);
        cell.processAlert(content2, activate2);
    }

    @Nullable
    public GridCellImpl findCell(Content content2) {
        return this.myContent2Cell.get(content2);
    }

    public void rebuildTabPopup() {
        List<Content> contents = this.getContents();
        for (Content each : contents) {
            GridCellImpl cell = this.findCell(each);
            if (cell == null) continue;
            cell.rebuildPopupGroup();
        }
    }

    public boolean isMinimized(Content content2) {
        return this.getCellFor(content2).isMinimized(content2);
    }

    public void dispose() {
    }

    void saveSplitterProportions(PlaceInGrid placeInGrid) {
        if (this.getRootPane() == null) {
            return;
        }
        Rectangle bounds2 = this.getBounds();
        if (bounds2.width == 0 && bounds2.height == 0) {
            return;
        }
        GridCellImpl cell = this.myPlaceInGrid2Cell.get(placeInGrid);
        if (!cell.isValidForCalculateProportions()) {
            return;
        }
        TabImpl tab = (TabImpl)this.getTab();
        if (tab != null) {
            switch (placeInGrid) {
                case left: {
                    tab.setLeftProportion(this.getLeftProportion());
                    break;
                }
                case right: {
                    tab.setRightProportion(this.getRightProportion());
                    break;
                }
                case bottom: {
                    tab.setBottomProportion(this.getBottomPropertion());
                }
            }
        }
    }

    @Nullable
    public Tab getTab() {
        return this.myViewContext.getTabFor(this);
    }

    void restoreLastSplitterProportions(PlaceInGrid placeInGrid) {
        if (this.getRootPane() == null) {
            return;
        }
        if (!RunnerContentUi.ensureValid((JComponent)((Object)this))) {
            return;
        }
        TabImpl tab = (TabImpl)this.getTab();
        if (tab != null) {
            switch (placeInGrid) {
                case left: {
                    this.setLeftProportion(tab.getLeftProportion());
                    break;
                }
                case right: {
                    this.setRightProportion(tab.getRightProportion());
                    break;
                }
                case bottom: {
                    this.mySplitter.setProportion(tab.getBottomProportion());
                    break;
                }
            }
        }
    }

    float getLeftProportion() {
        float totalSize = this.myTopSplit.getOrientation() ? (float)this.myTopSplit.getHeight() : (float)this.myTopSplit.getWidth();
        float componentSize = this.myTopSplit.getFirstSize();
        return componentSize / (totalSize - 2.0f * (float)this.myTopSplit.getDividerWidth());
    }

    void setLeftProportion(float proportion) {
        int totalSize = this.myTopSplit.getOrientation() ? this.myTopSplit.getHeight() : this.myTopSplit.getWidth();
        this.myTopSplit.setFirstSize((int)(proportion * (float)(totalSize - 2 * this.myTopSplit.getDividerWidth())));
    }

    float getRightProportion() {
        float totalSize = this.myTopSplit.getOrientation() ? (float)this.myTopSplit.getHeight() : (float)this.myTopSplit.getWidth();
        float componentSize = this.myTopSplit.getLastSize();
        return componentSize / (totalSize - 2.0f * (float)this.myTopSplit.getDividerWidth());
    }

    float getBottomPropertion() {
        float totalSize = this.mySplitter.getOrientation() ? (float)this.mySplitter.getHeight() : (float)this.mySplitter.getWidth();
        float componentSize = this.mySplitter.getOrientation() ? (float)this.mySplitter.getFirstComponent().getHeight() : (float)this.mySplitter.getFirstComponent().getWidth();
        return componentSize / (totalSize - (float)this.mySplitter.getDividerWidth());
    }

    void setRightProportion(float proportion) {
        int componentSize = this.myTopSplit.getOrientation() ? this.myTopSplit.getHeight() : this.myTopSplit.getWidth();
        this.myTopSplit.setLastSize((int)(proportion * (float)(componentSize - 2 * this.myTopSplit.getDividerWidth())));
    }

    public List<Content> getAttachedContents() {
        return new ArrayList<Content>(this.getContents());
    }

    public List<Content> getContents() {
        return this.myContents;
    }

    public void minimize(Content content2, final CellTransform.Restore restore) {
        this.myViewContext.getCellTransform().minimize(content2, new CellTransform.Restore(){

            public ActionCallback restoreInGrid() {
                return restore.restoreInGrid();
            }
        });
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            GridImpl.$$$reportNull$$$0(0);
        }
        if (ViewContext.CONTEXT_KEY.is(dataId)) {
            return this.myViewContext;
        }
        if (ViewContext.CONTENT_KEY.is(dataId)) {
            List<Content> contents = this.getContents();
            return contents.toArray(new Content[0]);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/execution/ui/layout/impl/GridImpl", "getData"));
    }

    static class Placeholder
    extends Wrapper
    implements NullableComponent {
        private ContentProvider myContentProvider;
        private JComponent myComponent;

        Placeholder() {
            this.setFocusTraversalPolicyProvider(true);
            this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

                @Override
                public Component getDefaultComponent(Container aContainer) {
                    Component content2 = this.getContent(true);
                    if (content2 != null) {
                        return content2;
                    }
                    return super.getDefaultComponent(aContainer);
                }

                @Override
                public Component getLastComponent(Container aContainer) {
                    Component content2 = this.getContent(false);
                    if (content2 != null) {
                        return content2;
                    }
                    return super.getLastComponent(aContainer);
                }

                private Component getContent(boolean first) {
                    JComponent preferred;
                    Content[] contents;
                    if (myContentProvider != null && (contents = myContentProvider.getContents()) != null && contents.length > 0 && (preferred = contents[first ? 0 : contents.length - 1].getPreferredFocusableComponent()) != null && this.accept(preferred)) {
                        return preferred;
                    }
                    return null;
                }
            });
        }

        void setContentProvider(@NotNull ContentProvider provider) {
            if (provider == null) {
                Placeholder.$$$reportNull$$$0(0);
            }
            this.myContentProvider = provider;
        }

        public CellTransform.Restore detach() {
            if (this.getComponentCount() == 1) {
                this.myComponent = (JComponent)this.getComponent(0);
                this.removeAll();
            }
            if (this.getParent() instanceof JComponent) {
                this.getParent().revalidate();
                this.getParent().repaint();
            }
            return new CellTransform.Restore(){

                public ActionCallback restoreInGrid() {
                    if (myComponent != null) {
                        this.setContent(myComponent);
                        myComponent = null;
                    }
                    return ActionCallback.DONE;
                }
            };
        }

        public void doLayout() {
            Component child2;
            super.doLayout();
            Component component2 = child2 = this.getComponentCount() == 1 ? this.getComponent(0) : null;
            if (child2 instanceof JBTabsPresentation && !((JBTabsPresentation)child2).isHideTabs()) {
                Rectangle bounds2 = child2.getBounds();
                --bounds2.y;
                ++bounds2.height;
                child2.setBounds(bounds2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/execution/ui/layout/impl/GridImpl$Placeholder", "setContentProvider"));
        }
    }

    public static interface ContentProvider {
        public Content[] getContents();
    }
}

