/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.services.ServiceModel;
import com.intellij.execution.services.ServiceView;
import com.intellij.execution.services.ServiceViewActionProvider;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewModel;
import com.intellij.execution.services.ServiceViewUi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

class ServiceSingleView
extends ServiceView {
    private final AtomicReference<ServiceModel.ServiceViewItem> myRef;
    private boolean mySelected;
    private final ServiceViewModel.ServiceViewModelListener myListener;

    ServiceSingleView(@NotNull Project project, @NotNull ServiceViewModel model, @NotNull ServiceViewUi ui) {
        if (project == null) {
            ServiceSingleView.$$$reportNull$$$0(0);
        }
        if (model == null) {
            ServiceSingleView.$$$reportNull$$$0(1);
        }
        if (ui == null) {
            ServiceSingleView.$$$reportNull$$$0(2);
        }
        super(new BorderLayout(), project, model, ui);
        this.myRef = new AtomicReference();
        ui.setServiceToolbar(ServiceViewActionProvider.getInstance());
        this.add((Component)ui.getComponent(), "Center");
        this.myListener = this::updateItem;
        model.addModelListener(this.myListener);
        model.getInvoker().invokeLater(this::updateItem);
    }

    @Override
    @NotNull
    Promise<Void> select(@NotNull Object service, @NotNull Class<?> contributorClass) {
        ServiceModel.ServiceViewItem item;
        if (service == null) {
            ServiceSingleView.$$$reportNull$$$0(3);
        }
        if (contributorClass == null) {
            ServiceSingleView.$$$reportNull$$$0(4);
        }
        if ((item = this.myRef.get()) == null || !item.getValue().equals(service)) {
            Promise promise = Promises.rejectedPromise((String)"Service not found");
            if (promise == null) {
                ServiceSingleView.$$$reportNull$$$0(5);
            }
            return promise;
        }
        this.showContent();
        Promise promise = Promises.resolvedPromise();
        if (promise == null) {
            ServiceSingleView.$$$reportNull$$$0(6);
        }
        return promise;
    }

    @Override
    Promise<Void> expand(@NotNull Object service, @NotNull Class<?> contributorClass) {
        ServiceModel.ServiceViewItem item;
        if (service == null) {
            ServiceSingleView.$$$reportNull$$$0(7);
        }
        if (contributorClass == null) {
            ServiceSingleView.$$$reportNull$$$0(8);
        }
        return (item = this.myRef.get()) == null || !item.getValue().equals(service) ? Promises.rejectedPromise((String)"Service not found") : Promises.resolvedPromise();
    }

    @Override
    void onViewSelected() {
        this.showContent();
    }

    @Override
    void onViewUnselected() {
        this.mySelected = false;
        ServiceModel.ServiceViewItem item = this.myRef.get();
        if (item != null) {
            item.getViewDescriptor().onNodeUnselected();
        }
    }

    @Override
    @NotNull
    List<ServiceModel.ServiceViewItem> getSelectedItems() {
        ServiceModel.ServiceViewItem item = this.myRef.get();
        List<Object> list2 = item == null ? Collections.emptyList() : Collections.singletonList(item);
        if (list2 == null) {
            ServiceSingleView.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @Override
    void jumpToServices() {
    }

    @Override
    public void dispose() {
        this.getModel().removeModelListener(this.myListener);
    }

    private void updateItem() {
        ServiceModel.ServiceViewItem oldValue = this.myRef.get();
        ServiceModel.ServiceViewItem newValue = (ServiceModel.ServiceViewItem)ContainerUtil.getOnlyItem(this.getModel().getRoots());
        this.myRef.set(newValue);
        ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this.getProject())).submit(() -> {
            if (this.mySelected && newValue != null) {
                ServiceViewDescriptor descriptor2 = newValue.getViewDescriptor();
                if (oldValue == null) {
                    this.onViewSelected(descriptor2);
                }
                this.myUi.setDetailsComponent(descriptor2.getContentComponent());
            }
        });
    }

    private void showContent() {
        if (this.mySelected) {
            return;
        }
        this.mySelected = true;
        ServiceModel.ServiceViewItem item = this.myRef.get();
        if (item != null) {
            ServiceViewDescriptor descriptor2 = item.getViewDescriptor();
            this.onViewSelected(descriptor2);
            this.myUi.setDetailsComponent(descriptor2.getContentComponent());
        }
    }

    @Override
    List<Object> getChildrenSafe(@NotNull List<Object> valueSubPath) {
        if (valueSubPath == null) {
            ServiceSingleView.$$$reportNull$$$0(10);
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributorClass";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/services/ServiceSingleView";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueSubPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/services/ServiceSingleView";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "select";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenSafe";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

