/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.diagnostic.logging.AdditionalTabComponent;
import com.intellij.diagnostic.logging.DefaultLogFormatter;
import com.intellij.diagnostic.logging.LogConsole;
import com.intellij.diagnostic.logging.LogConsoleListener;
import com.intellij.diagnostic.logging.LogContentPreprocessor;
import com.intellij.diagnostic.logging.LogFilter;
import com.intellij.diagnostic.logging.LogFilterListener;
import com.intellij.diagnostic.logging.LogFilterModel;
import com.intellij.diagnostic.logging.LogFormatter;
import com.intellij.diagnostic.logging.LogFragment;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.impl.ConsoleBuffer;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.FilterComponent;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.List;
import java.util.function.BiConsumer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LogConsoleBase
extends AdditionalTabComponent
implements LogConsole,
LogFilterListener {
    private static final Logger LOG = Logger.getInstance(LogConsoleBase.class);
    @NonNls
    public static final String APPLYING_FILTER_TITLE = "Applying filter...";
    private JPanel mySearchComponent;
    private JComboBox myLogFilterCombo;
    private JPanel myTextFilterWrapper;
    private volatile boolean myDisposed;
    private ConsoleView myConsole;
    private final LightProcessHandler myProcessHandler;
    private ReaderThread myReaderThread;
    private StringBuffer myOriginalDocument;
    private String myLineUnderSelection;
    private int myLineOffset;
    private LogContentPreprocessor myContentPreprocessor;
    private final Project myProject;
    private String myTitle;
    private boolean myWasInitialized;
    private final JPanel myTopComponent;
    private ActionGroup myActions;
    private final boolean myBuildInActions;
    private LogFilterModel myModel;
    private final LogFormatter myFormatter;
    private final List<LogConsoleListener> myListeners;
    private final List<? extends LogFilter> myFilters;
    private FilterComponent myFilter;

    public LogConsoleBase(@NotNull Project project, @Nullable Reader reader, String title, boolean buildInActions, LogFilterModel model) {
        if (project == null) {
            LogConsoleBase.$$$reportNull$$$0(0);
        }
        this(project, reader, title, buildInActions, model, GlobalSearchScope.allScope((Project)project));
    }

    public LogConsoleBase(@NotNull Project project, @Nullable Reader reader, String title, boolean buildInActions, LogFilterModel model, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            LogConsoleBase.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            LogConsoleBase.$$$reportNull$$$0(2);
        }
        this(project, reader, title, buildInActions, model, scope, new DefaultLogFormatter());
    }

    public LogConsoleBase(@NotNull Project project, @Nullable Reader reader, String title, boolean buildInActions, LogFilterModel model, @NotNull GlobalSearchScope scope, LogFormatter formatter) {
        if (project == null) {
            LogConsoleBase.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            LogConsoleBase.$$$reportNull$$$0(4);
        }
        super((LayoutManager)new BorderLayout());
        this.$$$setupUI$$$();
        this.myProcessHandler = new LightProcessHandler();
        this.myOriginalDocument = null;
        this.myLineUnderSelection = null;
        this.myLineOffset = -1;
        this.myTitle = null;
        this.myTopComponent = new JPanel(new BorderLayout());
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myFilter = new FilterComponent("LOG_FILTER_HISTORY", 5){

            public void filter() {
                Task.Backgroundable task2 = new Task.Backgroundable(LogConsoleBase.this.myProject, LogConsoleBase.APPLYING_FILTER_TITLE){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        LogConsoleBase.this.myModel.updateCustomFilter(this.getFilter());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diagnostic/logging/LogConsoleBase$1$1", "run"));
                    }
                };
                ProgressManager.getInstance().run((Task)task2);
            }
        };
        this.myProject = project;
        this.myTitle = title;
        this.myModel = model;
        this.myFormatter = formatter;
        this.myFilters = this.myModel.getLogFilters();
        this.myReaderThread = new ReaderThread(reader);
        this.myBuildInActions = buildInActions;
        TextConsoleBuilder builder2 = TextConsoleBuilderFactory.getInstance().createBuilder(project, scope);
        this.myConsole = builder2.getConsole();
        this.myConsole.attachToProcess((ProcessHandler)this.myProcessHandler);
        this.myDisposed = false;
        this.myModel.addFilterListener((LogFilterListener)this);
    }

    public void setFilterModel(LogFilterModel model) {
        if (this.myModel != null) {
            this.myModel.removeFilterListener((LogFilterListener)this);
        }
        this.myModel = model;
        this.myModel.addFilterListener((LogFilterListener)this);
    }

    public LogFilterModel getFilterModel() {
        return this.myModel;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public LogContentPreprocessor getContentPreprocessor() {
        return this.myContentPreprocessor;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public void setContentPreprocessor(LogContentPreprocessor contentPreprocessor) {
        this.myContentPreprocessor = contentPreprocessor;
    }

    @Nullable
    protected BufferedReader updateReaderIfNeeded(@Nullable BufferedReader reader) throws IOException {
        return reader;
    }

    private JComponent createToolbar() {
        String customFilter = this.myModel.getCustomFilter();
        this.myFilter.reset();
        this.myFilter.setSelectedItem(customFilter != null ? customFilter : "");
        if (!ScreenReader.isActive()) {
            new AnAction(){
                {
                    this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(9, 64)), (JComponent)((Object)LogConsoleBase.this));
                }

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    LogConsoleBase.this.myFilter.requestFocusInWindow();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diagnostic/logging/LogConsoleBase$2", "actionPerformed"));
                }
            };
        }
        if (this.myBuildInActions) {
            JComponent tbComp = ActionManager.getInstance().createActionToolbar("LogConsole", this.getOrCreateActions(), true).getComponent();
            this.myTopComponent.add((Component)tbComp, "Center");
            this.myTopComponent.add((Component)this.getSearchComponent(), "East");
        }
        return this.myTopComponent;
    }

    public ActionGroup getOrCreateActions() {
        AnAction[] actions;
        if (this.myActions != null) {
            return this.myActions;
        }
        DefaultActionGroup group = new DefaultActionGroup();
        for (AnAction action2 : actions = this.getConsoleNotNull().createConsoleActions()) {
            group.add(action2);
        }
        group.addSeparator();
        this.myActions = group;
        return this.myActions;
    }

    public void onFilterStateChange(@NotNull LogFilter filter2) {
        if (filter2 == null) {
            LogConsoleBase.$$$reportNull$$$0(5);
        }
        this.filterConsoleOutput();
    }

    public void onTextFilterChange() {
        this.filterConsoleOutput();
    }

    @NotNull
    public JComponent getComponent() {
        if (!this.myWasInitialized) {
            this.myWasInitialized = true;
            this.add(this.getConsoleNotNull().getComponent(), "Center");
            this.add(this.createToolbar(), "North");
        }
        LogConsoleBase logConsoleBase = this;
        if (logConsoleBase == null) {
            LogConsoleBase.$$$reportNull$$$0(6);
        }
        return logConsoleBase;
    }

    public abstract boolean isActive();

    public void activate() {
        ReaderThread readerThread = this.myReaderThread;
        if (readerThread == null) {
            return;
        }
        if (this.isActive() && !readerThread.myRunning) {
            this.resetLogFilter();
            this.myFilter.setSelectedItem(this.myModel.getCustomFilter());
            readerThread.startRunning();
            ApplicationManager.getApplication().executeOnPooledThread((Runnable)readerThread);
        } else if (!this.isActive() && readerThread.myRunning) {
            readerThread.stopRunning();
        }
    }

    @NotNull
    public String getTabTitle() {
        String string = this.myTitle;
        if (string == null) {
            LogConsoleBase.$$$reportNull$$$0(7);
        }
        return string;
    }

    public void dispose() {
        this.myModel.removeFilterListener((LogFilterListener)this);
        this.stopRunning(false);
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        Disposer.dispose((Disposable)this.myConsole);
        this.myConsole = null;
        this.myFilter.dispose();
        this.myFilter = null;
        this.myOriginalDocument = null;
    }

    private void stopRunning(boolean checkActive) {
        ReaderThread readerThread;
        if (!checkActive) {
            this.fireLoggingWillBeStopped();
        }
        if ((readerThread = this.myReaderThread) != null && readerThread.myReader != null) {
            if (!checkActive) {
                readerThread.stopRunning();
                try {
                    readerThread.myReader.close();
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
                readerThread.myReader = null;
                this.myReaderThread = null;
            } else {
                try {
                    BufferedReader reader = readerThread.myReader;
                    while (reader.ready()) {
                        this.addMessage(reader.readLine());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.stopRunning(false);
            }
        }
    }

    protected void addMessage(String text2) {
        if (this.myDisposed) {
            return;
        }
        if (text2 == null) {
            return;
        }
        if (this.myContentPreprocessor != null) {
            List fragments = this.myContentPreprocessor.parseLogLine(text2 + "\n");
            this.myOriginalDocument = this.getOriginalDocument();
            for (LogFragment fragment : fragments) {
                String formattedMessage = this.myFormatter.formatMessage(fragment.getText());
                this.myProcessHandler.notifyTextAvailable(formattedMessage, fragment.getOutputType());
                if (this.myOriginalDocument == null) continue;
                this.myOriginalDocument.append(fragment.getText());
            }
        } else {
            Key key;
            LogFilterModel.MyProcessingResult processingResult = this.myModel.processLine(text2);
            if (processingResult.isApplicable() && (key = processingResult.getKey()) != null) {
                String messagePrefix = processingResult.getMessagePrefix();
                if (messagePrefix != null) {
                    String formattedPrefix = this.myFormatter.formatPrefix(messagePrefix);
                    this.myProcessHandler.notifyTextAvailable(formattedPrefix, key);
                }
                String formattedMessage = this.myFormatter.formatMessage(text2);
                this.myProcessHandler.notifyTextAvailable(formattedMessage + "\n", key);
            }
            this.myOriginalDocument = this.getOriginalDocument();
            if (this.myOriginalDocument != null) {
                this.myOriginalDocument.append(text2).append("\n");
            }
        }
    }

    public void attachStopLogConsoleTrackingListener(final ProcessHandler process2) {
        if (process2 != null) {
            ProcessAdapter stopListener = new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    process2.removeProcessListener((ProcessListener)this);
                    LogConsoleBase.this.stopRunning(true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diagnostic/logging/LogConsoleBase$3", "processTerminated"));
                }
            };
            process2.addProcessListener((ProcessListener)stopListener);
        }
    }

    public StringBuffer getOriginalDocument() {
        if (this.myOriginalDocument == null) {
            Editor editor = this.getEditor();
            if (editor != null) {
                this.myOriginalDocument = new StringBuffer(editor.getDocument().getText());
            }
        } else if (ConsoleBuffer.useCycleBuffer()) {
            LogConsoleBase.resizeBuffer(this.myOriginalDocument, ConsoleBuffer.getCycleBufferSize());
        }
        return this.myOriginalDocument;
    }

    static void resizeBuffer(@NotNull StringBuffer buffer, int size) {
        int toRemove2;
        if (buffer == null) {
            LogConsoleBase.$$$reportNull$$$0(8);
        }
        if ((toRemove2 = buffer.length() - size) > 0) {
            int indexOfNewline = buffer.indexOf("\n", toRemove2);
            if (indexOfNewline == -1) {
                buffer.delete(0, toRemove2);
            } else {
                buffer.delete(0, indexOfNewline + 1);
            }
        }
    }

    @Nullable
    private Editor getEditor() {
        ConsoleView console = this.getConsole();
        return console != null ? (Editor)CommonDataKeys.EDITOR.getData((DataProvider)console) : null;
    }

    private void filterConsoleOutput() {
        ApplicationManager.getApplication().invokeLater(() -> this.computeSelectedLineAndFilter());
    }

    private void computeSelectedLineAndFilter() {
        this.myOriginalDocument = this.getOriginalDocument();
        if (this.myOriginalDocument != null) {
            Editor editor = this.getEditor();
            LOG.assertTrue(editor != null);
            Document document = editor.getDocument();
            int caretOffset = editor.getCaretModel().getOffset();
            this.myLineUnderSelection = null;
            this.myLineOffset = -1;
            if (caretOffset > -1 && caretOffset < document.getTextLength()) {
                int line;
                try {
                    line = document.getLineNumber(caretOffset);
                }
                catch (IllegalStateException e) {
                    throw new IllegalStateException("document.length=" + document.getTextLength() + ", caret offset = " + caretOffset + "; " + e.getMessage(), e);
                }
                if (line > -1 && line < document.getLineCount()) {
                    int startOffset = document.getLineStartOffset(line);
                    this.myLineUnderSelection = document.getText().substring(startOffset, document.getLineEndOffset(line));
                    this.myLineOffset = caretOffset - startOffset;
                }
            }
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> this.doFilter());
    }

    private void doFilter() {
        if (this.myDisposed) {
            return;
        }
        ConsoleView console = this.getConsoleNotNull();
        console.clear();
        this.myModel.processingStarted();
        String[] lines = this.myOriginalDocument != null ? this.myOriginalDocument.toString().split("\n") : ArrayUtilRt.EMPTY_STRING_ARRAY;
        int offset = 0;
        boolean caretPositioned = false;
        AnsiEscapeDecoder decoder = new AnsiEscapeDecoder();
        for (String line : lines) {
            int printed = this.printMessageToConsole(line, (text2, key) -> decoder.escapeText(text2, key, (chunk, attributes) -> console.print(chunk, ConsoleViewContentType.getConsoleViewType((Key)attributes))));
            if (printed <= 0 || caretPositioned) continue;
            if (Comparing.strEqual((String)this.myLineUnderSelection, (String)line)) {
                caretPositioned = true;
                offset += this.myLineOffset != -1 ? this.myLineOffset : 0;
                continue;
            }
            offset += printed;
        }
        if (caretPositioned) {
            console.scrollTo(offset);
        } else {
            console.requestScrollingToEnd();
        }
    }

    private int printMessageToConsole(@NotNull String line, @NotNull BiConsumer<? super String, ? super Key> printer) {
        Key key;
        if (line == null) {
            LogConsoleBase.$$$reportNull$$$0(9);
        }
        if (printer == null) {
            LogConsoleBase.$$$reportNull$$$0(10);
        }
        if (this.myContentPreprocessor != null) {
            List fragments = this.myContentPreprocessor.parseLogLine(line + '\n');
            for (LogFragment fragment : fragments) {
                printer.accept(this.myFormatter.formatMessage(fragment.getText()), (Key)fragment.getOutputType());
            }
            return line.length() + 1;
        }
        LogFilterModel.MyProcessingResult processingResult = this.myModel.processLine(line);
        if (processingResult.isApplicable() && (key = processingResult.getKey()) != null) {
            String messagePrefix = processingResult.getMessagePrefix();
            if (messagePrefix != null) {
                printer.accept(this.myFormatter.formatPrefix(messagePrefix), (Key)key);
            }
            printer.accept(this.myFormatter.formatMessage(line) + "\n", (Key)key);
            return (messagePrefix != null ? messagePrefix.length() : 0) + line.length() + 1;
        }
        return 0;
    }

    @Nullable
    public ConsoleView getConsole() {
        return this.myConsole;
    }

    @NotNull
    private ConsoleView getConsoleNotNull() {
        ConsoleView console = this.getConsole();
        assert (console != null) : "it looks like console has been disposed";
        ConsoleView consoleView = console;
        if (consoleView == null) {
            LogConsoleBase.$$$reportNull$$$0(11);
        }
        return consoleView;
    }

    public ActionGroup getToolbarActions() {
        return this.getOrCreateActions();
    }

    public String getToolbarPlace() {
        return "unknown";
    }

    @Nullable
    public JComponent getToolbarContextComponent() {
        ConsoleView console = this.getConsole();
        return console == null ? null : console.getComponent();
    }

    public JComponent getPreferredFocusableComponent() {
        return this.getConsoleNotNull().getPreferredFocusableComponent();
    }

    public String getTitle() {
        return this.myTitle;
    }

    public void clear() {
        this.getConsoleNotNull().clear();
        this.myOriginalDocument = null;
    }

    public JComponent getSearchComponent() {
        this.myLogFilterCombo.setModel(new DefaultComboBoxModel<LogFilter>(this.myFilters.toArray(new LogFilter[0])));
        this.resetLogFilter();
        this.myLogFilterCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final LogFilter filter2 = (LogFilter)LogConsoleBase.this.myLogFilterCombo.getSelectedItem();
                Task.Backgroundable task2 = new Task.Backgroundable(LogConsoleBase.this.myProject, LogConsoleBase.APPLYING_FILTER_TITLE){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        LogConsoleBase.this.myModel.selectFilter(filter2);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diagnostic/logging/LogConsoleBase$4$1", "run"));
                    }
                };
                ProgressManager.getInstance().run((Task)task2);
            }
        });
        AccessibleContextUtil.setName((Component)this.myLogFilterCombo, (String)"Message severity filter");
        this.myTextFilterWrapper.removeAll();
        this.myTextFilterWrapper.add(this.getTextFilterComponent());
        return this.mySearchComponent;
    }

    private void resetLogFilter() {
        for (LogFilter logFilter : this.myFilters) {
            if (!this.myModel.isFilterSelected(logFilter) || this.myLogFilterCombo.getSelectedItem() == logFilter) continue;
            this.myLogFilterCombo.setSelectedItem(logFilter);
            break;
        }
    }

    @NotNull
    protected Component getTextFilterComponent() {
        FilterComponent filterComponent = this.myFilter;
        if (filterComponent == null) {
            LogConsoleBase.$$$reportNull$$$0(12);
        }
        return filterComponent;
    }

    public boolean isContentBuiltIn() {
        return this.myBuildInActions;
    }

    public void writeToConsole(String text2, Key outputType) {
        this.myProcessHandler.notifyTextAvailable(text2, outputType);
    }

    public void addListener(LogConsoleListener listener2) {
        this.myListeners.add(listener2);
    }

    private void fireLoggingWillBeStopped() {
        for (LogConsoleListener listener2 : this.myListeners) {
            listener2.loggingWillBeStopped();
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JComboBox jComboBox;
        JPanel jPanel2;
        this.mySearchComponent = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 10), -1, -1, false, false));
        this.myLogFilterCombo = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 0, 0, new Dimension(100, -1), null, null));
        this.myTextFilterWrapper = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mySearchComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/logging/LogConsoleBase";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/logging/LogConsoleBase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabTitle";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleNotNull";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFilterComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onFilterStateChange";
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resizeBuffer";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "printMessageToConsole";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ReaderThread
    implements Runnable {
        private BufferedReader myReader;
        private boolean myRunning = false;
        private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)LogConsoleBase.this);

        ReaderThread(Reader reader) {
            this.myReader = reader != null ? new BufferedReader(reader) : null;
        }

        @Override
        public void run() {
            if (this.myReader == null) {
                return;
            }
            Runnable runnable2 = new Runnable(){

                @Override
                public void run() {
                    if (ReaderThread.this.myRunning) {
                        try {
                            ReaderThread.this.myReader = LogConsoleBase.this.updateReaderIfNeeded(ReaderThread.this.myReader);
                            int i = 0;
                            while (i++ < 1000) {
                                BufferedReader reader = ReaderThread.this.myReader;
                                if (ReaderThread.this.myRunning && reader != null && reader.ready()) {
                                    LogConsoleBase.this.addMessage(reader.readLine());
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (IOException e) {
                            LOG.info((Throwable)e);
                            LogConsoleBase.this.addMessage("I/O Error" + (e.getMessage() != null ? ": " + e.getMessage() : ""));
                            return;
                        }
                    }
                    if (ReaderThread.this.myAlarm.isDisposed()) {
                        return;
                    }
                    ReaderThread.this.myAlarm.addRequest((Runnable)this, 100);
                }
            };
            if (this.myAlarm.isDisposed()) {
                return;
            }
            this.myAlarm.addRequest(runnable2, 10);
        }

        public void startRunning() {
            this.myRunning = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopRunning() {
            this.myRunning = false;
            ReaderThread readerThread = this;
            synchronized (readerThread) {
                this.notifyAll();
            }
        }
    }

    private static class LightProcessHandler
    extends ProcessHandler {
        private final AnsiEscapeDecoder myDecoder = new AnsiEscapeDecoder();

        private LightProcessHandler() {
        }

        public void notifyTextAvailable(@NotNull String text2, @NotNull Key outputType) {
            if (text2 == null) {
                LightProcessHandler.$$$reportNull$$$0(0);
            }
            if (outputType == null) {
                LightProcessHandler.$$$reportNull$$$0(1);
            }
            this.myDecoder.escapeText(text2, outputType, (chunk, attributes) -> super.notifyTextAvailable(chunk, attributes));
        }

        protected void destroyProcessImpl() {
            throw new UnsupportedOperationException();
        }

        protected void detachProcessImpl() {
            throw new UnsupportedOperationException();
        }

        public boolean detachIsDefault() {
            return false;
        }

        @Nullable
        public OutputStream getProcessInput() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outputType";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diagnostic/logging/LogConsoleBase$LightProcessHandler";
            objectArray[2] = "notifyTextAvailable";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

