/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.WindowsDefenderChecker;
import com.intellij.diagnostic.WindowsDefenderNotification;
import com.intellij.notification.Notification;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/diagnostic/WindowsDefenderCheckerActivity;", "Lcom/intellij/openapi/startup/StartupActivity$Background;", "()V", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.ide.impl"})
public final class WindowsDefenderCheckerActivity
implements StartupActivity.Background {
    /*
     * WARNING - void declaration
     */
    public void runActivity(@NotNull Project project) {
        Application app;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Application application = app = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"app");
        if (application.isUnitTestMode()) {
            return;
        }
        WindowsDefenderChecker windowsDefenderChecker = WindowsDefenderChecker.getInstance();
        if (windowsDefenderChecker.isVirusCheckIgnored(project)) {
            return;
        }
        WindowsDefenderChecker.CheckResult checkResult = windowsDefenderChecker.checkWindowsDefender(project);
        if (checkResult.status == WindowsDefenderChecker.RealtimeScanningStatus.SCANNING_ENABLED) {
            boolean bl;
            block8: {
                Map<Path, Boolean> map2 = checkResult.pathStatus;
                Intrinsics.checkExpressionValueIsNotNull(map2, (String)"checkResult.pathStatus");
                Map<Path, Boolean> $this$any$iv = map2;
                boolean $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl = false;
                } else {
                    Map<Path, Boolean> map3 = $this$any$iv;
                    boolean bl2 = false;
                    Iterator<Map.Entry<Path, Boolean>> iterator2 = map3.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry<Path, Boolean> element$iv;
                        Map.Entry<Path, Boolean> it = element$iv = iterator2.next();
                        boolean bl3 = false;
                        if (!(it.getValue() == false)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) {
                void $this$filterTo$iv$iv;
                Map<Path, Boolean> map4 = checkResult.pathStatus;
                Intrinsics.checkExpressionValueIsNotNull(map4, (String)"checkResult.pathStatus");
                Map<Path, Boolean> $this$filter$iv = map4;
                boolean $i$f$filter = false;
                Map<Path, Boolean> map5 = $this$filter$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$filterTo = false;
                void var11_15 = $this$filterTo$iv$iv;
                boolean bl4 = false;
                Iterator iterator3 = var11_15.entrySet().iterator();
                while (iterator3.hasNext()) {
                    Map.Entry element$iv$iv;
                    Map.Entry it = element$iv$iv = iterator3.next();
                    boolean bl5 = false;
                    if (!((Boolean)it.getValue() == false)) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                Set nonExcludedPaths = destination$iv$iv.keySet();
                Object[] objectArray = new Object[2];
                ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
                objectArray[0] = applicationNamesInfo.getFullProductName();
                objectArray[1] = CollectionsKt.joinToString$default((Iterable)nonExcludedPaths, (CharSequence)"<br/>", null, null, (int)0, null, null, (int)62, null);
                String string = DiagnosticBundle.message("virus.scanning.warn.message", objectArray);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DiagnosticBundle.message\u2026hs.joinToString(\"<br/>\"))");
                WindowsDefenderNotification notification = new WindowsDefenderNotification(string, nonExcludedPaths);
                notification.setImportant(true);
                notification.setCollapseActionsDirection(Notification.CollapseActionsDirection.KEEP_LEFTMOST);
                windowsDefenderChecker.configureActions(project, notification);
                app.invokeLater(new Runnable(notification, project){
                    final /* synthetic */ WindowsDefenderNotification $notification;
                    final /* synthetic */ Project $project;

                    public final void run() {
                        this.$notification.notify(this.$project);
                    }
                    {
                        this.$notification = windowsDefenderNotification;
                        this.$project = project;
                    }
                });
            }
        }
    }
}

