/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.enter;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.codeInsight.editorActions.enter.EnterInCommentUtil;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class EnterInLineCommentHandler
extends EnterHandlerDelegateAdapter {
    private static final String WHITESPACE = " \t";

    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        CodeDocumentationAwareCommenter commenter;
        if (file2 == null) {
            EnterInLineCommentHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            EnterInLineCommentHandler.$$$reportNull$$$0(1);
        }
        if (caretOffsetRef == null) {
            EnterInLineCommentHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            EnterInLineCommentHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            EnterInLineCommentHandler.$$$reportNull$$$0(4);
        }
        if ((commenter = EnterInCommentUtil.getDocumentationAwareCommenter(dataContext)) == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int caretOffset = (Integer)caretOffsetRef.get();
        int lineCommentStartOffset = EnterInLineCommentHandler.getLineCommentStartOffset(editor, caretOffset, commenter);
        if (lineCommentStartOffset < 0) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Document document = editor.getDocument();
        CharSequence text2 = document.getImmutableCharSequence();
        int offset = CharArrayUtil.shiftForward((CharSequence)text2, (int)caretOffset, (String)WHITESPACE);
        if (offset >= document.getTextLength() || text2.charAt(offset) == '\n') {
            return EnterHandlerDelegate.Result.Continue;
        }
        String prefix = commenter.getLineCommentPrefix();
        assert (prefix != null) : "Line Comment type is set but Line Comment Prefix is null!";
        String prefixTrimmed = prefix.trim();
        int beforeCommentOffset = CharArrayUtil.shiftBackward((CharSequence)text2, (int)(lineCommentStartOffset - 1), (String)WHITESPACE);
        boolean onlyCommentInCaretLine = beforeCommentOffset < 0 || text2.charAt(beforeCommentOffset) == '\n';
        CharSequence spacing = " ";
        if (StringUtil.startsWith((CharSequence)text2, (int)offset, (CharSequence)prefix)) {
            int afterPrefix = offset + prefixTrimmed.length();
            if (afterPrefix < document.getTextLength() && text2.charAt(afterPrefix) != ' ') {
                document.insertString(afterPrefix, spacing);
            }
            caretOffsetRef.set((Object)offset);
        } else {
            if (onlyCommentInCaretLine) {
                int indentStart = lineCommentStartOffset + prefix.trim().length();
                int indentEnd = CharArrayUtil.shiftForward((CharSequence)text2, (int)indentStart, (String)WHITESPACE);
                CharSequence currentLineSpacing = text2.subSequence(indentStart, indentEnd);
                if (TodoConfiguration.getInstance().isMultiLine() && EnterInCommentUtil.isTodoText(text2, lineCommentStartOffset, caretOffset) && EnterInCommentUtil.isTodoText(text2, lineCommentStartOffset, DocumentUtil.getLineEndOffset(lineCommentStartOffset, document))) {
                    spacing = currentLineSpacing + " ";
                } else if (currentLineSpacing.length() > 0) {
                    spacing = currentLineSpacing;
                }
                int textStart = CharArrayUtil.shiftForward((CharSequence)text2, (int)caretOffset, (String)WHITESPACE);
                document.deleteString(caretOffset, textStart);
            } else if (text2.charAt(caretOffset) == ' ') {
                spacing = "";
            }
            document.insertString(caretOffset, (CharSequence)(prefixTrimmed + spacing));
        }
        if (onlyCommentInCaretLine) {
            caretAdvance.set((Object)(prefixTrimmed.length() + spacing.length()));
        }
        return EnterHandlerDelegate.Result.DefaultForceIndent;
    }

    private static int getLineCommentStartOffset(@NotNull Editor editor, int offset, @NotNull CodeDocumentationAwareCommenter commenter) {
        if (editor == null) {
            EnterInLineCommentHandler.$$$reportNull$$$0(5);
        }
        if (commenter == null) {
            EnterInLineCommentHandler.$$$reportNull$$$0(6);
        }
        if (offset < 1) {
            return -1;
        }
        EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
        HighlighterIterator iterator2 = highlighter.createIterator(offset - 1);
        String prefix = commenter.getLineCommentPrefix();
        return iterator2.getTokenType() == commenter.getLineCommentTokenType() && iterator2.getStart() + (prefix == null ? 0 : prefix.length()) <= offset ? iterator2.getStart() : -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffsetRef";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvance";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commenter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/enter/EnterInLineCommentHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessEnter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineCommentStartOffset";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

