/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.codeInsight.documentation.render.DocRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JEditorPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.AWTAccessor;

class DocRenderMouseEventBridge
implements EditorMouseListener,
EditorMouseMotionListener {
    private Inlay<? extends DocRenderer> myCurrentInlay;

    DocRenderMouseEventBridge() {
    }

    public void mouseMoved(@NotNull EditorMouseEvent event) {
        if (event == null) {
            DocRenderMouseEventBridge.$$$reportNull$$$0(0);
        }
        if (event.getArea() != EditorMouseEventArea.EDITING_AREA) {
            return;
        }
        Inlay<? extends DocRenderer> currentInlay = DocRenderMouseEventBridge.redispatchEvent(event.getEditor(), event.getMouseEvent(), 503);
        if (currentInlay == null) {
            this.restoreCursor();
        } else {
            ((EditorEx)event.getEditor()).setCustomCursor(DocRenderMouseEventBridge.class, ((DocRenderer)currentInlay.getRenderer()).myPane.getCursor());
            if (currentInlay != this.myCurrentInlay) {
                if (this.myCurrentInlay != null) {
                    DocRenderMouseEventBridge.dispatchMouseExitEvent(this.myCurrentInlay);
                }
                this.myCurrentInlay = currentInlay;
            }
        }
    }

    public void mouseExited(@NotNull EditorMouseEvent event) {
        if (event == null) {
            DocRenderMouseEventBridge.$$$reportNull$$$0(1);
        }
        if (event.getArea() != EditorMouseEventArea.EDITING_AREA) {
            return;
        }
        this.restoreCursor();
    }

    public void mouseClicked(@NotNull EditorMouseEvent event) {
        if (event == null) {
            DocRenderMouseEventBridge.$$$reportNull$$$0(2);
        }
        if (event.getArea() != EditorMouseEventArea.EDITING_AREA) {
            return;
        }
        DocRenderMouseEventBridge.redispatchEvent(event.getEditor(), event.getMouseEvent(), 500);
    }

    private void restoreCursor() {
        if (this.myCurrentInlay != null) {
            DocRenderMouseEventBridge.dispatchMouseExitEvent(this.myCurrentInlay);
            ((EditorEx)this.myCurrentInlay.getEditor()).setCustomCursor(DocRenderMouseEventBridge.class, null);
            this.myCurrentInlay = null;
        }
    }

    @Nullable
    private static Inlay<? extends DocRenderer> redispatchEvent(@NotNull Editor editor, @NotNull MouseEvent mouseEvent, int eventId) {
        if (editor == null) {
            DocRenderMouseEventBridge.$$$reportNull$$$0(3);
        }
        if (mouseEvent == null) {
            DocRenderMouseEventBridge.$$$reportNull$$$0(4);
        }
        Point mousePoint = mouseEvent.getPoint();
        Inlay inlay = editor.getInlayModel().getElementAt(mousePoint, DocRenderer.class);
        if (inlay != null) {
            DocRenderer renderer = (DocRenderer)inlay.getRenderer();
            Point relativeLocation = renderer.getEditorPaneLocationWithinInlay();
            Rectangle inlayBounds = inlay.getBounds();
            assert (inlayBounds != null);
            int x = mousePoint.x - inlayBounds.x - relativeLocation.x;
            int y = mousePoint.y - inlayBounds.y - relativeLocation.y;
            JEditorPane editorPane = renderer.myPane;
            if (x >= 0 && x < editorPane.getWidth() && y >= 0 && y < editorPane.getHeight()) {
                int button2 = mouseEvent.getButton();
                DocRenderMouseEventBridge.dispatchEvent((Inlay<? extends DocRenderer>)inlay, new MouseEvent(editorPane, eventId, 0L, 0, x, y, mouseEvent.getClickCount(), false, button2 == 2 ? 1 : button2));
                return inlay;
            }
        }
        return null;
    }

    private static void dispatchEvent(@NotNull Inlay<? extends DocRenderer> inlay, @NotNull MouseEvent event) {
        if (inlay == null) {
            DocRenderMouseEventBridge.$$$reportNull$$$0(5);
        }
        if (event == null) {
            DocRenderMouseEventBridge.$$$reportNull$$$0(6);
        }
        DocRenderer renderer = (DocRenderer)inlay.getRenderer();
        renderer.doWithRepaintTracking(() -> AWTAccessor.getComponentAccessor().processEvent(renderer.myPane, event));
    }

    private static void dispatchMouseExitEvent(@NotNull Inlay<? extends DocRenderer> inlay) {
        if (inlay == null) {
            DocRenderMouseEventBridge.$$$reportNull$$$0(7);
        }
        DocRenderMouseEventBridge.dispatchEvent(inlay, new MouseEvent(((DocRenderer)inlay.getRenderer()).myPane, 505, 0L, 0, 0, 0, 0, false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mouseEvent";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlay";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderMouseEventBridge";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseMoved";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseExited";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseClicked";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "redispatchEvent";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "dispatchEvent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "dispatchMouseExitEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

