/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class ShowQuickDocInfoAction
extends BaseCodeInsightAction
implements HintManagerImpl.ActionToIgnore,
DumbAware,
PopupAction {
    public static final String CODEASSISTS_QUICKJAVADOC_FEATURE = "codeassists.quickjavadoc";
    public static final String CODEASSISTS_QUICKJAVADOC_LOOKUP_FEATURE = "codeassists.quickjavadoc.lookup";
    public static final String CODEASSISTS_QUICKJAVADOC_CTRLN_FEATURE = "codeassists.quickjavadoc.ctrln";

    public ShowQuickDocInfoAction() {
        this.setEnabledInModalContext(true);
        this.setInjectedContext(true);
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        return new CodeInsightActionHandler(){

            public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
                JBPopup hint;
                DocumentationManager documentationManager;
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (editor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                documentationManager.showJavaDocInfo(editor, file2, (hint = (documentationManager = DocumentationManager.getInstance(project)).getDocInfoHint()) != null || LookupManager.getActiveLookup(editor) == null);
            }

            public boolean startInWriteAction() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "editor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/documentation/actions/ShowQuickDocInfoAction$1";
                objectArray[2] = "invoke";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    protected boolean isValidForLookup() {
        return true;
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            ShowQuickDocInfoAction.$$$reportNull$$$0(0);
        }
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        presentation.setEnabled(false);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiElement element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (editor == null && element2 == null) {
            return;
        }
        if (LookupManager.getInstance(project).getActiveLookup() != null) {
            if (this.isValidForLookup()) {
                presentation.setEnabled(true);
            }
        } else {
            if (editor != null) {
                if (event.getData(EditorGutter.KEY) != null) {
                    return;
                }
                PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
                if (file2 == null && element2 == null) {
                    return;
                }
            }
            presentation.setEnabled(true);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowQuickDocInfoAction.$$$reportNull$$$0(1);
        }
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiElement element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (project != null && editor != null) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed(CODEASSISTS_QUICKJAVADOC_FEATURE);
            LookupImpl lookup2 = (LookupImpl)LookupManager.getInstance(project).getActiveLookup();
            if (lookup2 != null) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed(CODEASSISTS_QUICKJAVADOC_LOOKUP_FEATURE);
            }
            this.actionPerformedImpl(project, editor);
        } else if (project != null && element2 != null) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed(CODEASSISTS_QUICKJAVADOC_CTRLN_FEATURE);
            CommandProcessor.getInstance().executeCommand(project, () -> {
                DocumentationManager documentationManager;
                JBPopup hint = (documentationManager = DocumentationManager.getInstance(project)).getDocInfoHint();
                documentationManager.showJavaDocInfo(element2, null, hint != null, null);
            }, this.getCommandName(), null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/documentation/actions/ShowQuickDocInfoAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

