/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAsIntentionAdapter;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.psi.PsiElement;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class B
implements AnnotationBuilder {
    @NotNull
    private final AnnotationHolderImpl myHolder;
    private final String message;
    @NotNull
    private final PsiElement myCurrentElement;
    @NotNull
    private final HighlightSeverity severity;
    private TextRange range;
    private Boolean afterEndOfLine;
    private Boolean fileLevel;
    private GutterIconRenderer gutterIconRenderer;
    private ProblemGroup problemGroup;
    private TextAttributes enforcedAttributes;
    private TextAttributesKey textAttributes;
    private ProblemHighlightType highlightType;
    private Boolean needsUpdateOnTyping;
    private String tooltip;
    private List<FixB> fixes;
    private boolean created;
    private final Throwable myDebugCreationPlace;

    B(@NotNull AnnotationHolderImpl holder, @NotNull HighlightSeverity severity, String message, @NotNull PsiElement currentElement) {
        if (holder == null) {
            B.$$$reportNull$$$0(0);
        }
        if (severity == null) {
            B.$$$reportNull$$$0(1);
        }
        if (currentElement == null) {
            B.$$$reportNull$$$0(2);
        }
        this.myHolder = holder;
        this.severity = severity;
        this.message = message;
        this.myCurrentElement = currentElement;
        holder.annotationBuilderCreated(this);
        this.myDebugCreationPlace = ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isInternal() ? ThrowableInterner.intern((Throwable)new Throwable()) : null;
    }

    private void assertNotSet(Object o, String description) {
        if (o != null) {
            this.markNotAbandoned();
            throw new IllegalStateException(description + " was set already");
        }
    }

    private void markNotAbandoned() {
        this.created = true;
    }

    @NotNull
    public AnnotationBuilder withFix(@NotNull IntentionAction fix) {
        if (fix == null) {
            B.$$$reportNull$$$0(3);
        }
        AnnotationBuilder annotationBuilder = this.newFix(fix).registerFix();
        if (annotationBuilder == null) {
            B.$$$reportNull$$$0(4);
        }
        return annotationBuilder;
    }

    @NotNull
    public AnnotationBuilder.FixBuilder newFix(@NotNull IntentionAction fix) {
        if (fix == null) {
            B.$$$reportNull$$$0(5);
        }
        return new FixB(fix);
    }

    @NotNull
    public AnnotationBuilder.FixBuilder newLocalQuickFix(@NotNull LocalQuickFix fix, @NotNull ProblemDescriptor problemDescriptor) {
        if (fix == null) {
            B.$$$reportNull$$$0(6);
        }
        if (problemDescriptor == null) {
            B.$$$reportNull$$$0(7);
        }
        return new FixB((IntentionAction)new LocalQuickFixAsIntentionAdapter(fix, problemDescriptor));
    }

    @NotNull
    public AnnotationBuilder range(@NotNull TextRange range2) {
        if (range2 == null) {
            B.$$$reportNull$$$0(8);
        }
        this.assertNotSet(this.range, "range");
        TextRange currentElementRange = this.myCurrentElement.getTextRange();
        if (!currentElementRange.contains(range2)) {
            this.markNotAbandoned();
            throw new IllegalArgumentException("Range must be inside element being annotated: " + currentElementRange + "; but got: " + range2);
        }
        this.range = range2;
        B b = this;
        if (b == null) {
            B.$$$reportNull$$$0(9);
        }
        return b;
    }

    @NotNull
    public AnnotationBuilder range(@NotNull ASTNode element2) {
        if (element2 == null) {
            B.$$$reportNull$$$0(10);
        }
        AnnotationBuilder annotationBuilder = this.range(element2.getTextRange());
        if (annotationBuilder == null) {
            B.$$$reportNull$$$0(11);
        }
        return annotationBuilder;
    }

    @NotNull
    public AnnotationBuilder range(@NotNull PsiElement element2) {
        if (element2 == null) {
            B.$$$reportNull$$$0(12);
        }
        AnnotationBuilder annotationBuilder = this.range(element2.getTextRange());
        if (annotationBuilder == null) {
            B.$$$reportNull$$$0(13);
        }
        return annotationBuilder;
    }

    @NotNull
    public AnnotationBuilder afterEndOfLine() {
        this.assertNotSet(this.afterEndOfLine, "afterEndOfLine");
        this.afterEndOfLine = true;
        B b = this;
        if (b == null) {
            B.$$$reportNull$$$0(14);
        }
        return b;
    }

    @NotNull
    public AnnotationBuilder fileLevel() {
        this.assertNotSet(this.fileLevel, "fileLevel");
        this.fileLevel = true;
        B b = this;
        if (b == null) {
            B.$$$reportNull$$$0(15);
        }
        return b;
    }

    @NotNull
    public AnnotationBuilder gutterIconRenderer(@NotNull GutterIconRenderer gutterIconRenderer) {
        if (gutterIconRenderer == null) {
            B.$$$reportNull$$$0(16);
        }
        this.assertNotSet(this.gutterIconRenderer, "gutterIconRenderer");
        this.gutterIconRenderer = gutterIconRenderer;
        B b = this;
        if (b == null) {
            B.$$$reportNull$$$0(17);
        }
        return b;
    }

    @NotNull
    public AnnotationBuilder problemGroup(@NotNull ProblemGroup problemGroup) {
        if (problemGroup == null) {
            B.$$$reportNull$$$0(18);
        }
        this.assertNotSet(this.problemGroup, "problemGroup");
        this.problemGroup = problemGroup;
        B b = this;
        if (b == null) {
            B.$$$reportNull$$$0(19);
        }
        return b;
    }

    @NotNull
    public AnnotationBuilder enforcedTextAttributes(@NotNull TextAttributes enforcedAttributes) {
        if (enforcedAttributes == null) {
            B.$$$reportNull$$$0(20);
        }
        this.assertNotSet(this.enforcedAttributes, "enforcedAttributes");
        this.enforcedAttributes = enforcedAttributes;
        B b = this;
        if (b == null) {
            B.$$$reportNull$$$0(21);
        }
        return b;
    }

    @NotNull
    public AnnotationBuilder textAttributes(@NotNull TextAttributesKey textAttributes) {
        if (textAttributes == null) {
            B.$$$reportNull$$$0(22);
        }
        this.assertNotSet(this.textAttributes, "textAttributes");
        this.textAttributes = textAttributes;
        B b = this;
        if (b == null) {
            B.$$$reportNull$$$0(23);
        }
        return b;
    }

    @NotNull
    public AnnotationBuilder highlightType(@NotNull ProblemHighlightType highlightType) {
        if (highlightType == null) {
            B.$$$reportNull$$$0(24);
        }
        this.assertNotSet(this.highlightType, "highlightType");
        this.highlightType = highlightType;
        B b = this;
        if (b == null) {
            B.$$$reportNull$$$0(25);
        }
        return b;
    }

    @NotNull
    public AnnotationBuilder needsUpdateOnTyping() {
        AnnotationBuilder annotationBuilder = this.needsUpdateOnTyping(true);
        if (annotationBuilder == null) {
            B.$$$reportNull$$$0(26);
        }
        return annotationBuilder;
    }

    @NotNull
    public AnnotationBuilder needsUpdateOnTyping(boolean value2) {
        this.assertNotSet(this.needsUpdateOnTyping, "needsUpdateOnTyping");
        this.needsUpdateOnTyping = value2;
        B b = this;
        if (b == null) {
            B.$$$reportNull$$$0(27);
        }
        return b;
    }

    @NotNull
    public AnnotationBuilder tooltip(@NotNull String tooltip) {
        if (tooltip == null) {
            B.$$$reportNull$$$0(28);
        }
        this.assertNotSet(this.tooltip, "tooltip");
        this.tooltip = tooltip;
        B b = this;
        if (b == null) {
            B.$$$reportNull$$$0(29);
        }
        return b;
    }

    public void create() {
        if (this.created) {
            throw new IllegalStateException("Must not call .create() twice");
        }
        this.created = true;
        if (this.range == null) {
            this.range = this.myCurrentElement.getTextRange();
        }
        if (this.tooltip == null && this.message != null) {
            this.tooltip = XmlStringUtil.wrapInHtml((CharSequence)XmlStringUtil.escapeString((String)this.message));
        }
        Annotation annotation = new Annotation(this.range.getStartOffset(), this.range.getEndOffset(), this.severity, this.message, this.tooltip);
        if (this.needsUpdateOnTyping != null) {
            annotation.setNeedsUpdateOnTyping(this.needsUpdateOnTyping.booleanValue());
        }
        if (this.highlightType != null) {
            annotation.setHighlightType(this.highlightType);
        }
        if (this.textAttributes != null) {
            annotation.setTextAttributes(this.textAttributes);
        }
        if (this.enforcedAttributes != null) {
            annotation.setEnforcedTextAttributes(this.enforcedAttributes);
        }
        if (this.problemGroup != null) {
            annotation.setProblemGroup(this.problemGroup);
        }
        if (this.gutterIconRenderer != null) {
            annotation.setGutterIconRenderer(this.gutterIconRenderer);
        }
        if (this.fileLevel != null) {
            annotation.setFileLevelAnnotation(this.fileLevel.booleanValue());
        }
        if (this.afterEndOfLine != null) {
            annotation.setAfterEndOfLine(this.afterEndOfLine.booleanValue());
        }
        if (this.fixes != null) {
            for (FixB fb : this.fixes) {
                TextRange finalRange;
                IntentionAction fix = fb.fix;
                TextRange textRange = finalRange = fb.range == null ? this.range : fb.range;
                if (fb.batch != null && fb.batch.booleanValue()) {
                    B.registerBatchFix(annotation, fix, finalRange, fb.key);
                    continue;
                }
                if (fb.universal != null && fb.universal.booleanValue()) {
                    B.registerBatchFix(annotation, fix, finalRange, fb.key);
                    annotation.registerFix(fix, finalRange, fb.key);
                    continue;
                }
                annotation.registerFix(fix, finalRange, fb.key);
            }
        }
        this.myHolder.add(annotation);
        this.myHolder.queueToUpdateIncrementally();
        this.myHolder.annotationCreatedFrom(this);
    }

    private static <T extends IntentionAction & LocalQuickFix> void registerBatchFix(@NotNull Annotation annotation, @NotNull Object fix, @NotNull TextRange range2, HighlightDisplayKey key) {
        if (annotation == null) {
            B.$$$reportNull$$$0(30);
        }
        if (fix == null) {
            B.$$$reportNull$$$0(31);
        }
        if (range2 == null) {
            B.$$$reportNull$$$0(32);
        }
        annotation.registerBatchFix((IntentionAction)fix, range2, key);
    }

    void assertAnnotationCreated() {
        if (!this.created) {
            throw new IllegalStateException("Abandoned AnnotationBuilder - its 'create()' method was never called: " + this + (this.myDebugCreationPlace == null ? "" : "\nSee cause for the AnnotationBuilder creation stacktrace"), this.myDebugCreationPlace);
        }
    }

    private static String omitIfEmpty(Object o, String name) {
        return o == null ? "" : ", " + name + "=" + o;
    }

    public String toString() {
        return "Builder{message='" + this.message + '\'' + ", myCurrentElement=" + this.myCurrentElement + ", severity=" + this.severity + ", range=" + (this.range == null ? "(implicit)" + this.myCurrentElement.getTextRange() : this.range) + B.omitIfEmpty(this.afterEndOfLine, "afterEndOfLine") + B.omitIfEmpty(this.fileLevel, "fileLevel") + B.omitIfEmpty(this.gutterIconRenderer, "gutterIconRenderer") + B.omitIfEmpty(this.problemGroup, "problemGroup") + B.omitIfEmpty(this.enforcedAttributes, "enforcedAttributes") + B.omitIfEmpty(this.textAttributes, "textAttributes") + B.omitIfEmpty(this.highlightType, "highlightType") + B.omitIfEmpty(this.needsUpdateOnTyping, "needsUpdateOnTyping") + B.omitIfEmpty(this.tooltip, "tooltip") + B.omitIfEmpty(this.fixes, "fixes") + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentElement";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/B";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptor";
                break;
            }
            case 8: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gutterIconRenderer";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemGroup";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enforcedAttributes";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributes";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightType";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltip";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/B";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withFix";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "range";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "afterEndOfLine";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "fileLevel";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "gutterIconRenderer";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "problemGroup";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "enforcedTextAttributes";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "textAttributes";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "highlightType";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "needsUpdateOnTyping";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "tooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withFix";
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "newFix";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "newLocalQuickFix";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "range";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "gutterIconRenderer";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "problemGroup";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "enforcedTextAttributes";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "textAttributes";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "highlightType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "tooltip";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "registerBatchFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class FixB
    implements AnnotationBuilder.FixBuilder {
        @NotNull
        IntentionAction fix;
        TextRange range;
        HighlightDisplayKey key;
        Boolean batch;
        Boolean universal;

        FixB(IntentionAction fix) {
            if (fix == null) {
                FixB.$$$reportNull$$$0(0);
            }
            this.fix = fix;
        }

        @NotNull
        public AnnotationBuilder.FixBuilder range(@NotNull TextRange range2) {
            if (range2 == null) {
                FixB.$$$reportNull$$$0(1);
            }
            B.this.assertNotSet(this.range, "range");
            this.range = range2;
            FixB fixB = this;
            if (fixB == null) {
                FixB.$$$reportNull$$$0(2);
            }
            return fixB;
        }

        @NotNull
        public AnnotationBuilder.FixBuilder key(@NotNull HighlightDisplayKey key) {
            if (key == null) {
                FixB.$$$reportNull$$$0(3);
            }
            B.this.assertNotSet(this.key, "key");
            this.key = key;
            FixB fixB = this;
            if (fixB == null) {
                FixB.$$$reportNull$$$0(4);
            }
            return fixB;
        }

        @NotNull
        public AnnotationBuilder.FixBuilder batch() {
            B.this.assertNotSet(this.universal, "universal");
            B.this.assertNotSet(this.batch, "batch");
            this.assertLQF();
            this.batch = true;
            FixB fixB = this;
            if (fixB == null) {
                FixB.$$$reportNull$$$0(5);
            }
            return fixB;
        }

        private void assertLQF() {
            if (!(this.fix instanceof LocalQuickFix) && !(this.fix instanceof LocalQuickFixAsIntentionAdapter)) {
                B.this.markNotAbandoned();
                throw new IllegalArgumentException("Fix " + this.fix + " must be instance of LocalQuickFix to be registered as batch");
            }
        }

        @NotNull
        public AnnotationBuilder.FixBuilder universal() {
            B.this.assertNotSet(this.universal, "universal");
            B.this.assertNotSet(this.batch, "batch");
            this.assertLQF();
            this.universal = true;
            FixB fixB = this;
            if (fixB == null) {
                FixB.$$$reportNull$$$0(6);
            }
            return fixB;
        }

        @NotNull
        public AnnotationBuilder registerFix() {
            if (B.this.fixes == null) {
                B.this.fixes = new ArrayList();
            }
            B.this.fixes.add(this);
            B b = B.this;
            if (b == null) {
                FixB.$$$reportNull$$$0(7);
            }
            return b;
        }

        public String toString() {
            return this.fix + (this.range == null ? "" : " at " + this.range) + (this.batch == null ? "" : " batch") + (this.universal == null ? "" : " universal");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/B$FixB";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/B$FixB";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "range";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "key";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "batch";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "universal";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "registerFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "range";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "key";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

