/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.editorActions.SmartBackspaceMode;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.openapi.util.Disposer;
import com.intellij.serialization.SerializationException;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="CodeInsightSettings", storages={@Storage(value="editor.xml"), @Storage(value="editor.codeinsight.xml", deprecated=true)})
public class CodeInsightSettings
implements PersistentStateComponent<Element>,
Cloneable {
    private static final Logger LOG = Logger.getInstance(CodeInsightSettings.class);
    private final List<PropertyChangeListener> myListeners = new CopyOnWriteArrayList<PropertyChangeListener>();
    public boolean SHOW_EXTERNAL_ANNOTATIONS_INLINE = true;
    public boolean SHOW_INFERRED_ANNOTATIONS_INLINE;
    public boolean SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION;
    public boolean AUTO_POPUP_PARAMETER_INFO = true;
    public int PARAMETER_INFO_DELAY = 1000;
    public boolean AUTO_POPUP_JAVADOC_INFO;
    public int JAVADOC_INFO_DELAY = 1000;
    public boolean AUTO_POPUP_COMPLETION_LOOKUP = true;
    public int COMPLETION_CASE_SENSITIVE = 3;
    public static final int ALL = 1;
    public static final int NONE = 2;
    public static final int FIRST_LETTER = 3;
    @Deprecated
    public boolean SELECT_AUTOPOPUP_SUGGESTIONS_BY_CHARS;
    public boolean AUTOCOMPLETE_ON_CODE_COMPLETION = true;
    public boolean AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION = true;
    @Deprecated
    public boolean AUTOCOMPLETE_COMMON_PREFIX = true;
    public boolean SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO;
    @OptionTag(value="SMART_BACKSPACE")
    private int SMART_BACKSPACE = SmartBackspaceMode.AUTOINDENT.ordinal();
    public boolean SMART_INDENT_ON_ENTER = true;
    public boolean INSERT_BRACE_ON_ENTER = true;
    public boolean INSERT_SCRIPTLET_END_ON_ENTER = true;
    public boolean JAVADOC_STUB_ON_ENTER = true;
    public boolean SMART_END_ACTION = true;
    public boolean JAVADOC_GENERATE_CLOSING_TAG = true;
    public boolean SURROUND_SELECTION_ON_QUOTE_TYPED = true;
    public boolean AUTOINSERT_PAIR_BRACKET = true;
    public boolean AUTOINSERT_PAIR_QUOTE = true;
    public boolean REFORMAT_BLOCK_ON_RBRACE = true;
    public int REFORMAT_ON_PASTE = 3;
    public static final int NO_REFORMAT = 1;
    public static final int INDENT_BLOCK = 2;
    public static final int INDENT_EACH_LINE = 3;
    public static final int REFORMAT_BLOCK = 4;
    public boolean INDENT_TO_CARET_ON_PASTE;
    public int ADD_IMPORTS_ON_PASTE = 1;
    public static final int YES = 1;
    public static final int NO = 2;
    public static final int ASK = 3;
    public boolean HIGHLIGHT_BRACES = true;
    public boolean HIGHLIGHT_SCOPE;
    public boolean USE_INSTANCEOF_ON_EQUALS_PARAMETER;
    public boolean USE_ACCESSORS_IN_EQUALS_HASHCODE;
    public boolean HIGHLIGHT_IDENTIFIER_UNDER_CARET = true;
    public boolean OPTIMIZE_IMPORTS_ON_THE_FLY;
    public boolean ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY;
    public boolean ADD_MEMBER_IMPORTS_ON_THE_FLY = true;
    public boolean JSP_ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY;
    public boolean TAB_EXITS_BRACKETS_AND_QUOTES = true;
    @Property(surroundWithTag=false)
    @XCollection(elementName="EXCLUDED_PACKAGE", valueAttributeName="NAME")
    public String @NotNull [] EXCLUDED_PACKAGES = ArrayUtilRt.EMPTY_STRING_ARRAY;

    public static CodeInsightSettings getInstance() {
        return (CodeInsightSettings)ServiceManager.getService(CodeInsightSettings.class);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener2, Disposable parentDisposable) {
        this.myListeners.add(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.myListeners.remove(listener2));
    }

    @Nullable
    public CodeInsightSettings clone() {
        try {
            return (CodeInsightSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean isSelectAutopopupSuggestionsByChars() {
        return this.SELECT_AUTOPOPUP_SUGGESTIONS_BY_CHARS;
    }

    public void setSelectAutopopupSuggestionsByChars(boolean value2) {
        boolean oldValue = this.SELECT_AUTOPOPUP_SUGGESTIONS_BY_CHARS;
        if (oldValue != value2) {
            this.SELECT_AUTOPOPUP_SUGGESTIONS_BY_CHARS = value2;
            for (PropertyChangeListener listener2 : this.myListeners) {
                listener2.propertyChange(new PropertyChangeEvent(this, "SELECT_AUTOPOPUP_SUGGESTIONS_BY_CHARS", oldValue, value2));
            }
        }
    }

    @Transient
    @NotNull
    public SmartBackspaceMode getBackspaceMode() {
        SmartBackspaceMode[] values2 = SmartBackspaceMode.values();
        SmartBackspaceMode smartBackspaceMode = this.SMART_BACKSPACE >= 0 && this.SMART_BACKSPACE < values2.length ? values2[this.SMART_BACKSPACE] : SmartBackspaceMode.OFF;
        if (smartBackspaceMode == null) {
            CodeInsightSettings.$$$reportNull$$$0(0);
        }
        return smartBackspaceMode;
    }

    @Transient
    public void setBackspaceMode(@NotNull SmartBackspaceMode mode) {
        if (mode == null) {
            CodeInsightSettings.$$$reportNull$$$0(1);
        }
        this.SMART_BACKSPACE = mode.ordinal();
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            CodeInsightSettings.$$$reportNull$$$0(2);
        }
        this.setDefaults();
        try {
            XmlSerializer.deserializeInto((Element)state, (Object)this);
        }
        catch (SerializationException e) {
            LOG.info((Throwable)e);
        }
    }

    private void setDefaults() {
        try {
            ReflectionUtil.copyFields((Field[])CodeInsightSettings.class.getDeclaredFields(), (Object)new CodeInsightSettings(), (Object)this, (DifferenceFilter)new DifferenceFilter<Object>(null, null){

                public boolean isAccept(@NotNull Field field) {
                    if (field == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return !field.getName().equals("EXCLUDED_PACKAGES");
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/CodeInsightSettings$1", "isAccept"));
                }
            });
        }
        catch (Throwable e) {
            LOG.info(e);
        }
        this.EXCLUDED_PACKAGES = ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public Element getState() {
        Element element2 = new Element("state");
        this.writeExternal(element2);
        return element2;
    }

    public void writeExternal(@NotNull Element element2) {
        if (element2 == null) {
            CodeInsightSettings.$$$reportNull$$$0(3);
        }
        try {
            XmlSerializer.serializeObjectInto((Object)this, (Element)element2);
        }
        catch (SerializationException e) {
            LOG.info((Throwable)e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return ReflectionUtil.comparePublicNonFinalFields((Object)this, (Object)o);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/CodeInsightSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackspaceMode";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/CodeInsightSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setBackspaceMode";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

