/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorSchemeImporter;
import com.intellij.application.options.schemes.SchemeNameGenerator;
import com.intellij.ide.actions.QuickChangeColorSchemeAction;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.lang.LangBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.CustomFileDropHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.colors.impl.EmptyColorScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeFactory;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorColorSchemeDropHandler
extends CustomFileDropHandler {
    public static final String ADDED = "Color scheme added";

    @Override
    public boolean canHandle(@NotNull Transferable t, @Nullable Editor editor) {
        if (t == null) {
            EditorColorSchemeDropHandler.$$$reportNull$$$0(0);
        }
        return EditorColorSchemeDropHandler.getColorSchemeFile(t) != null;
    }

    private static VirtualFile getColorSchemeFile(@NotNull Transferable t) {
        List<File> list2;
        File io;
        if (t == null) {
            EditorColorSchemeDropHandler.$$$reportNull$$$0(1);
        }
        File file2 = io = (list2 = FileCopyPasteUtil.getFileList(t)) != null && list2.size() == 1 ? (File)ContainerUtil.getFirstItem(list2) : null;
        if (io == null || !StringUtil.endsWithIgnoreCase((String)io.getName(), (String)".icls")) {
            return null;
        }
        return VfsUtil.findFileByIoFile((File)io, (boolean)true);
    }

    @Override
    public boolean handleDrop(@NotNull Transferable t, @Nullable Editor editor, Project project) {
        if (t == null) {
            EditorColorSchemeDropHandler.$$$reportNull$$$0(2);
        }
        VirtualFile file2 = EditorColorSchemeDropHandler.getColorSchemeFile(t);
        assert (file2 != null);
        if (0 == Messages.showYesNoDialog((String)LangBundle.message((String)"message.would.you.like.to.install.and.apply.0.editor.color.scheme", (Object[])new Object[]{file2.getName()}), (String)LangBundle.message((String)"dialog.title.install.color.scheme", (Object[])new Object[0]), (String)LangBundle.message((String)"button.install", (Object[])new Object[0]), (String)LangBundle.message((String)"button.open.in.editor", (Object[])new Object[0]), null)) {
            try {
                ColorSchemeImporter importer = new ColorSchemeImporter();
                EditorColorsManager colorsManager = EditorColorsManager.getInstance();
                List names2 = ContainerUtil.map((Object[])colorsManager.getAllSchemes(), Scheme::getName);
                EditorColorsScheme imported = importer.importScheme(DefaultProjectFactory.getInstance().getDefaultProject(), file2, colorsManager.getGlobalScheme(), (SchemeFactory<EditorColorsScheme>)((SchemeFactory)name -> {
                    String preferredName = name != null ? name : "Unnamed";
                    String newName = SchemeNameGenerator.getUniqueName(preferredName, candidate -> names2.contains(candidate));
                    EditorColorsSchemeImpl newScheme = new EditorColorsSchemeImpl(EmptyColorScheme.INSTANCE);
                    newScheme.setName(newName);
                    newScheme.setDefaultMetaInfo(EmptyColorScheme.INSTANCE);
                    return newScheme;
                }));
                if (imported != null) {
                    colorsManager.addColorsScheme(imported);
                    String message = importer.getAdditionalImportInfo((Scheme)imported);
                    if (message == null) {
                        message = ApplicationBundle.message((String)"settings.editor.scheme.import.success", (Object[])new Object[]{file2.getPresentableUrl(), imported.getName()});
                    }
                    colorsManager.setGlobalScheme(imported);
                    Notification notification = new Notification("", ADDED, message, NotificationType.INFORMATION);
                    QuickChangeColorSchemeAction.changeLafIfNecessary(imported, () -> new Alarm().addRequest(() -> Notifications.Bus.notify((Notification)notification, (Project)project), 300));
                }
            }
            catch (SchemeImportException e) {
                String title = e.isWarning() ? ADDED : "Color scheme import failed";
                NotificationType type = e.isWarning() ? NotificationType.WARNING : NotificationType.ERROR;
                Notification notification = new Notification("", title, e.getMessage(), type);
                notification.notify(project);
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "t";
        objectArray2[1] = "com/intellij/application/options/colors/EditorColorSchemeDropHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canHandle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getColorSchemeFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "handleDrop";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

