/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.actions;

import com.intellij.copyright.CopyrightBundle;
import com.intellij.copyright.CopyrightManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.maddyhome.idea.copyright.actions.UpdateCopyrightProcessor;
import com.maddyhome.idea.copyright.ui.CopyrightProjectConfigurable;
import com.maddyhome.idea.copyright.util.FileTypeUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateCopyrightAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GenerateCopyrightAction.$$$reportNull$$$0(0);
        }
        Presentation presentation = e.getPresentation();
        DataContext context = e.getDataContext();
        Project project = e.getProject();
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        PsiFile file = GenerateCopyrightAction.getFile(context, project);
        if (file == null || !FileTypeUtil.isSupportedFile(file)) {
            presentation.setEnabled(false);
        }
    }

    @Nullable
    private static PsiFile getFile(DataContext context, Project project) {
        Editor editor;
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        if (file == null && (editor = (Editor)CommonDataKeys.EDITOR.getData(context)) != null) {
            file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        }
        return file;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GenerateCopyrightAction.$$$reportNull$$$0(1);
        }
        DataContext context = e.getDataContext();
        Project project = e.getProject();
        assert (project != null);
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiFile file = GenerateCopyrightAction.getFile(context, project);
        assert (file != null);
        if (CopyrightManager.getInstance(project).getCopyrightOptions(file) == null) {
            if (Messages.showOkCancelDialog((Project)project, (String)CopyrightBundle.message("dialog.message.no.copyright.configured", new Object[0]), (String)CopyrightBundle.message("dialog.title.no.copyright.available", new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
                ShowSettingsUtil.getInstance().showSettingsDialog(project, new CopyrightProjectConfigurable(project).getDisplayName());
            } else {
                return;
            }
        }
        new UpdateCopyrightProcessor(project, module, file).run();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/maddyhome/idea/copyright/actions/GenerateCopyrightAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

