/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ingest;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import joptsimple.AbstractOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;

final class JsUtil {
    private static final String[] SCRIPTS = new String[]{"shared", "date", "grok", "geoip", "gsub", "pipeline", "convert", "append", "json", "rename", "lowercase", "set"};

    private JsUtil() {
    }

    public static ScriptEngine engine() {
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("nashorn");
        try {
            for (String file : SCRIPTS) {
                JsUtil.add(engine, String.format("/ingest-%s.js", file));
            }
        }
        catch (IOException | ScriptException ex) {
            throw new IllegalStateException(ex);
        }
        return engine;
    }

    public static void convert(String[] args, String jsFunc) throws ScriptException, NoSuchMethodException {
        OptionParser parser = new OptionParser();
        AbstractOptionSpec input = parser.accepts("input", "Input JSON file location URI. Only supports 'file://' as URI schema.").withRequiredArg().ofType(URI.class).required().forHelp();
        AbstractOptionSpec output = parser.accepts("output", "Output Logstash DSL file location URI. Only supports 'file://' as URI schema.").withRequiredArg().ofType(URI.class).required().forHelp();
        AbstractOptionSpec appendStdio = parser.accepts("append-stdio", "Flag to append stdin and stdout as outputs instead of the default ES output.").forHelp();
        try {
            OptionSet options;
            try {
                options = parser.parse(args);
            }
            catch (OptionException ex) {
                parser.printHelpOn(System.out);
                throw ex;
            }
            ScriptEngine engine = JsUtil.engine();
            Files.write(Paths.get((URI)options.valueOf(output)), ((String)((Invocable)((Object)engine)).invokeFunction(jsFunc, JsUtil.input((URI)options.valueOf(input)), options.has(appendStdio))).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static String input(URI uri) throws IOException {
        if ("file".equals(uri.getScheme())) {
            return new String(Files.readAllBytes(Paths.get(uri)), StandardCharsets.UTF_8);
        }
        throw new IllegalArgumentException("--input must be of schema file://");
    }

    private static void add(ScriptEngine engine, String file) throws IOException, ScriptException {
        try (InputStreamReader reader = new InputStreamReader(JsUtil.class.getResourceAsStream(file));){
            engine.eval(reader);
        }
    }
}

