/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.log;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;

@JRubyClass(name={"SlowLogger"})
public class SlowLoggerExt
extends RubyObject {
    private static final long serialVersionUID = 1L;
    private static final RubySymbol PLUGIN_PARAMS = RubyUtil.RUBY.newSymbol("plugin_params");
    private static final RubySymbol TOOK_IN_NANOS = RubyUtil.RUBY.newSymbol("took_in_nanos");
    private static final RubySymbol TOOK_IN_MILLIS = RubyUtil.RUBY.newSymbol("took_in_millis");
    private static final RubySymbol EVENT = RubyUtil.RUBY.newSymbol("event");
    private static final RubyNumeric NANO_TO_MILLI = RubyUtil.RUBY.newFixnum(1000000);
    private Logger slowLogger;
    private long warnThreshold;
    private long infoThreshold;
    private long debugThreshold;
    private long traceThreshold;

    public SlowLoggerExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @JRubyMethod(required=5)
    public SlowLoggerExt initialize(ThreadContext context, IRubyObject[] args) {
        String loggerName = args[0].asJavaString();
        this.slowLogger = LogManager.getLogger((String)("slowlog." + loggerName));
        this.warnThreshold = ((RubyNumeric)args[1]).getLongValue();
        this.infoThreshold = ((RubyNumeric)args[2]).getLongValue();
        this.debugThreshold = ((RubyNumeric)args[3]).getLongValue();
        this.traceThreshold = ((RubyNumeric)args[4]).getLongValue();
        return this;
    }

    private RubyHash asData(ThreadContext context, IRubyObject pluginParams, IRubyObject event, IRubyObject durationNanos) {
        RubyHash data = RubyHash.newHash((Ruby)context.runtime);
        data.put((Object)PLUGIN_PARAMS, (Object)pluginParams);
        data.put((Object)TOOK_IN_NANOS, (Object)durationNanos);
        data.put((Object)TOOK_IN_MILLIS, (Object)((RubyNumeric)durationNanos).div(context, (IRubyObject)NANO_TO_MILLI));
        data.put((Object)EVENT, (Object)event.callMethod(context, "to_json"));
        return data;
    }

    @JRubyMethod(name={"on_event"}, required=4)
    public IRubyObject onEvent(ThreadContext context, IRubyObject[] args) {
        String message = args[0].asJavaString();
        long eventDurationNanos = ((RubyNumeric)args[3]).getLongValue();
        if (this.warnThreshold >= 0L && eventDurationNanos > this.warnThreshold) {
            this.slowLogger.warn(message, (Object)this.asData(context, args[1], args[2], args[3]));
        } else if (this.infoThreshold >= 0L && eventDurationNanos > this.infoThreshold) {
            this.slowLogger.info(message, (Object)this.asData(context, args[1], args[2], args[3]));
        } else if (this.debugThreshold >= 0L && eventDurationNanos > this.debugThreshold) {
            this.slowLogger.debug(message, (Object)this.asData(context, args[1], args[2], args[3]));
        } else if (this.traceThreshold >= 0L && eventDurationNanos > this.traceThreshold) {
            this.slowLogger.trace(message, (Object)this.asData(context, args[1], args[2], args[3]));
        }
        return context.nil;
    }
}

