/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import org.bouncycastle.math.ec.rfc8032.Ed448;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsStreamVerifier;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsVerifier;

public class BcTlsEd448Verifier
extends BcTlsVerifier {
    public BcTlsEd448Verifier(BcTlsCrypto bcTlsCrypto, Ed448PublicKeyParameters ed448PublicKeyParameters) {
        super(bcTlsCrypto, (AsymmetricKeyParameter)ed448PublicKeyParameters);
    }

    public boolean verifyRawSignature(DigitallySigned digitallySigned, byte[] byArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    public TlsStreamVerifier getStreamVerifier(DigitallySigned digitallySigned) {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
        if (signatureAndHashAlgorithm == null || signatureAndHashAlgorithm.getSignature() != 8 || signatureAndHashAlgorithm.getHash() != 8) {
            throw new IllegalStateException();
        }
        final byte[] byArray = digitallySigned.getSignature();
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        return new TlsStreamVerifier(){

            public OutputStream getOutputStream() {
                return byteArrayOutputStream;
            }

            public boolean isVerified() throws IOException {
                byte[] byArray4 = new byte[57];
                ((Ed448PublicKeyParameters)BcTlsEd448Verifier.this.publicKey).encode(byArray4, 0);
                byte[] byArray2 = TlsUtils.EMPTY_BYTES;
                byte[] byArray3 = byteArrayOutputStream.toByteArray();
                return Ed448.verify((byte[])byArray, (int)0, (byte[])byArray4, (int)0, (byte[])byArray2, (byte[])byArray3, (int)0, (int)byArray3.length);
            }
        };
    }
}

