/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.FileDescriptor;
import java.nio.file.attribute.FileTime;
import jnr.posix.FileStat;
import jnr.posix.NanosecondFileStat;
import jnr.posix.util.Platform;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.StringSupport;

@JRubyClass(name={"File::Stat"}, include={"Comparable"})
public class RubyFileStat
extends RubyObject {
    private static final long serialVersionUID = 1L;
    private static final int S_IRUGO = 292;
    private static final int S_IWUGO = 146;
    private static final int S_IXUGO = 73;
    public static final int BILLION = 1000000000;
    private FileResource file;
    private FileStat stat;
    private static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyFileStat(runtime2, klass);
        }
    };

    private void checkInitialized() {
        if (this.stat == null) {
            throw this.getRuntime().newTypeError("uninitialized File::Stat");
        }
    }

    public static RubyClass createFileStatClass(Ruby runtime2) {
        RubyClass fileStatClass = runtime2.getFile().defineClassUnder("Stat", runtime2.getObject(), ALLOCATOR);
        runtime2.setFileStat(fileStatClass);
        fileStatClass.includeModule(runtime2.getModule("Comparable"));
        fileStatClass.defineAnnotatedMethods(RubyFileStat.class);
        return fileStatClass;
    }

    protected RubyFileStat(Ruby runtime2, RubyClass clazz) {
        super(runtime2, clazz);
    }

    public static RubyFileStat newFileStat(Ruby runtime2, String filename2, boolean lstat2) {
        RubyFileStat stat2 = new RubyFileStat(runtime2, runtime2.getFileStat());
        stat2.setup(filename2, lstat2);
        return stat2;
    }

    public static RubyFileStat newFileStat(Ruby runtime2, FileDescriptor descriptor) {
        RubyFileStat stat2 = new RubyFileStat(runtime2, runtime2.getFileStat());
        stat2.setup(descriptor);
        return stat2;
    }

    public static RubyFileStat newFileStat(Ruby runtime2, int fileno2) {
        RubyFileStat stat2 = new RubyFileStat(runtime2, runtime2.getFileStat());
        stat2.setup(fileno2);
        return stat2;
    }

    private void setup(FileDescriptor descriptor) {
        this.stat = this.getRuntime().getPosix().fstat(descriptor);
    }

    private void setup(int fileno2) {
        this.stat = this.getRuntime().getPosix().fstat(fileno2);
    }

    private void setup(String filename2, boolean lstat2) {
        Ruby runtime2 = this.getRuntime();
        if (Platform.IS_WINDOWS && filename2.length() == 2 && filename2.charAt(1) == ':' && Character.isLetter(filename2.charAt(0))) {
            filename2 = filename2 + '/';
        }
        this.file = JRubyFile.createResource(runtime2, filename2);
        FileStat fileStat = this.stat = lstat2 ? this.file.lstat() : this.file.stat();
        if (this.stat == null) {
            throw runtime2.newErrnoFromInt(this.file.errno(), filename2);
        }
    }

    public IRubyObject initialize(IRubyObject fname, Block unusedBlock) {
        return this.initialize19(fname, unusedBlock);
    }

    @JRubyMethod(name={"initialize"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize19(IRubyObject fname, Block unusedBlock) {
        Ruby runtime2 = this.getRuntime();
        ThreadContext context = runtime2.getCurrentContext();
        RubyString path2 = StringSupport.checkEmbeddedNulls(runtime2, RubyFile.get_path(context, fname));
        this.setup(path2.convertToString().toString(), false);
        return this;
    }

    @JRubyMethod(name={"atime"})
    public IRubyObject atime() {
        this.checkInitialized();
        if (this.stat instanceof NanosecondFileStat) {
            return RubyTime.newTimeFromNanoseconds(this.getRuntime(), this.stat.atime() * 1000000000L + ((NanosecondFileStat)this.stat).aTimeNanoSecs());
        }
        return this.getRuntime().newTime(this.stat.atime() * 1000L);
    }

    @JRubyMethod(name={"blksize"})
    public IRubyObject blockSize(ThreadContext context) {
        this.checkInitialized();
        if (Platform.IS_WINDOWS) {
            return context.nil;
        }
        return context.runtime.newFixnum(this.stat.blockSize());
    }

    @Deprecated
    public RubyFixnum blksize() {
        this.checkInitialized();
        return this.getRuntime().newFixnum(this.stat.blockSize());
    }

    @JRubyMethod(name={"blockdev?"})
    public IRubyObject blockdev_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isBlockDev());
    }

    @JRubyMethod(name={"blocks"})
    public IRubyObject blocks() {
        this.checkInitialized();
        if (Platform.IS_WINDOWS) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(this.stat.blocks());
    }

    @JRubyMethod(name={"chardev?"})
    public IRubyObject chardev_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isCharDev());
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject cmp(IRubyObject other) {
        long time2;
        this.checkInitialized();
        if (!(other instanceof RubyFileStat)) {
            return this.getRuntime().getNil();
        }
        long time1 = this.stat.mtime();
        if (time1 == (time2 = ((RubyFileStat)other).stat.mtime())) {
            return this.getRuntime().newFixnum(0);
        }
        if (time1 < time2) {
            return this.getRuntime().newFixnum(-1);
        }
        return this.getRuntime().newFixnum(1);
    }

    @JRubyMethod(name={"ctime"})
    public IRubyObject ctime() {
        this.checkInitialized();
        if (this.stat instanceof NanosecondFileStat) {
            return RubyTime.newTimeFromNanoseconds(this.getRuntime(), this.stat.ctime() * 1000000000L + ((NanosecondFileStat)this.stat).cTimeNanoSecs());
        }
        return this.getRuntime().newTime(this.stat.ctime() * 1000L);
    }

    @JRubyMethod(name={"birthtime"})
    public IRubyObject birthtime() {
        this.checkInitialized();
        FileTime btime = null;
        if (this.file == null || (btime = RubyFile.getBirthtimeWithNIO(this.file.absolutePath())) == null) {
            return this.ctime();
        }
        return this.getRuntime().newTime(btime.toMillis());
    }

    @JRubyMethod(name={"dev"})
    public IRubyObject dev() {
        this.checkInitialized();
        return this.getRuntime().newFixnum(this.stat.dev());
    }

    @JRubyMethod(name={"dev_major"})
    public IRubyObject devMajor() {
        this.checkInitialized();
        if (Platform.IS_WINDOWS) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(this.stat.major(this.stat.dev()));
    }

    @JRubyMethod(name={"dev_minor"})
    public IRubyObject devMinor() {
        this.checkInitialized();
        if (Platform.IS_WINDOWS) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(this.stat.minor(this.stat.dev()));
    }

    @JRubyMethod(name={"directory?"})
    public RubyBoolean directory_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isDirectory());
    }

    @JRubyMethod(name={"executable?"})
    public IRubyObject executable_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isExecutable());
    }

    @JRubyMethod(name={"executable_real?"})
    public IRubyObject executableReal_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isExecutableReal());
    }

    @JRubyMethod(name={"file?"})
    public RubyBoolean file_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isFile());
    }

    @JRubyMethod(name={"ftype"})
    public RubyString ftype() {
        this.checkInitialized();
        return this.getRuntime().newString(this.stat.ftype());
    }

    @JRubyMethod(name={"gid"})
    public IRubyObject gid() {
        this.checkInitialized();
        return this.getRuntime().newFixnum(this.stat.gid());
    }

    @JRubyMethod(name={"grpowned?"})
    public IRubyObject group_owned_p() {
        this.checkInitialized();
        if (Platform.IS_WINDOWS) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().newBoolean(this.stat.isGroupOwned());
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject original) {
        if (!(original instanceof RubyFileStat)) {
            throw this.getRuntime().newTypeError("wrong argument class");
        }
        this.checkFrozen();
        RubyFileStat originalFileStat = (RubyFileStat)original;
        this.file = originalFileStat.file;
        this.stat = originalFileStat.stat;
        return this;
    }

    @JRubyMethod(name={"ino"})
    public IRubyObject ino() {
        this.checkInitialized();
        return this.metaClass.runtime.newFixnum(this.stat.ino());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        StringBuilder buf = new StringBuilder("#<");
        buf.append(this.getMetaClass().getRealClass().getName());
        if (this.stat == null) {
            buf.append(": uninitialized");
        } else {
            ThreadContext context = this.metaClass.runtime.getCurrentContext();
            buf.append(' ');
            try {
                buf.append("dev=0x").append(Long.toHexString(this.stat.dev()));
            }
            catch (Exception exception2) {
            }
            finally {
                buf.append(", ");
            }
            try {
                buf.append("ino=").append(this.stat.ino());
            }
            catch (Exception exception3) {
            }
            finally {
                buf.append(", ");
            }
            buf.append("mode=0").append(Integer.toOctalString(this.stat.mode())).append(", ");
            try {
                buf.append("nlink=").append(this.stat.nlink());
            }
            catch (Exception exception4) {
            }
            finally {
                buf.append(", ");
            }
            try {
                buf.append("uid=").append(this.stat.uid());
            }
            catch (Exception exception5) {
            }
            finally {
                buf.append(", ");
            }
            try {
                buf.append("gid=").append(this.stat.gid());
            }
            catch (Exception exception6) {
            }
            finally {
                buf.append(", ");
            }
            try {
                buf.append("rdev=0x").append(Long.toHexString(this.stat.rdev()));
            }
            catch (Exception exception7) {
            }
            finally {
                buf.append(", ");
            }
            buf.append("size=").append(this.sizeInternal()).append(", ");
            try {
                buf.append("blksize=").append(this.blockSize(context).inspect().toString());
            }
            catch (Exception exception8) {
            }
            finally {
                buf.append(", ");
            }
            try {
                buf.append("blocks=").append(this.blocks().inspect().toString());
            }
            catch (Exception exception9) {
            }
            finally {
                buf.append(", ");
            }
            buf.append("atime=").append(this.atime()).append(", ");
            buf.append("mtime=").append(this.mtime()).append(", ");
            buf.append("ctime=").append(this.ctime());
            if (Platform.IS_BSD || Platform.IS_MAC) {
                buf.append(", ").append("birthtime=").append(this.birthtime());
            }
        }
        buf.append('>');
        return this.getRuntime().newString(buf.toString());
    }

    @JRubyMethod(name={"uid"})
    public IRubyObject uid() {
        this.checkInitialized();
        return this.getRuntime().newFixnum(this.stat.uid());
    }

    @JRubyMethod(name={"mode"})
    public IRubyObject mode() {
        this.checkInitialized();
        return this.getRuntime().newFixnum(this.stat.mode());
    }

    @JRubyMethod(name={"mtime"})
    public IRubyObject mtime() {
        this.checkInitialized();
        if (this.stat instanceof NanosecondFileStat) {
            return RubyTime.newTimeFromNanoseconds(this.getRuntime(), this.stat.mtime() * 1000000000L + ((NanosecondFileStat)this.stat).mTimeNanoSecs());
        }
        return this.getRuntime().newTime(this.stat.mtime() * 1000L);
    }

    public IRubyObject mtimeEquals(IRubyObject other) {
        boolean equal;
        FileStat otherStat = RubyFileStat.newFileStat((Ruby)this.getRuntime(), (String)other.convertToString().toString(), (boolean)false).stat;
        boolean bl = equal = this.stat.mtime() == otherStat.mtime();
        if (this.stat instanceof NanosecondFileStat && otherStat instanceof NanosecondFileStat) {
            equal = equal && ((NanosecondFileStat)this.stat).mTimeNanoSecs() == ((NanosecondFileStat)otherStat).mTimeNanoSecs();
        }
        return this.getRuntime().newBoolean(equal);
    }

    public IRubyObject mtimeGreaterThan(IRubyObject other) {
        FileStat otherStat = RubyFileStat.newFileStat((Ruby)this.getRuntime(), (String)other.convertToString().toString(), (boolean)false).stat;
        boolean gt = this.stat instanceof NanosecondFileStat && otherStat instanceof NanosecondFileStat ? this.stat.mtime() * 1000000000L + ((NanosecondFileStat)this.stat).mTimeNanoSecs() > otherStat.mtime() * 1000000000L + ((NanosecondFileStat)otherStat).mTimeNanoSecs() : this.stat.mtime() > otherStat.mtime();
        return this.getRuntime().newBoolean(gt);
    }

    public IRubyObject mtimeLessThan(IRubyObject other) {
        FileStat otherStat = RubyFileStat.newFileStat((Ruby)this.getRuntime(), (String)other.convertToString().toString(), (boolean)false).stat;
        boolean lt = this.stat instanceof NanosecondFileStat && otherStat instanceof NanosecondFileStat ? this.stat.mtime() * 1000000000L + ((NanosecondFileStat)this.stat).mTimeNanoSecs() < otherStat.mtime() * 1000000000L + ((NanosecondFileStat)otherStat).mTimeNanoSecs() : this.stat.mtime() < otherStat.mtime();
        return this.getRuntime().newBoolean(lt);
    }

    @JRubyMethod(name={"nlink"})
    public IRubyObject nlink() {
        this.checkInitialized();
        return this.getRuntime().newFixnum(this.stat.nlink());
    }

    @JRubyMethod(name={"owned?"})
    public IRubyObject owned_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isOwned());
    }

    @JRubyMethod(name={"pipe?"})
    public IRubyObject pipe_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isNamedPipe());
    }

    @JRubyMethod(name={"rdev"})
    public IRubyObject rdev() {
        this.checkInitialized();
        return this.getRuntime().newFixnum(this.stat.rdev());
    }

    @JRubyMethod(name={"rdev_major"})
    public IRubyObject rdevMajor() {
        this.checkInitialized();
        if (Platform.IS_WINDOWS) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(this.stat.major(this.stat.rdev()));
    }

    @JRubyMethod(name={"rdev_minor"})
    public IRubyObject rdevMinor() {
        this.checkInitialized();
        if (Platform.IS_WINDOWS) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(this.stat.minor(this.stat.rdev()));
    }

    @JRubyMethod(name={"readable?"})
    public IRubyObject readable_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isReadable());
    }

    @JRubyMethod(name={"readable_real?"})
    public IRubyObject readableReal_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isReadableReal());
    }

    @JRubyMethod(name={"setgid?"})
    public IRubyObject setgid_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isSetgid());
    }

    @JRubyMethod(name={"setuid?"})
    public IRubyObject setuid_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isSetuid());
    }

    private long sizeInternal() {
        this.checkInitialized();
        if (Platform.IS_WINDOWS && this.file != null) {
            try {
                return this.file.length();
            }
            catch (SecurityException ex) {
                return 0L;
            }
        }
        return this.stat.st_size();
    }

    @JRubyMethod(name={"size"})
    public IRubyObject size() {
        return this.getRuntime().newFixnum(this.sizeInternal());
    }

    @JRubyMethod(name={"size?"})
    public IRubyObject size_p() {
        long size2 = this.sizeInternal();
        if (size2 == 0L) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(size2);
    }

    @JRubyMethod(name={"socket?"})
    public IRubyObject socket_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isSocket());
    }

    @JRubyMethod(name={"sticky?"})
    public IRubyObject sticky_p() {
        this.checkInitialized();
        Ruby runtime2 = this.getRuntime();
        if (runtime2.getPosix().isNative()) {
            return runtime2.newBoolean(this.stat.isSticky());
        }
        return runtime2.getNil();
    }

    @JRubyMethod(name={"symlink?"})
    public IRubyObject symlink_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isSymlink());
    }

    @JRubyMethod(name={"writable?"})
    public IRubyObject writable_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isWritable());
    }

    @JRubyMethod(name={"writable_real?"})
    public IRubyObject writableReal_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isWritableReal());
    }

    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isEmpty());
    }

    @JRubyMethod(name={"world_readable?"})
    public IRubyObject worldReadable(ThreadContext context) {
        return this.getWorldMode(context, 4);
    }

    @JRubyMethod(name={"world_writable?"})
    public IRubyObject worldWritable(ThreadContext context) {
        return this.getWorldMode(context, 2);
    }

    private IRubyObject getWorldMode(ThreadContext context, int mode2) {
        this.checkInitialized();
        if ((this.stat.mode() & mode2) == mode2) {
            return RubyNumeric.int2fix(context.runtime, this.stat.mode() & 0x1FF);
        }
        return context.nil;
    }
}

