/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util.csv.opencsv;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import liquibase.util.csv.opencsv.CSVIterator;
import liquibase.util.csv.opencsv.CSVParser;
import liquibase.util.csv.opencsv.stream.reader.LineReader;

public class CSVReader
implements Closeable,
Iterable<String[]> {
    public static final boolean DEFAULT_KEEP_CR = false;
    public static final boolean DEFAULT_VERIFY_READER = true;
    public static final int DEFAULT_SKIP_LINES = 0;
    public static final int READ_AHEAD_LIMIT = 2;
    private CSVParser parser;
    private int skipLines;
    private BufferedReader br;
    private LineReader lineReader;
    private boolean hasNext = true;
    private boolean linesSkiped;
    private boolean keepCR;
    private boolean verifyReader;
    private long linesRead = 0L;
    private long recordsRead = 0L;

    public CSVReader(Reader reader) {
        this(reader, ',', '\"', '\\');
    }

    public CSVReader(Reader reader, char separator) {
        this(reader, separator, '\"', '\\');
    }

    public CSVReader(Reader reader, char separator, char quotechar) {
        this(reader, separator, quotechar, '\\', 0, false);
    }

    public CSVReader(Reader reader, char separator, char quotechar, boolean strictQuotes) {
        this(reader, separator, quotechar, '\\', 0, strictQuotes);
    }

    public CSVReader(Reader reader, char separator, char quotechar, char escape) {
        this(reader, separator, quotechar, escape, 0, false);
    }

    public CSVReader(Reader reader, char separator, char quotechar, int line) {
        this(reader, separator, quotechar, '\\', line, false);
    }

    public CSVReader(Reader reader, char separator, char quotechar, char escape, int line) {
        this(reader, separator, quotechar, escape, line, false);
    }

    public CSVReader(Reader reader, char separator, char quotechar, char escape, int line, boolean strictQuotes) {
        this(reader, separator, quotechar, escape, line, strictQuotes, false);
    }

    public CSVReader(Reader reader, char separator, char quotechar, char escape, int line, boolean strictQuotes, boolean ignoreLeadingWhiteSpace) {
        this(reader, line, new CSVParser(separator, quotechar, escape, strictQuotes, ignoreLeadingWhiteSpace));
    }

    public CSVReader(Reader reader, char separator, char quotechar, char escape, int line, boolean strictQuotes, boolean ignoreLeadingWhiteSpace, boolean keepCR) {
        this(reader, line, new CSVParser(separator, quotechar, escape, strictQuotes, ignoreLeadingWhiteSpace), keepCR, true);
    }

    public CSVReader(Reader reader, int line, CSVParser csvParser) {
        this(reader, line, csvParser, false, true);
    }

    CSVReader(Reader reader, int line, CSVParser csvParser, boolean keepCR, boolean verifyReader) {
        this.br = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.lineReader = new LineReader(this.br, keepCR);
        this.skipLines = line;
        this.parser = csvParser;
        this.keepCR = keepCR;
        this.verifyReader = verifyReader;
    }

    public CSVParser getParser() {
        return this.parser;
    }

    public int getSkipLines() {
        return this.skipLines;
    }

    public boolean keepCarriageReturns() {
        return this.keepCR;
    }

    public List<String[]> readAll() throws IOException {
        ArrayList<String[]> allElements = new ArrayList<String[]>();
        while (this.hasNext) {
            String[] nextLineAsTokens = this.readNext();
            if (nextLineAsTokens == null) continue;
            allElements.add(nextLineAsTokens);
        }
        return allElements;
    }

    public String[] readNext() throws IOException {
        String[] result = null;
        do {
            String nextLine = this.getNextLine();
            if (!this.hasNext) {
                return this.validateResult(result);
            }
            String[] r = this.parser.parseLineMulti(nextLine);
            if (r.length <= 0) continue;
            result = result == null ? r : this.combineResultsFromMultipleReads(result, r);
        } while (this.parser.isPending());
        return this.validateResult(result);
    }

    protected String[] validateResult(String[] result) {
        if (result != null) {
            ++this.recordsRead;
        }
        return result;
    }

    protected String[] combineResultsFromMultipleReads(String[] buffer, String[] lastRead) {
        String[] t = new String[buffer.length + lastRead.length];
        System.arraycopy(buffer, 0, t, 0, buffer.length);
        System.arraycopy(lastRead, 0, t, buffer.length, lastRead.length);
        return t;
    }

    protected String getNextLine() throws IOException {
        String nextLine;
        if (this.isClosed()) {
            this.hasNext = false;
            return null;
        }
        if (!this.linesSkiped) {
            for (int i = 0; i < this.skipLines; ++i) {
                this.lineReader.readLine();
                ++this.linesRead;
            }
            this.linesSkiped = true;
        }
        if ((nextLine = this.lineReader.readLine()) == null) {
            this.hasNext = false;
        } else {
            ++this.linesRead;
        }
        return this.hasNext ? nextLine : null;
    }

    private boolean isClosed() {
        if (!this.verifyReader) {
            return false;
        }
        try {
            this.br.mark(2);
            int nextByte = this.br.read();
            this.br.reset();
            return nextByte == -1;
        }
        catch (IOException e) {
            return true;
        }
    }

    @Override
    public void close() throws IOException {
        this.br.close();
    }

    @Override
    public Iterator<String[]> iterator() {
        try {
            return new CSVIterator(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean verifyReader() {
        return this.verifyReader;
    }

    public long getLinesRead() {
        return this.linesRead;
    }

    public long getRecordsRead() {
        return this.recordsRead;
    }
}

