"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visualization = void 0;

var _chrome = _interopRequireDefault(require("ui/chrome"));

var _react = _interopRequireDefault(require("react"));

var _reactDom = require("react-dom");

var _vis = require("../../../../ui/public/visualize/loader/vis");

var _components = require("../../../visualizations/public/np_ready/public/components");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
// @ts-ignore
var visualization = function visualization() {
  return {
    name: 'visualization',
    displayName: 'visualization',
    reuseDomNode: true,
    render: function render(domNode, config, handlers) {
      var visData, visConfig, params, visType, $injector, $rootScope, uiState, listenOnChange;
      return regeneratorRuntime.async(function render$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              visData = config.visData, visConfig = config.visConfig, params = config.params;
              visType = config.visType || visConfig.type;
              _context.next = 4;
              return regeneratorRuntime.awrap(_chrome.default.dangerouslyGetActiveInjector());

            case 4:
              $injector = _context.sent;
              $rootScope = $injector.get('$rootScope');

              if (handlers.vis) {
                // special case in visualize, we need to render first (without executing the expression), for maps to work
                if (visConfig) {
                  $rootScope.$apply(function () {
                    handlers.vis.setCurrentState({
                      type: visType,
                      params: visConfig,
                      title: handlers.vis.title
                    });
                  });
                }
              } else {
                handlers.vis = new _vis.Vis({
                  type: visType,
                  params: visConfig
                });
              }

              handlers.vis.eventsSubject = {
                next: handlers.event
              };
              uiState = handlers.uiState || handlers.vis.getUiState();
              handlers.onDestroy(function () {
                (0, _reactDom.unmountComponentAtNode)(domNode);
              });
              listenOnChange = params ? params.listenOnChange : false;
              (0, _reactDom.render)(_react.default.createElement(_components.Visualization, {
                vis: handlers.vis,
                visData: visData,
                visParams: handlers.vis.params,
                uiState: uiState,
                listenOnChange: listenOnChange,
                onInit: handlers.done
              }), domNode);

            case 12:
            case "end":
              return _context.stop();
          }
        }
      });
    }
  };
};

exports.visualization = visualization;