'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * This module provides easy, yet strong, facilities for encrypting and decrypting serializable objects. The
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * ease-of-use comes from the fact that this module is opinionated in its (strong) choice of cryptographic algorithms,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * lengths, and iterations that cannot be overriden by its users.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * The module exports a `makeCryptoWith` function that takes a single argument, an `opts` object. This object requires
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * a property named `encryptionKey` which is a passphrase used by the encryption and decryption algorithms within
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * this module. The `makeCryptoWith` function returns an object containing two functions, `encrypt` and `decrypt`.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * Both the `encrypt` and `decrypt` functions are inverses of each other and return Promises. That is:
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          *   someSerializableObj === await decrypt(await encrypt(someSerializableObj)).
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          */

exports.default = makeCryptoWith;

var _crypto = require('crypto');

var _crypto2 = _interopRequireDefault(_crypto);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

var IV_LENGTH_IN_BYTES = 12;
var SALT_LENGTH_IN_BYTES = 64;
var KEY_LENGTH_IN_BYTES = 32;
var KEY_ITERATIONS = 10000;
var KEY_DIGEST = 'sha512';
var CIPHER_ALGORITHM = 'aes-256-gcm';
var ENCRYPTION_RESULT_ENCODING = 'base64';

function _validateOpts(_ref) {
  var encryptionKey = _ref.encryptionKey;

  if (!encryptionKey) {
    throw new Error('encryptionKey is required');
  }
}

function _generateSalt() {
  return _crypto2.default.randomBytes(SALT_LENGTH_IN_BYTES);
}

function _generateIV() {
  return _crypto2.default.randomBytes(IV_LENGTH_IN_BYTES);
}

function _generateKey(encryptionKey, salt) {
  if (!Buffer.isBuffer(salt)) {
    salt = new Buffer(salt, ENCRYPTION_RESULT_ENCODING);
  }

  return new Promise(function (resolve, reject) {
    _crypto2.default.pbkdf2(encryptionKey, salt, KEY_ITERATIONS, KEY_LENGTH_IN_BYTES, KEY_DIGEST, function (err, key) {
      if (err) {
        reject(err);
        return;
      }

      if (!Buffer.isBuffer(key)) {
        key = new Buffer(key, 'binary');
      }

      resolve(key);
    });
  });
}

function _serialize(obj) {
  return new Promise(function (resolve, reject) {
    var serializedObj = JSON.stringify(obj);
    if (serializedObj === undefined) {
      reject(new Error('Object to be encrypted must be serializable'));
      return;
    }
    resolve(serializedObj);
  });
}

/**
 * Implmenetation of encrypt() and decrypt() taken from https://gist.github.com/AndiDittrich/4629e7db04819244e843,
 * which was recommended by @jaymode
 */
function makeCryptoWith(opts) {
  var decrypt = function () {
    var _ref2 = _asyncToGenerator(function* (output) {

      var outputBytes = new Buffer(output, ENCRYPTION_RESULT_ENCODING);

      var salt = outputBytes.slice(0, SALT_LENGTH_IN_BYTES);
      var iv = outputBytes.slice(SALT_LENGTH_IN_BYTES, SALT_LENGTH_IN_BYTES + IV_LENGTH_IN_BYTES);
      var tag = outputBytes.slice(SALT_LENGTH_IN_BYTES + IV_LENGTH_IN_BYTES, SALT_LENGTH_IN_BYTES + IV_LENGTH_IN_BYTES + 16); // Auth tag is always 16 bytes long
      var text = outputBytes.slice(SALT_LENGTH_IN_BYTES + IV_LENGTH_IN_BYTES + 16);

      var key = yield _generateKey(encryptionKey, salt);
      var decipher = _crypto2.default.createDecipheriv(CIPHER_ALGORITHM, key, iv);
      decipher.setAuthTag(tag);

      var decrypted = decipher.update(text, 'binary', 'utf8') + decipher.final('utf8');
      return JSON.parse(decrypted);
    });

    return function decrypt(_x) {
      return _ref2.apply(this, arguments);
    };
  }();

  _validateOpts(opts);
  var encryptionKey = opts.encryptionKey;


  function encrypt(input) {
    var salt = _generateSalt();

    return Promise.all([_serialize(input), _generateIV(), _generateKey(encryptionKey, salt)]).then(function (results) {
      var _results = _slicedToArray(results, 3);

      var serializedInput = _results[0];
      var iv = _results[1];
      var key = _results[2];

      var cipher = _crypto2.default.createCipheriv(CIPHER_ALGORITHM, key, iv);

      var encrypted = Buffer.concat([cipher.update(serializedInput, 'utf8'), cipher.final()]);
      var tag = cipher.getAuthTag();

      return Buffer.concat([salt, iv, tag, encrypted]).toString(ENCRYPTION_RESULT_ENCODING);
    });
  }

  return {
    encrypt: encrypt,
    decrypt: decrypt
  };
}
module.exports = exports['default'];