"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var chart_types_1 = require("../../chart_types");
var utils_1 = require("../utils");
var get_chart_id_1 = require("./get_chart_id");
var specs_1 = require("../../chart_types/xy_chart/utils/specs");
var getSpecs = function (state) { return state.specs; };
exports.getSettingsSpecSelector = re_reselect_1.default([getSpecs], function (specs) {
    var settingsSpecs = utils_1.getSpecsFromStore(specs, chart_types_1.ChartTypes.Global, specs_1.SpecTypes.Settings);
    if (settingsSpecs.length > 1) {
        throw new Error('Multiple settings specs are configured on the same chart');
    }
    return settingsSpecs[0];
})(get_chart_id_1.getChartIdSelector);
//# sourceMappingURL=get_settings_specs.js.map