"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var interactions_1 = require("../../utils/interactions");
var get_projected_pointer_position_1 = require("./get_projected_pointer_position");
var get_oriented_projected_pointer_position_1 = require("./get_oriented_projected_pointer_position");
var utils_1 = require("../utils");
var get_computed_scales_1 = require("./get_computed_scales");
var get_elements_at_cursor_pos_1 = require("./get_elements_at_cursor_pos");
var get_specs_1 = require("./get_specs");
var get_tooltip_type_1 = require("./get_tooltip_type");
var tooltip_1 = require("../../tooltip/tooltip");
var get_tooltip_header_formatter_1 = require("./get_tooltip_header_formatter");
var rendering_1 = require("../../rendering/rendering");
var specs_1 = require("../../../../specs");
var events_1 = require("../../../../utils/events");
var get_chart_rotation_1 = require("../../../../state/selectors/get_chart_rotation");
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var has_single_series_1 = require("./has_single_series");
var EMPTY_VALUES = Object.freeze({
    tooltipValues: [],
    highlightedGeometries: [],
});
var getExternalPointerEventStateSelector = function (state) { return state.externalEvents.pointer; };
exports.getTooltipValuesAndGeometriesSelector = re_reselect_1.default([
    get_specs_1.getSeriesSpecsSelector,
    get_specs_1.getAxisSpecsSelector,
    get_projected_pointer_position_1.getProjectedPointerPositionSelector,
    get_oriented_projected_pointer_position_1.getOrientedProjectedPointerPositionSelector,
    get_chart_rotation_1.getChartRotationSelector,
    has_single_series_1.hasSingleSeriesSelector,
    get_computed_scales_1.getComputedScalesSelector,
    get_elements_at_cursor_pos_1.getElementAtCursorPositionSelector,
    get_tooltip_type_1.getTooltipTypeSelector,
    getExternalPointerEventStateSelector,
    get_tooltip_header_formatter_1.getTooltipHeaderFormatterSelector,
], getTooltipAndHighlightFromXValue)(function (state) {
    return state.chartId;
});
function getTooltipAndHighlightFromXValue(seriesSpecs, axesSpecs, projectedPointerPosition, orientedProjectedPointerPosition, chartRotation, hasSingleSeries, scales, xMatchingGeoms, tooltipType, externalPointerEvent, tooltipHeaderFormatter) {
    if (!scales.xScale || !scales.yScales) {
        return EMPTY_VALUES;
    }
    if (tooltipType === interactions_1.TooltipType.None) {
        return EMPTY_VALUES;
    }
    var x = orientedProjectedPointerPosition.x;
    var y = orientedProjectedPointerPosition.y;
    if (events_1.isValidPointerOverEvent(scales.xScale, externalPointerEvent)) {
        x = scales.xScale.pureScale(externalPointerEvent.value);
        y = 0;
    }
    else if (projectedPointerPosition.x === -1 || projectedPointerPosition.y === -1) {
        return EMPTY_VALUES;
    }
    if (xMatchingGeoms.length === 0) {
        return EMPTY_VALUES;
    }
    // build the tooltip value list
    var xValueInfo = null;
    var highlightedGeometries = [];
    var tooltipValues = xMatchingGeoms
        .filter(function (_a) {
        var y = _a.value.y;
        return y !== null;
    })
        .reduce(function (acc, indexedGeometry) {
        var specId = indexedGeometry.seriesIdentifier.specId;
        var spec = utils_1.getSpecsById(seriesSpecs, specId);
        // safe guard check
        if (!spec) {
            return acc;
        }
        var _a = utils_1.getAxesSpecForSpecId(axesSpecs, spec.groupId), xAxis = _a.xAxis, yAxis = _a.yAxis;
        // yScales is ensured by the enclosing if
        var yScale = scales.yScales.get(spec.groupId);
        if (!yScale) {
            return acc;
        }
        // check if the pointer is on the geometry (avoid checking if using external pointer event)
        var isHighlighted = false;
        if ((!externalPointerEvent || specs_1.isPointerOutEvent(externalPointerEvent)) &&
            rendering_1.isPointOnGeometry(x, y, indexedGeometry)) {
            isHighlighted = true;
            highlightedGeometries.push(indexedGeometry);
        }
        // if it's a follow tooltip, and no element is highlighted
        // not add that element into the tooltip list
        if (!isHighlighted && interactions_1.isFollowTooltipType(tooltipType)) {
            return acc;
        }
        // format the tooltip values
        var yAxisFormatSpec = [0, 180].includes(chartRotation) ? yAxis : xAxis;
        var formattedTooltip = tooltip_1.formatTooltip(indexedGeometry, spec, false, isHighlighted, hasSingleSeries, yAxisFormatSpec);
        // format only one time the x value
        if (!xValueInfo) {
            // if we have a tooltipHeaderFormatter, then don't pass in the xAxis as the user will define a formatter
            var xAxisFormatSpec = [0, 180].includes(chartRotation) ? xAxis : yAxis;
            var formatterAxis = tooltipHeaderFormatter ? undefined : xAxisFormatSpec;
            xValueInfo = tooltip_1.formatTooltip(indexedGeometry, spec, true, false, hasSingleSeries, formatterAxis);
            return __spread([xValueInfo], acc, [formattedTooltip]);
        }
        return __spread(acc, [formattedTooltip]);
    }, []);
    return {
        tooltipValues: tooltipValues,
        highlightedGeometries: highlightedGeometries,
    };
}
exports.getTooltipValuesSelector = re_reselect_1.default([exports.getTooltipValuesAndGeometriesSelector], function (values) {
    return values.tooltipValues;
})(get_chart_id_1.getChartIdSelector);
exports.getHighlightedGeomsSelector = re_reselect_1.default([exports.getTooltipValuesAndGeometriesSelector], function (values) {
    return values.highlightedGeometries;
})(get_chart_id_1.getChartIdSelector);
//# sourceMappingURL=get_tooltip_values_highlighted_geoms.js.map