"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var compute_series_domains_1 = require("./compute_series_domains");
var scales_1 = require("../../utils/scales");
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
exports.countBarsInClusterSelector = re_reselect_1.default([compute_series_domains_1.computeSeriesDomainsSelector], function (seriesDomainsAndData) {
    var formattedDataSeries = seriesDomainsAndData.formattedDataSeries;
    var totalBarsInCluster = scales_1.countBarsInCluster(formattedDataSeries.stacked, formattedDataSeries.nonStacked).totalBarsInCluster;
    return totalBarsInCluster;
})(get_chart_id_1.getChartIdSelector);
//# sourceMappingURL=count_bars_in_cluster.js.map