/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.net.URL;
import java.util.ArrayList;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.ResourcesDesc;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.LocateJnlpClassLoader;

public class ManageJnlpResources {
    public static JARDesc[] findJars(JNLPClassLoader rootClassLoader, URL ref, String part, Version version) {
        JNLPClassLoader foundLoader = LocateJnlpClassLoader.getLoaderByJnlpFile(rootClassLoader, ref);
        if (foundLoader != null) {
            ArrayList<JARDesc> foundJars = new ArrayList<JARDesc>();
            ResourcesDesc resources = foundLoader.getJNLPFile().getResources();
            for (JARDesc eachJar : resources.getJARs(part)) {
                if (version != null && !version.equals(eachJar.getVersion())) continue;
                foundJars.add(eachJar);
            }
            return foundJars.toArray(new JARDesc[foundJars.size()]);
        }
        return new JARDesc[0];
    }

    public static void removeCachedJars(JNLPClassLoader classLoader, URL ref, JARDesc[] jars) {
        JNLPClassLoader foundLoader = LocateJnlpClassLoader.getLoaderByJnlpFile(classLoader, ref);
        if (foundLoader != null) {
            foundLoader.removeJars(jars);
        }
    }

    public static void downloadJars(JNLPClassLoader classLoader, URL ref, String part, Version version) {
        JNLPClassLoader foundLoader = LocateJnlpClassLoader.getLoaderByJnlpFile(classLoader, ref);
        if (foundLoader != null) {
            foundLoader.initializeNewJarDownload(ref, part, version);
        }
    }

    public static void loadExternalResouceToCache(JNLPClassLoader rootClassLoader, URL ref, String version) {
        rootClassLoader.manageExternalJars(ref, version, JNLPClassLoader.DownloadAction.DOWNLOAD_TO_CACHE);
    }

    public static void removeExternalCachedResource(JNLPClassLoader rootClassLoader, URL ref, String version) {
        rootClassLoader.manageExternalJars(ref, version, JNLPClassLoader.DownloadAction.REMOVE_FROM_CACHE);
    }

    public static boolean isExternalResourceCached(JNLPClassLoader rootClassLoader, URL ref, String version) {
        return rootClassLoader.manageExternalJars(ref, version, JNLPClassLoader.DownloadAction.CHECK_CACHE);
    }
}

