/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util.rewriters;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.coroutine.CoroutinePassesKt;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0002J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0012H\u0002J\u001e\u0010\u0016\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u001e\u0010\u0016\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00172\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/js/inline/util/rewriters/ReturnReplacingVisitor;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitorWithContextImpl;", "resultRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "breakLabel", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "isSuspend", "", "(Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;Z)V", "endVisit", "", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsReturn;", "ctx", "Lorg/jetbrains/kotlin/js/backend/ast/JsContext;", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "getReturnReplacement", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "returnExpression", "processCoroutineResult", "expression", "visit", "Lorg/jetbrains/kotlin/js/backend/ast/JsObjectLiteral;", "js.translator"})
public final class ReturnReplacingVisitor
extends JsVisitorWithContextImpl {
    private final JsNameRef resultRef;
    private final JsNameRef breakLabel;
    private final JsFunction function;
    private final boolean isSuspend;

    public boolean visit(@NotNull JsObjectLiteral x, @NotNull JsContext<JsNode> ctx2) {
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        Intrinsics.checkParameterIsNotNull(ctx2, (String)"ctx");
        return false;
    }

    public boolean visit(@NotNull JsFunction x, @NotNull JsContext<JsNode> ctx2) {
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        Intrinsics.checkParameterIsNotNull(ctx2, (String)"ctx");
        return false;
    }

    public void endVisit(@NotNull JsReturn x, @NotNull JsContext<JsNode> ctx2) {
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        Intrinsics.checkParameterIsNotNull(ctx2, (String)"ctx");
        if (MetadataProperties.getReturnTarget(x) != null && Intrinsics.areEqual((Object)MetadataProperties.getFunctionDescriptor(this.function), (Object)MetadataProperties.getReturnTarget(x)) ^ true) {
            return;
        }
        ctx2.removeMe();
        JsExpression returnReplacement = this.getReturnReplacement(x.getExpression());
        if (returnReplacement != null) {
            if (returnReplacement.getSource() == null) {
                returnReplacement.setSource(x.getSource());
            }
            ctx2.addNext((JsNode)new JsExpressionStatement(returnReplacement));
        }
        if (this.breakLabel != null) {
            JsBreak jsBreak = new JsBreak(this.breakLabel);
            JsContext<JsNode> jsContext = ctx2;
            boolean bl = false;
            boolean bl2 = false;
            JsBreak $this$apply = jsBreak;
            boolean bl3 = false;
            $this$apply.setSource(x.getSource());
            JsBreak jsBreak2 = jsBreak;
            jsContext.addNext((JsNode)jsBreak2);
        }
    }

    private final JsExpression getReturnReplacement(JsExpression returnExpression) {
        JsExpression jsExpression;
        if (returnExpression != null) {
            JsBinaryOperation assignment;
            JsBinaryOperation jsBinaryOperation;
            JsNameRef jsNameRef = this.resultRef;
            if (jsNameRef != null) {
                JsNameRef jsNameRef2 = jsNameRef;
                boolean bl = false;
                boolean bl2 = false;
                JsNameRef lhs = jsNameRef2;
                boolean bl3 = false;
                JsExpression jsExpression2 = this.processCoroutineResult(returnExpression);
                if (jsExpression2 == null) {
                    Intrinsics.throwNpe();
                }
                JsExpression rhs = jsExpression2;
                JsBinaryOperation jsBinaryOperation2 = JsAstUtils.assignment(lhs, rhs);
                boolean bl4 = false;
                boolean bl5 = false;
                JsBinaryOperation $this$apply = jsBinaryOperation2;
                boolean bl6 = false;
                MetadataProperties.setSynthetic($this$apply, true);
                jsBinaryOperation = jsBinaryOperation2;
            } else {
                jsBinaryOperation = null;
            }
            JsBinaryOperation jsBinaryOperation3 = assignment = jsBinaryOperation;
            jsExpression = jsBinaryOperation3 != null ? (JsExpression)jsBinaryOperation3 : this.processCoroutineResult(returnExpression);
        } else {
            jsExpression = this.processCoroutineResult(null);
        }
        return jsExpression;
    }

    private final JsExpression processCoroutineResult(JsExpression expression2) {
        if (!this.isSuspend || CoroutinePassesKt.isStateMachineResult(expression2)) {
            return expression2;
        }
        JsNameRef jsNameRef = new JsNameRef("$$coroutineResult$$", JsAstUtils.stateMachineReceiver());
        boolean bl = false;
        boolean bl2 = false;
        JsNameRef $this$apply = jsNameRef;
        boolean bl3 = false;
        MetadataProperties.setCoroutineResult($this$apply, true);
        JsNameRef lhs = jsNameRef;
        JsExpression jsExpression = lhs;
        JsExpression jsExpression2 = expression2;
        if (jsExpression2 == null) {
            jsExpression2 = Namer.getUndefinedExpression();
        }
        return JsAstUtils.assignment(jsExpression, jsExpression2);
    }

    public ReturnReplacingVisitor(@Nullable JsNameRef resultRef, @Nullable JsNameRef breakLabel, @NotNull JsFunction function2, boolean isSuspend) {
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        this.resultRef = resultRef;
        this.breakLabel = breakLabel;
        this.function = function2;
        this.isSuspend = isSuspend;
    }
}

