/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.gradle.plugins.ide.eclipse.model.internal.PathUtil;

public class Link {
    private String name;
    private String type;
    private String location;
    private String locationUri;

    public Link(String name, String type, String location, String locationUri) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)type) ? 1 : 0) != 0);
        Preconditions.checkArgument((Strings.isNullOrEmpty((String)location) || Strings.isNullOrEmpty((String)locationUri) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)location) || !Strings.isNullOrEmpty((String)locationUri) ? 1 : 0) != 0);
        this.name = name;
        this.type = type;
        this.location = PathUtil.normalizePath(Strings.emptyToNull((String)location));
        this.locationUri = Strings.emptyToNull((String)locationUri);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocationUri() {
        return this.locationUri;
    }

    public void setLocationUri(String locationUri) {
        this.locationUri = locationUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        Link link = (Link)o;
        return Objects.equal((Object)this.name, (Object)link.name) && Objects.equal((Object)this.type, (Object)link.type) && Objects.equal((Object)this.location, (Object)link.location) && Objects.equal((Object)this.locationUri, (Object)link.locationUri);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        result = 31 * result + (this.locationUri != null ? this.locationUri.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Link{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", location='" + this.location + '\'' + ", locationUri='" + this.locationUri + '\'' + '}';
    }
}

