/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.scalar.Scalar;
import ghidra.util.StringFormat;
import ghidra.util.classfinder.ClassTranslator;

public class Undefined4DataType
extends Undefined {
    private static final long serialVersionUID = 1L;
    public static final Undefined4DataType dataType;

    public Undefined4DataType() {
        this(null);
    }

    public Undefined4DataType(DataTypeManager dtm) {
        super("undefined4", dtm);
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public String getDescription() {
        return "Undefined Double Word";
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new Undefined4DataType(dtm);
    }

    @Override
    public String getMnemonic(Settings settings) {
        return this.name;
    }

    private long getValue(MemBuffer buf) throws MemoryAccessException {
        long val = buf.getInt(0);
        return val & 0xFFFFFFFFL;
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        String val = "??";
        try {
            long b = this.getValue(buf);
            val = Long.toHexString(b).toUpperCase();
            val = StringFormat.padIt((String)val, (int)8, (char)'h', (boolean)true);
        }
        catch (MemoryAccessException memoryAccessException) {
            // empty catch block
        }
        return val;
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        try {
            return new Scalar(32, this.getValue(buf));
        }
        catch (MemoryAccessException e) {
            return null;
        }
    }

    static {
        ClassTranslator.put((String)"ghidra.program.model.data.Undefined4", (String)Undefined4DataType.class.getName());
        dataType = new Undefined4DataType();
    }
}

