/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.app.plugin.core.datamgr.archive.SourceArchive;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.DefaultDataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.InvalidNameException;
import ghidra.util.UniversalID;
import ghidra.util.exception.DuplicateNameException;
import java.net.URL;

public interface DataType {
    public static final DataType DEFAULT = DefaultDataType.dataType;
    public static final DataType VOID = VoidDataType.dataType;
    public static final String CONFLICT_SUFFIX = ".conflict";
    public static final long NO_SOURCE_SYNC_TIME = 0L;
    public static final long NO_LAST_CHANGE_TIME = 0L;

    public boolean isDynamicallySized();

    public boolean isNotYetDefined();

    public SettingsDefinition[] getSettingsDefinitions();

    public Settings getDefaultSettings();

    public DataType clone(DataTypeManager var1);

    public DataType copy(DataTypeManager var1);

    public CategoryPath getCategoryPath();

    public DataTypePath getDataTypePath();

    public void setCategoryPath(CategoryPath var1) throws DuplicateNameException;

    public DataTypeManager getDataTypeManager();

    public String getDisplayName();

    public String getName();

    public String getPathName();

    public void setName(String var1) throws InvalidNameException, DuplicateNameException;

    public void setNameAndCategory(CategoryPath var1, String var2) throws InvalidNameException, DuplicateNameException;

    public String getMnemonic(Settings var1);

    public int getLength();

    public String getDescription();

    public void setDescription(String var1) throws UnsupportedOperationException;

    public URL getDocs();

    public Object getValue(MemBuffer var1, Settings var2, int var3);

    public Class<?> getValueClass(Settings var1);

    public String getDefaultLabelPrefix();

    public String getDefaultAbbreviatedLabelPrefix();

    public String getDefaultLabelPrefix(MemBuffer var1, Settings var2, int var3, DataTypeDisplayOptions var4);

    public String getDefaultOffcutLabelPrefix(MemBuffer var1, Settings var2, int var3, DataTypeDisplayOptions var4, int var5);

    public String getRepresentation(MemBuffer var1, Settings var2, int var3);

    public boolean isDeleted();

    public boolean isEquivalent(DataType var1);

    public void dataTypeSizeChanged(DataType var1);

    public void dataTypeDeleted(DataType var1);

    public void dataTypeReplaced(DataType var1, DataType var2);

    public void setDefaultSettings(Settings var1);

    public void addParent(DataType var1);

    public void removeParent(DataType var1);

    public void dataTypeNameChanged(DataType var1, String var2);

    public DataType[] getParents();

    public int getAlignment();

    public boolean dependsOn(DataType var1);

    public SourceArchive getSourceArchive();

    public void setSourceArchive(SourceArchive var1);

    public long getLastChangeTime();

    public long getLastChangeTimeInSourceArchive();

    public UniversalID getUniversalID();

    public void replaceWith(DataType var1);

    public void setLastChangeTime(long var1);

    public void setLastChangeTimeInSourceArchive(long var1);
}

