/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.util.ErrorHandler;
import ghidra.framework.model.DomainFile;
import ghidra.framework.options.Options;
import ghidra.program.database.ManagerDB;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.function.FunctionManagerDB;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.symbol.SymbolManager;
import ghidra.program.model.data.ArchiveType;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.listing.Program;
import ghidra.util.InvalidNameException;
import ghidra.util.Lock;
import ghidra.util.UniversalID;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

public class ProgramDataTypeManager
extends DataTypeManagerDB
implements ManagerDB,
ProgramBasedDataTypeManager {
    private static final String OLD_DT_ARCHIVE_FILENAMES = "DataTypeArchiveFilenames";
    private ProgramDB program;
    private boolean upgrade;

    public ProgramDataTypeManager(DBHandle handle, AddressMap addrMap, int openMode, ErrorHandler errHandler, Lock lock, TaskMonitor monitor) throws CancelledException, VersionException, IOException {
        super(handle, addrMap, openMode, errHandler, lock, monitor);
        this.upgrade = openMode == 3;
    }

    @Override
    public void setProgram(ProgramDB p) {
        this.program = p;
        this.removeOldFileNameList();
    }

    private void removeOldFileNameList() {
        Options options;
        if (this.upgrade && (options = this.program.getOptions("Program Information")).contains(OLD_DT_ARCHIVE_FILENAMES)) {
            options.removeOption(OLD_DT_ARCHIVE_FILENAMES);
        }
    }

    @Override
    public void invalidateCache(boolean all) throws IOException {
        super.invalidateCache();
    }

    @Override
    public void programReady(int openMode, int currentRevision, TaskMonitor monitor) throws IOException, CancelledException {
        if (openMode == 3) {
            this.doSourceArchiveUpdates(this.program.getCompilerSpec(), monitor);
        }
    }

    @Override
    public String getName() {
        return this.program.getName();
    }

    @Override
    public Pointer getPointer(DataType dt) {
        return PointerDataType.getPointer(dt, this);
    }

    @Override
    public void setName(String name) throws InvalidNameException {
        if (name == null || name.length() == 0) {
            throw new InvalidNameException("Name is invalid: " + name);
        }
        this.program.setName(name);
        this.categoryRenamed(CategoryPath.ROOT, null);
    }

    @Override
    public void sourceArchiveChanged(UniversalID sourceArchiveID) {
        super.sourceArchiveChanged(sourceArchiveID);
        this.program.sourceArchiveChanged(sourceArchiveID, 112);
    }

    @Override
    protected void sourceArchiveAdded(UniversalID sourceArchiveID) {
        super.sourceArchiveAdded(sourceArchiveID);
        this.program.sourceArchiveAdded(sourceArchiveID, 111);
    }

    @Override
    public void dataTypeChanged(DataType dt) {
        super.dataTypeChanged(dt);
        if (!this.isCreatingDataType()) {
            this.program.getCodeManager().invalidateCache(false);
            this.program.getFunctionManager().invalidateCache(false);
            this.program.dataTypeChanged(this.getID(dt), 108, null, dt);
        }
    }

    @Override
    protected void dataTypeAdded(DataType newDt, DataType originalDataType) {
        super.dataTypeAdded(newDt, originalDataType);
        this.program.dataTypeAdded(this.getID(newDt), 104, null, newDt);
    }

    @Override
    protected void dataTypeReplaced(long existingDtID, DataTypePath existingPath, DataType replacementDt) {
        super.dataTypeReplaced(existingDtID, existingPath, replacementDt);
        this.program.dataTypeChanged(existingDtID, 110, existingPath, replacementDt);
    }

    @Override
    protected void dataTypeDeleted(long deletedID, DataTypePath deletedDataTypePath) {
        super.dataTypeDeleted(deletedID, deletedDataTypePath);
        this.program.dataTypeChanged(deletedID, 105, deletedDataTypePath, null);
    }

    @Override
    protected void dataTypeMoved(DataType dt, DataTypePath oldPath, DataTypePath newPath) {
        super.dataTypeMoved(dt, oldPath, newPath);
        Category category = this.getCategory(oldPath.getCategoryPath());
        this.program.dataTypeChanged(this.getID(dt), 107, category, dt);
    }

    @Override
    protected void dataTypeNameChanged(DataType dt, String oldName) {
        super.dataTypeNameChanged(dt, oldName);
        this.program.dataTypeChanged(this.getID(dt), 106, oldName, dt);
    }

    @Override
    protected void categoryCreated(Category newCategory) {
        super.categoryCreated(newCategory);
        this.program.categoryAdded(newCategory.getID(), 100, newCategory.getParent(), newCategory);
    }

    @Override
    protected void categoryRenamed(CategoryPath oldPath, Category category) {
        super.categoryRenamed(oldPath, category);
        this.program.categoryChanged(category.getID(), 102, oldPath.getName(), category);
    }

    @Override
    protected void categoryRemoved(Category parent, String name, long categoryID) {
        super.categoryRemoved(parent, name, categoryID);
        this.program.categoryChanged(categoryID, 101, parent, name);
    }

    @Override
    protected void categoryMoved(CategoryPath oldPath, Category category) {
        super.categoryMoved(oldPath, category);
        this.program.categoryChanged(category.getID(), 103, oldPath.getParent(), category);
    }

    @Override
    protected void favoritesChanged(DataType dataType, boolean isFavorite) {
        super.favoritesChanged(dataType, isFavorite);
    }

    @Override
    protected void replaceDataTypeIDs(long oldDataTypeID, long newDataTypeID) {
        if (oldDataTypeID == newDataTypeID) {
            return;
        }
        this.program.getCodeManager().replaceDataTypes(oldDataTypeID, newDataTypeID);
        ((SymbolManager)this.program.getSymbolTable()).replaceDataTypes(oldDataTypeID, newDataTypeID);
        ((FunctionManagerDB)this.program.getFunctionManager()).replaceDataTypes(oldDataTypeID, newDataTypeID);
    }

    @Override
    protected void deleteDataTypeIDs(LinkedList<Long> deletedIds, TaskMonitor monitor) throws CancelledException {
        long[] ids = new long[deletedIds.size()];
        Iterator it = deletedIds.iterator();
        int i = 0;
        while (it.hasNext()) {
            ids[i++] = (Long)it.next();
        }
        this.program.getCodeManager().clearData(ids, monitor);
        this.program.getFunctionManager().invalidateCache(false);
    }

    @Override
    public boolean isUpdatable() {
        return this.program.isChangeable();
    }

    @Override
    public int startTransaction(String description) {
        return this.program.startTransaction(description);
    }

    @Override
    public void flushEvents() {
        this.program.flushEvents();
    }

    @Override
    public void endTransaction(int transactionID, boolean commit) {
        this.program.endTransaction(transactionID, commit);
    }

    @Override
    public void close() {
    }

    @Override
    public Program getProgram() {
        return this.program;
    }

    @Override
    public DomainFile getDomainFile() {
        return this.program.getDomainFile();
    }

    @Override
    public String getDomainFileID() {
        DomainFile domainFile = this.program.getDomainFile();
        return domainFile != null ? domainFile.getFileID() : null;
    }

    @Override
    public String getPath() {
        DomainFile domainFile = this.program.getDomainFile();
        return domainFile != null ? domainFile.getPathname() : null;
    }

    @Override
    public ArchiveType getType() {
        return ArchiveType.PROGRAM;
    }

    @Override
    public DataOrganization getDataOrganization() {
        if (this.dataOrganization == null) {
            this.dataOrganization = this.program.getCompilerSpec().getDataOrganization();
        }
        return this.dataOrganization;
    }
}

