/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.opbehavior;

import ghidra.pcode.opbehavior.UnaryOpBehavior;
import ghidra.pcode.utils.Utils;
import ghidra.util.exception.AssertException;
import java.math.BigInteger;

public class OpBehaviorInt2Comp
extends UnaryOpBehavior {
    public OpBehaviorInt2Comp() {
        super(24);
    }

    @Override
    public long evaluateUnary(int sizeout, int sizein, long in1) {
        long res = Utils.uintb_negate(in1 - 1L, sizein);
        return res;
    }

    @Override
    public BigInteger evaluateUnary(int sizeout, int sizein, BigInteger in1) {
        if (in1.signum() < 0) {
            throw new AssertException("Expected unsigned in value");
        }
        BigInteger res = in1.negate();
        return res;
    }
}

