/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.task;

import ghidra.util.SystemUtilities;
import ghidra.util.task.MonitoredRunnable;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.Objects;

public class TaskBuilder {
    private String title;
    private MonitoredRunnable runnable;
    private Component parent;
    private int launchDelay = -1;
    private int dialogWidth = 275;
    private boolean hasProgress = true;
    private boolean canCancel = true;
    private boolean waitForTaskCompletion = false;
    private int statusTextAlignment = 0;

    public TaskBuilder(String title, MonitoredRunnable runnable) {
        this.title = Objects.requireNonNull(title);
        this.runnable = Objects.requireNonNull(runnable);
    }

    public TaskBuilder setHasProgress(boolean hasProgress) {
        this.hasProgress = hasProgress;
        return this;
    }

    public TaskBuilder setCanCancel(boolean canCancel) {
        this.canCancel = canCancel;
        return this;
    }

    public TaskBuilder setParent(Component parent) {
        this.parent = parent;
        return this;
    }

    public TaskBuilder setLaunchDelay(int delay) {
        SystemUtilities.assertTrue((delay > 0 ? 1 : 0) != 0, (String)"Launch delay must be greater than 0");
        this.launchDelay = delay;
        return this;
    }

    public TaskBuilder setDialogWidth(int width) {
        SystemUtilities.assertTrue((width > 0 ? 1 : 0) != 0, (String)"Dialog width must be greater than 0");
        this.dialogWidth = width;
        return this;
    }

    public TaskBuilder setStatusTextAlignment(int alignment) {
        boolean isValid = SystemUtilities.isOneOf((Object)alignment, (Object[])new Integer[]{10, 0, 11});
        SystemUtilities.assertTrue((boolean)isValid, (String)("Illegal alignment argument: " + alignment));
        this.statusTextAlignment = alignment;
        return this;
    }

    public void launchModal() {
        boolean isModal = true;
        TaskBuilderTask t = new TaskBuilderTask(isModal);
        int delay = TaskBuilder.getDelay(this.launchDelay, isModal);
        new TaskLauncher(t, this.parent, delay, this.dialogWidth);
    }

    public TaskLauncher launchNonModal() {
        boolean isModal = false;
        TaskBuilderTask t = new TaskBuilderTask(isModal);
        int delay = TaskBuilder.getDelay(this.launchDelay, isModal);
        TaskLauncher launcher = new TaskLauncher(t, this.parent, delay, this.dialogWidth);
        return launcher;
    }

    private static int getDelay(int userDelay, boolean isModal) {
        if (userDelay >= 0) {
            return userDelay;
        }
        if (isModal) {
            return 500;
        }
        return 1000;
    }

    private class TaskBuilderTask
    extends Task {
        TaskBuilderTask(boolean isModal) {
            super(TaskBuilder.this.title, TaskBuilder.this.canCancel, TaskBuilder.this.hasProgress, isModal, TaskBuilder.this.waitForTaskCompletion);
        }

        public int getStatusTextAlignment() {
            return TaskBuilder.this.statusTextAlignment;
        }

        public void run(TaskMonitor monitor) {
            TaskBuilder.this.runnable.monitoredRun(monitor);
        }
    }
}

