/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.threaded;

import docking.widgets.table.SortedTableModel;
import docking.widgets.table.threaded.ThreadedTableModel;
import java.util.Comparator;

public class TableColumnComparator<T>
implements Comparator<T> {
    private ThreadedTableModel<T, ?> model;
    private final int sortColumn;
    private Comparator<Object> columnComparator;

    public TableColumnComparator(ThreadedTableModel<T, ?> model, Comparator<Object> columnComparator, int sortColumn) {
        this.model = model;
        this.columnComparator = columnComparator;
        this.sortColumn = sortColumn;
    }

    @Override
    public int compare(T t1, T t2) {
        if (t1 == t2) {
            return 0;
        }
        Object o1 = this.model.getCachedColumnValueForRow(t1, this.sortColumn);
        Object o2 = this.model.getCachedColumnValueForRow(t2, this.sortColumn);
        if (o1 == null || o2 == null) {
            return this.handleNullValues(o1, o2);
        }
        if (this.columnComparator != null) {
            return this.columnComparator.compare(o1, o2);
        }
        return SortedTableModel.DEFAULT_COMPARATOR.compare(o1, o2);
    }

    private int handleNullValues(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        return 1;
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        TableColumnComparator other = (TableColumnComparator)obj;
        return this.sortColumn == other.sortColumn;
    }

    public int hashCode() {
        return this.sortColumn;
    }
}

