/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.conditiontestpanel;

import docking.widgets.conditiontestpanel.ConditionStatus;

public class ConditionResult {
    private final ConditionStatus status;
    private final String message;

    public ConditionResult(ConditionStatus status) {
        this(status, null);
    }

    public ConditionResult(ConditionStatus status, String message) {
        this.status = status;
        this.message = message;
    }

    public ConditionStatus getStatus() {
        return this.status;
    }

    public String getMessage() {
        if (this.message == null || this.message.matches("^\\s*$")) {
            return this.getDefaultMessage();
        }
        return this.message;
    }

    private String getDefaultMessage() {
        switch (this.status) {
            case Cancelled: {
                return "Cancelled by user";
            }
            case Error: {
                return "Error - please update test to provide a better error message";
            }
            case None: {
                return "";
            }
            case Passed: {
                return "Passed";
            }
            case Skipped: {
                return "Skipped";
            }
            case Warning: {
                return "Warning - please update test to provide a better warning message";
            }
        }
        return "";
    }
}

