/*
 * Decompiled with CFR 0.152.
 */
package docking.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.MultiIcon;
import resources.ResourceManager;
import resources.icons.EmptyIcon;
import resources.icons.ScaledImageIconWrapper;

public class BadgedIcon
implements Icon {
    private Map<BadgePosition, MultiIcon> badgeMap = new EnumMap<BadgePosition, MultiIcon>(BadgePosition.class);
    private Map<BadgePosition, Boolean> badgeEnablement = new EnumMap<BadgePosition, Boolean>(BadgePosition.class);
    private Map<BadgePosition, Boolean> badgeVisibility = new EnumMap<BadgePosition, Boolean>(BadgePosition.class);
    private static double BADGE_HSCALE_FACTOR = 0.75;
    private static double BADGE_VSCALE_FACTOR = 0.75;
    private Icon cachedThis = null;
    private Icon base;
    private int height;
    private int width;
    private boolean enabled;

    public BadgedIcon(Icon baseIcon) {
        this(baseIcon, true);
    }

    public BadgedIcon(Icon baseIcon, boolean enabled) {
        this(baseIcon, enabled, baseIcon.getIconWidth(), baseIcon.getIconHeight());
    }

    public BadgedIcon(Icon baseIcon, boolean enabled, int width, int height) {
        Objects.requireNonNull(baseIcon, "Base Icon must not be null");
        this.base = baseIcon;
        this.width = width;
        this.height = height;
        this.enabled = enabled;
        this.initDefaultBadges();
        this.cachedThis = null;
    }

    private static MultiIcon getEmptyIcon(int width, int height, boolean enabled) {
        return new MultiIcon((Icon)new EmptyIcon(width, height), !enabled);
    }

    private void initDefaultBadges() {
        for (BadgePosition pos : BadgePosition.values()) {
            this.badgeMap.put(pos, BadgedIcon.getEmptyIcon(this.width, this.height, this.enabled));
            this.badgeEnablement.put(pos, true);
            this.badgeVisibility.put(pos, true);
        }
    }

    public BadgedIcon addBadge(Icon badge, BadgePosition position) {
        this.badgeMap.get((Object)position).addIcon(badge);
        this.height = Math.max(this.height, badge.getIconHeight());
        this.width = Math.max(this.width, badge.getIconWidth());
        this.cachedThis = null;
        return this;
    }

    public BadgedIcon addScaledBadge(Icon icon, int newWidth, int newHeight, BadgePosition position) {
        ImageIcon badge = ResourceManager.getScaledIcon((Icon)icon, (int)this.width, (int)this.height);
        this.badgeMap.get((Object)position).addIcon((Icon)badge);
        this.height = Math.max(this.height, badge.getIconHeight());
        this.width = Math.max(this.width, badge.getIconWidth());
        this.cachedThis = null;
        return this;
    }

    public BadgedIcon setBadge(Icon badge, BadgePosition position) {
        MultiIcon multi = null;
        if (badge == null) {
            badge = BadgedIcon.getEmptyIcon(this.width, this.height, this.enabled);
        }
        multi = new MultiIcon(badge, this.enabled, this.width, this.height);
        this.badgeMap.put(position, multi);
        this.cachedThis = null;
        return this;
    }

    public BadgedIcon removeBadge(BadgePosition position) {
        this.setBadge(null, position);
        return this;
    }

    public void setBadgeEnabled(BadgePosition position, boolean enabled) {
        if (this.isBadgeEnabled(position) == enabled) {
            return;
        }
        this.badgeEnablement.put(position, enabled);
        this.cachedThis = null;
    }

    public boolean isBadgeEnabled(BadgePosition position) {
        return this.badgeEnablement.get((Object)position);
    }

    public void setBadgeVisisble(BadgePosition position, boolean visible) {
        if (this.isBadgeVisible(position) == visible) {
            return;
        }
        this.badgeVisibility.put(position, visible);
        this.cachedThis = null;
    }

    public boolean isBadgeVisible(BadgePosition position) {
        return this.badgeVisibility.get((Object)position);
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Icon[] getBadges(BadgePosition pos) {
        MultiIcon badge = this.badgeMap.get((Object)pos);
        return badge.getIcons();
    }

    private Dimension getBadgeDimension() {
        return new Dimension((int)((double)this.width * BADGE_HSCALE_FACTOR), (int)((double)this.height * BADGE_VSCALE_FACTOR));
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.cachedThis != null) {
            this.cachedThis.paintIcon(c, g, x, y);
        } else {
            Dimension badgeSize = this.getBadgeDimension();
            this.doPaintIcon(c, g, x, y, badgeSize);
        }
        if (!this.enabled) {
            Color bgColor = c.getBackground();
            g.setColor(new Color(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), 128));
            g.fillRect(x, y, this.width, this.height);
        }
    }

    private void doPaintIcon(Component c, Graphics g, int x, int y, Dimension badgeSize) {
        BufferedImage cached = new BufferedImage(this.width, this.height, 2);
        Graphics gc = cached.getGraphics();
        this.base.paintIcon(c, gc, x, y);
        for (BadgePosition pos : BadgePosition.values()) {
            if (!this.isBadgeVisible(pos)) continue;
            MultiIcon icon = this.badgeMap.get((Object)pos);
            ScaledImageIconWrapper scaled = new ScaledImageIconWrapper((Icon)icon, badgeSize.width, badgeSize.height);
            Point badgePaintLoc = BadgedIcon.getBadgePaintLocation(pos, badgeSize);
            int badgeX = x + badgePaintLoc.x;
            int badgeY = y + badgePaintLoc.y;
            scaled.paintIcon(c, gc, badgeX, badgeY);
            if (this.isBadgeEnabled(pos)) continue;
            Color bgColor = c.getBackground();
            gc.setColor(new Color(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), 128));
            gc.fillRect(badgeX, badgeY, badgeSize.width, badgeSize.height);
        }
        this.cachedThis = new ImageIcon(cached);
        this.cachedThis.paintIcon(c, g, x, y);
    }

    private static Point getBadgePaintLocation(BadgePosition pos, Dimension badgeSize) {
        double dx = pos.getHorizontalDisplacementFactor();
        double dy = pos.getVerticalDisplacementFactor();
        Point p = new Point((int)(dx * (double)badgeSize.width), (int)(dy * (double)badgeSize.height));
        return p;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getIconNames() + "]";
    }

    private String getIconNames() {
        StringBuffer buffy = new StringBuffer();
        for (BadgePosition pos : BadgePosition.values()) {
            MultiIcon mi = this.badgeMap.get((Object)pos);
            buffy.append((Object)pos).append("[").append(mi.toString()).append("]");
            buffy.append(", ");
        }
        return buffy.toString();
    }

    public static enum BadgePosition {
        TopLeft(-0.2, -0.2),
        TopMiddle(0.3, -0.2),
        TopRight(0.6, -0.2),
        LeftMiddle(-0.2, 0.3),
        Center(0.3, 0.3),
        RightMiddle(0.6, 0.3),
        BottomLeft(-0.2, 0.6),
        BottomMiddle(0.3, 0.6),
        BottomRight(0.6, 0.6);

        private final double horizontalDisplacementFactor;
        private final double verticalDisplacementFactor;

        private BadgePosition(double hdf, double vdf) {
            this.horizontalDisplacementFactor = hdf;
            this.verticalDisplacementFactor = vdf;
        }

        public double getHorizontalDisplacementFactor() {
            return this.horizontalDisplacementFactor;
        }

        public double getVerticalDisplacementFactor() {
            return this.verticalDisplacementFactor;
        }
    }
}

