/*
 * Decompiled with CFR 0.152.
 */
package docking.options.editor;

import docking.ToolTipManager;
import docking.options.editor.GenericOptionsComponent;
import ghidra.framework.options.EditorState;
import ghidra.util.HTMLUtilities;
import ghidra.util.layout.PairLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class DefaultOptionComponent
extends GenericOptionsComponent {
    private JLabel label;
    private Component component;

    public DefaultOptionComponent(EditorState editorState) {
        super(editorState);
        this.setLayout((LayoutManager)new PairLayout(0, 6, 40));
        this.component = editorState.getEditorComponent();
        this.label = new JLabel(editorState.getTitle(), 4);
        if (this.component instanceof AbstractButton) {
            this.label.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    AbstractButton button;
                    if (!DefaultOptionComponent.this.component.isEnabled()) {
                        return;
                    }
                    button.setSelected(!(button = (AbstractButton)DefaultOptionComponent.this.component).isSelected());
                }
            });
        }
        this.setSize(this.getPreferredSize());
        String description = editorState.getDescription();
        if (description != null) {
            String htmlDescription = HTMLUtilities.toWrappedHTML((String)description);
            ToolTipManager.setToolTipText(this.label, htmlDescription);
            if (this.component instanceof JComponent) {
                ToolTipManager.setToolTipText((JComponent)this.component, htmlDescription);
            }
        }
        this.add(this.label);
        this.add(this.component);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.label.setEnabled(enabled);
        this.component.setEnabled(enabled);
    }

    @Override
    protected void setAlignmentPreferredSize(Dimension dimension) {
        this.label.setPreferredSize(dimension);
    }

    @Override
    protected Dimension getPreferredAlignmentSize() {
        Dimension dimension = this.label.getPreferredSize();
        int maxHeight = Math.max(dimension.height, this.component.getPreferredSize().height);
        return new Dimension(dimension.width, maxHeight);
    }
}

