/*
 * Decompiled with CFR 0.152.
 */
package docking.action;

import docking.DialogComponentProvider;
import docking.DockingActionManager;
import docking.DockingKeyBindingAction;
import docking.KeyEntryListener;
import docking.KeyEntryTextField;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MultipleKeyAction;
import ghidra.util.HelpLocation;
import ghidra.util.ReservedKeyBindings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import resources.ResourceManager;

public class KeyEntryDialog
extends DialogComponentProvider {
    private DockingActionManager actionManager;
    private DockingActionIf action;
    private JPanel defaultPanel;
    private KeyEntryTextField keyEntryField;
    private JTextPane collisionPane;
    private StyledDocument doc;
    private SimpleAttributeSet tabAttrSet;
    private SimpleAttributeSet textAttrSet;
    private Color bgColor;

    public KeyEntryDialog(DockingActionIf action, DockingActionManager actionManager) {
        super("Set Key Binding for " + action.getName(), true);
        this.actionManager = actionManager;
        this.action = action;
        this.setUpAttributes();
        this.createPanel();
        KeyStroke keyBinding = action.getKeyBinding();
        this.updateCollisionPane(keyBinding);
        this.setHelpLocation(new HelpLocation("Tool", "KeyBindingPopup"));
    }

    private void createPanel() {
        this.addWorkPanel(this.buildMainPanel());
        this.addOKButton();
        this.addCancelButton();
    }

    private JPanel buildMainPanel() {
        this.defaultPanel = new JPanel(new BorderLayout());
        this.defaultPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        ImageIcon icon = ResourceManager.loadImage((String)"images/information.png");
        JLabel imageLabel = new JLabel(icon);
        this.bgColor = imageLabel.getBackground();
        JTextPane pane = new JTextPane();
        pane.setBorder(BorderFactory.createEmptyBorder(0, 5, 2, 5));
        pane.setBackground(this.bgColor);
        pane.setEditable(false);
        StyledDocument document = pane.getStyledDocument();
        try {
            document.insertString(0, "To add or change a key binding, type any key combination.\nTo remove a key binding, press <Enter> or <Backspace>.", null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        JPanel labelPanel = new JPanel();
        labelPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        BoxLayout bl = new BoxLayout(labelPanel, 0);
        labelPanel.setLayout(bl);
        labelPanel.add(Box.createHorizontalStrut(5));
        labelPanel.add(imageLabel);
        labelPanel.add(Box.createHorizontalStrut(10));
        labelPanel.add(pane);
        labelPanel.add(Box.createHorizontalStrut(5));
        this.keyEntryField = new KeyEntryTextField(20, new KeyEntryListener(){

            @Override
            public void processEntry(KeyStroke keyStroke) {
                KeyEntryDialog.this.okButton.setEnabled(true);
                KeyEntryDialog.this.updateCollisionPane(keyStroke);
            }
        });
        this.defaultPanel.add((Component)labelPanel, "North");
        this.defaultPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        JPanel p = new JPanel(new FlowLayout(1));
        p.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        p.add(this.keyEntryField);
        KeyStroke keyBinding = this.action.getKeyBinding();
        if (keyBinding != null) {
            this.keyEntryField.setText(DockingKeyBindingAction.parseKeyStroke(keyBinding));
        }
        this.setFocusComponent(this.keyEntryField);
        this.defaultPanel.add((Component)p, "Center");
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.defaultPanel, "North");
        mainPanel.add((Component)this.createCollisionPanel(), "Center");
        return mainPanel;
    }

    private JPanel createCollisionPanel() {
        JPanel p = new JPanel(new BorderLayout());
        this.collisionPane = new JTextPane();
        this.collisionPane.setEditable(false);
        this.collisionPane.setBackground(this.bgColor);
        this.doc = this.collisionPane.getStyledDocument();
        JScrollPane sp = new JScrollPane(this.collisionPane);
        Dimension d = this.defaultPanel.getPreferredSize();
        sp.setPreferredSize(new Dimension(sp.getPreferredSize().width, d.height));
        p.add((Component)sp, "Center");
        return p;
    }

    @Override
    protected void cancelCallback() {
        this.close();
    }

    @Override
    protected void okCallback() {
        KeyStroke keyStroke = this.keyEntryField.getCurrentKeyStroke();
        if (keyStroke != null && ReservedKeyBindings.isReservedKeystroke(keyStroke)) {
            this.setStatusText(this.keyEntryField.getText() + " is a reserved keystroke");
            return;
        }
        this.clearStatusText();
        List<DockingActionIf> actions = this.actionManager.getAllDockingActionsByFullActionName(this.action.getFullName());
        for (DockingActionIf element : actions) {
            if (!element.isKeyBindingManaged()) continue;
            element.setUnvalidatedKeyBindingData(new KeyBindingData(keyStroke));
        }
        this.close();
    }

    private void setUpAttributes() {
        this.textAttrSet = new SimpleAttributeSet();
        this.textAttrSet.addAttribute(StyleConstants.FontFamily, "Tahoma");
        this.textAttrSet.addAttribute(StyleConstants.FontSize, new Integer(11));
        this.textAttrSet.addAttribute(StyleConstants.Foreground, Color.BLUE);
        this.tabAttrSet = new SimpleAttributeSet();
        TabStop tabs = new TabStop(20.0f, 0, 0);
        StyleConstants.setTabSet(this.tabAttrSet, new TabSet(new TabStop[]{tabs}));
    }

    private void updateCollisionPane(KeyStroke ks) {
        this.collisionPane.setText("");
        if (ks == null) {
            return;
        }
        List<DockingActionIf> list = this.getManagedActionsForKeyStroke(ks);
        if (list.size() == 0) {
            return;
        }
        String ksName = DockingKeyBindingAction.parseKeyStroke(ks);
        try {
            this.doc.insertString(0, "Actions mapped to " + ksName + "\n\n", this.textAttrSet);
            for (int i = 0; i < list.size(); ++i) {
                DockingActionIf a = list.get(i);
                String collisionStr = "\t" + a.getName() + "  (" + a.getOwner() + ")\n";
                int offset = this.doc.getLength();
                this.doc.insertString(offset, collisionStr, this.textAttrSet);
                this.doc.setParagraphAttributes(offset, 1, this.tabAttrSet, false);
            }
            this.collisionPane.setCaretPosition(0);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private List<DockingActionIf> getManagedActionsForKeyStroke(KeyStroke keyStroke) {
        MultipleKeyAction multiAction = this.getMultipleKeyAction(keyStroke);
        if (multiAction == null) {
            return Collections.emptyList();
        }
        List<DockingActionIf> list = multiAction.getActions();
        HashMap<CallSite, DockingActionIf> nameMap = new HashMap<CallSite, DockingActionIf>(list.size());
        for (DockingActionIf dockableAction : list) {
            if (!this.shouldAddAction(dockableAction)) continue;
            nameMap.put((CallSite)((Object)(dockableAction.getName() + dockableAction.getOwner())), dockableAction);
        }
        return new ArrayList<DockingActionIf>(nameMap.values());
    }

    private MultipleKeyAction getMultipleKeyAction(KeyStroke ks) {
        Action keyAction = this.actionManager.getDockingKeyAction(ks);
        if (keyAction instanceof MultipleKeyAction) {
            return (MultipleKeyAction)keyAction;
        }
        return null;
    }

    private boolean shouldAddAction(DockingActionIf dockableAction) {
        return dockableAction.isKeyBindingManaged();
    }
}

