/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.matchtable;

import docking.widgets.table.GTableCellRenderingData;
import ghidra.docking.settings.Settings;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationMarkupStatus;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.gui.provider.matchtable.MatchTableRenderer;
import ghidra.util.HTMLUtilities;
import ghidra.util.table.column.AbstractGhidraColumnRenderer;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import resources.MultiIcon;
import resources.ResourceManager;
import resources.icons.EmptyIcon;
import resources.icons.TranslateIcon;

public class MatchMarkupStatusRenderer
extends AbstractGhidraColumnRenderer<VTMatch> {
    private static ImageIcon DISABLED_ICON = ResourceManager.getDisabledIcon((Icon)ResourceManager.loadImage((String)"images/ledgreen.png"), (int)50);
    private static final ImageIcon APPLIED_BASE_ICON = ResourceManager.loadImage((String)"images/ledgreen.png", (int)8, (int)8);
    private static final ImageIcon REJECTED_BASE_ICON = ResourceManager.loadImage((String)"images/ledpurple.png", (int)8, (int)8);
    private static final ImageIcon NOT_APPLIED_BASE_ICON = ResourceManager.loadImage((String)"images/ledorange.png", (int)8, (int)8);
    private static final ImageIcon IGNORED_BASE_ICON = ResourceManager.loadImage((String)"images/ledblue.png", (int)8, (int)8);
    private static final ImageIcon ERROR_BASE_ICON = ResourceManager.loadImage((String)"images/ledred.png", (int)8, (int)8);
    private static Icon NOT_APPLIED_ICON = new TranslateIcon((Icon)NOT_APPLIED_BASE_ICON, 0, 4);
    private static Icon APPLIED_ICON = new TranslateIcon((Icon)APPLIED_BASE_ICON, 9, 4);
    private static Icon REJECTED_ICON = new TranslateIcon((Icon)REJECTED_BASE_ICON, 18, 4);
    private static Icon IGNORED_ICON = new TranslateIcon((Icon)IGNORED_BASE_ICON, 27, 4);
    private static Icon ERROR_ICON = new TranslateIcon((Icon)ERROR_BASE_ICON, 36, 4);
    private static Icon DISABLED_NOT_APPLIED_ICON = new TranslateIcon((Icon)DISABLED_ICON, 0, 4);
    private static Icon DISABLED_APPLIED_ICON = new TranslateIcon((Icon)DISABLED_ICON, 9, 4);
    private static Icon DISABLED_REJECTED_ICON = new TranslateIcon((Icon)DISABLED_ICON, 18, 4);
    private static Icon DISABLED_IGNORED_ICON = new TranslateIcon((Icon)DISABLED_ICON, 27, 4);
    private static Icon DISABLED_ERROR_ICON = new TranslateIcon((Icon)DISABLED_ICON, 36, 4);

    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        JLabel renderer = (JLabel)super.getTableCellRendererComponent(data);
        Object value = data.getValue();
        JTable table = data.getTable();
        boolean isSelected = data.isSelected();
        this.setText("");
        this.setHorizontalAlignment(0);
        VTMatch match = (VTMatch)value;
        VTAssociation association = match.getAssociation();
        if (!isSelected) {
            renderer.setBackground(MatchTableRenderer.getBackgroundColor(association, table, renderer.getBackground()));
        }
        VTAssociationMarkupStatus markupStatus = association.getMarkupStatus();
        MultiIcon icon = new MultiIcon((Icon)new EmptyIcon(36, 16));
        icon.addIcon(markupStatus.hasUnexaminedMarkup() ? NOT_APPLIED_ICON : DISABLED_NOT_APPLIED_ICON);
        icon.addIcon(markupStatus.hasAppliedMarkup() ? APPLIED_ICON : DISABLED_APPLIED_ICON);
        icon.addIcon(markupStatus.hasRejectedMarkup() ? REJECTED_ICON : DISABLED_REJECTED_ICON);
        icon.addIcon(markupStatus.hasDontKnowMarkup() || markupStatus.hasDontCareMarkup() ? IGNORED_ICON : DISABLED_IGNORED_ICON);
        icon.addIcon(markupStatus.hasErrors() ? ERROR_ICON : DISABLED_ERROR_ICON);
        this.setIcon((Icon)icon);
        this.setToolTipText(this.getDescription(markupStatus));
        return this;
    }

    private String getDescription(VTAssociationMarkupStatus status) {
        StringBuffer buf = new StringBuffer("<html>");
        if (!status.isInitialized()) {
            buf.append("Match has not been accepted; unknown markup status");
            return buf.toString();
        }
        ImageIcon icon = DISABLED_ICON;
        String message = "Has one or more \"Unexamined\" markup items";
        String fontColor = "gray";
        if (status.hasUnexaminedMarkup()) {
            icon = NOT_APPLIED_BASE_ICON;
            fontColor = "black";
        }
        buf.append("<img src=\"").append(icon.getDescription()).append("\" />");
        buf.append("<font color=\"").append(fontColor).append("\">");
        buf.append(message).append("</font><br>");
        icon = DISABLED_ICON;
        message = "Has one or more \"Applied\" markup items";
        fontColor = "gray";
        if (status.hasAppliedMarkup()) {
            icon = APPLIED_BASE_ICON;
            fontColor = "black";
        }
        buf.append("<img src=\"").append(icon.getDescription()).append("\" />");
        buf.append("<font color=\"").append(fontColor).append("\">");
        buf.append(message).append("</font><br>");
        icon = DISABLED_ICON;
        message = "Has one or more \"Rejected\" markup items to apply";
        fontColor = "gray";
        if (status.hasRejectedMarkup()) {
            icon = REJECTED_BASE_ICON;
            fontColor = "black";
        }
        buf.append("<img src=\"").append(icon.getDescription()).append("\" />");
        buf.append("<font color=\"").append(fontColor).append("\">");
        buf.append(message).append("</font><br>");
        icon = DISABLED_ICON;
        message = "Has one or more \"Ignored (Don't Know or Don't Care)\" markup items";
        fontColor = "gray";
        if (status.hasDontCareMarkup() || status.hasDontKnowMarkup()) {
            icon = IGNORED_BASE_ICON;
            fontColor = "black";
        }
        buf.append("<img src=\"").append(icon.getDescription()).append("\" />");
        buf.append("<font color=\"").append(fontColor).append("\">");
        buf.append(message).append("</font><br>");
        icon = DISABLED_ICON;
        message = "Has one or more \"Error\" markup items";
        fontColor = "gray";
        if (status.hasErrors()) {
            icon = ERROR_BASE_ICON;
            fontColor = "black";
        }
        buf.append("<img src=\"").append(icon.getDescription()).append("\" />");
        buf.append("<font color=\"").append(fontColor).append("\">");
        buf.append(message).append("</font><br>");
        return buf.toString();
    }

    public String getFilterString(VTMatch t, Settings settings) {
        VTAssociation association = t.getAssociation();
        VTAssociationMarkupStatus markupStatus = association.getMarkupStatus();
        String htmlDescription = this.getDescription(markupStatus);
        String raw = HTMLUtilities.fromHTML((String)htmlDescription);
        return raw;
    }
}

