/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pcodeInject;

public class PcodeTextEmitter {
    static final String RAM = "ram";

    private PcodeTextEmitter() {
        throw new AssertionError();
    }

    public static void emitPushCat1Value(StringBuilder pCode, String valueName) {
        pCode.append("SP = SP - 4;\n*:4 SP = ");
        pCode.append(valueName);
        pCode.append(";\n");
    }

    public static void emitPushCat2Value(StringBuilder pCode, String valueName) {
        pCode.append("SP = SP - 8;\n*:8 SP = ");
        pCode.append(valueName);
        pCode.append(";\n");
    }

    public static void emitPopCat2Value(StringBuilder pCode, String destName) {
        pCode.append(destName);
        pCode.append(":8 = *:8 SP;\nSP = SP + 8;\n");
    }

    public static void emitPopCat1Value(StringBuilder pCode, String destName) {
        pCode.append(destName);
        pCode.append(":4 = *:4 SP;\nSP = SP + 4;\n");
    }

    public static void emitAssignVarnodeFromPcodeOpCall(StringBuilder pCode, String varnodeName, int size, String pcodeop, String ... args) {
        pCode.append(varnodeName);
        pCode.append(":");
        pCode.append(Integer.toString(size));
        pCode.append(" = ");
        pCode.append(pcodeop);
        pCode.append("(");
        int numArgs = args.length;
        for (int i = 0; i < numArgs; ++i) {
            pCode.append(args[i]);
            if (i >= numArgs - 1) continue;
            pCode.append(",");
        }
        pCode.append(");\n");
    }

    public static void emitVoidPcodeOpCall(StringBuilder pCode, String pcodeop, String ... args) {
        pCode.append(pcodeop);
        pCode.append("(");
        int numArgs = args.length;
        for (int i = 0; i < numArgs; ++i) {
            pCode.append(args[i]);
            if (i >= numArgs - 1) continue;
            pCode.append(",");
        }
        pCode.append(");\n");
    }

    public static void emitAssignConstantToRegister(StringBuilder pCode, String register, int constant) {
        pCode.append(register);
        pCode.append(" = 0x");
        pCode.append(Integer.toHexString(constant));
        pCode.append(";\n");
    }

    public static void emitAssignRegisterFromPcodeOpCall(StringBuilder pCode, String register, String pcodeop, String ... args) {
        pCode.append(register);
        pCode.append(" = ");
        pCode.append(pcodeop);
        pCode.append("(");
        int numArgs = args.length;
        for (int i = 0; i < numArgs; ++i) {
            pCode.append(args[i]);
            if (i >= numArgs - 1) continue;
            pCode.append(",");
        }
        pCode.append(");\n");
    }

    public static void emitLabelDefinition(StringBuilder pCode, String caseName) {
        pCode.append("<");
        pCode.append(caseName);
        pCode.append(">\n");
    }

    public static void emitWriteToMemory(StringBuilder pCode, String space, int size, String offset, String value) {
        pCode.append("*[");
        pCode.append(space);
        pCode.append("]:");
        pCode.append(Integer.toString(size));
        pCode.append(" ");
        pCode.append(offset);
        pCode.append(" = ");
        pCode.append(value);
        pCode.append(";\n");
    }

    public static void emitIndirectCall(StringBuilder pCode, String target) {
        pCode.append("call [");
        pCode.append(target);
        pCode.append("];\n");
    }

    public static void emitAddToStackPointer(StringBuilder pCode, int amount) {
        pCode.append("SP = SP + ");
        pCode.append(Integer.toString(amount));
        pCode.append(";\n");
    }

    public static void emitSignExtension(StringBuilder pCode, String dest, int size, String src) {
        pCode.append(dest);
        pCode.append(":");
        pCode.append(Integer.toString(size));
        pCode.append(" = sext(");
        pCode.append(src);
        pCode.append(");\n");
    }

    public static void emitZeroExtension(StringBuilder pCode, String dest, int size, String src) {
        pCode.append(dest);
        pCode.append(":");
        pCode.append(Integer.toString(size));
        pCode.append(" = zext(");
        pCode.append(src);
        pCode.append(");\n");
    }

    public static void emitTruncate(StringBuilder pCode, String dest, int size, String src) {
        pCode.append(dest);
        pCode.append(" = ");
        pCode.append(src);
        pCode.append(":");
        pCode.append(Integer.toString(size));
        pCode.append(";\n");
    }
}

